/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.service.impl;

import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import com.sun.portal.common.logging.impl.LoggerService;
import com.sun.portal.common.service.Service;
import com.sun.portal.common.service.ServiceConfig;
import com.sun.portal.common.service.ServiceContext;
import com.sun.portal.common.service.ServiceException;
import com.sun.portal.common.service.impl.ServiceConfigImpl;
import com.sun.portal.common.util.TimeBoundExecutor;
import com.sun.portal.common.util.TimeBoundRunnable;
import com.sun.portal.common.util.TimeBoundRunnableException;
import com.sun.portal.common.util.TimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ServiceContextImpl
implements ServiceContext {
    public static final int EXCO_OFFSET = 100;
    public static final int EXCO_SERVICE_INIT = 100;
    public static final int EXCO_SERVICE_INIT_EXCEPTION = 101;
    public static final int EXCO_SERVICE_INIT_TIMEOUT = 102;
    public static final int EXCO_SERVICE_DESTROY = 103;
    public static final int EXCO_SERVICE_DESTROY_EXCEPTION = 104;
    public static final int EXCO_SERVICE_DESTROY_TIMEOUT = 105;
    private String _contextName;
    private Map _initParams;
    private Set _initParamNames;
    private Map _attributes;
    private Set _attributeNames;
    private ServiceData[] _servicesData;
    private Map _services;
    private LoggerService _logger;

    ServiceContextImpl(String name, Map initParams, ServiceData[] servicesData) {
        this._contextName = name;
        this._initParams = initParams;
        this._initParamNames = Collections.unmodifiableSet(this._initParams.keySet());
        this._attributes = Collections.synchronizedMap(new HashMap());
        this._attributeNames = Collections.unmodifiableSet(this._attributes.keySet());
        this._servicesData = servicesData;
    }

    synchronized void init() throws ServiceException {
        this._logger = (LoggerService)this.initService(this._servicesData[0], true);
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("ServiceContext[" + this._contextName + "], initializing");
        }
        this._services = new HashMap();
        for (int i = 1; i < this._servicesData.length; ++i) {
            String name = this._servicesData[i]._name;
            Service service = this.initService(this._servicesData[i], false);
            this._services.put(name, service);
        }
        if (this.getLogger().isLoggable(Level.INFO)) {
            this.getLogger().info("ServiceContext[" + this._contextName + "], initialized");
        }
    }

    private Service initService(ServiceData serviceData, boolean isLogger) throws ServiceException {
        TimeBoundExecutor tbExecutor = new TimeBoundExecutor();
        Service service = null;
        String name = serviceData._name;
        try {
            if (!isLogger && this.getLogger().isLoggable(Level.FINEST)) {
                this.getLogger().log(Level.FINEST, "Service[" + name + "], initializing");
            }
            Class<?> clazz = Class.forName(serviceData._className);
            service = (Service)clazz.newInstance();
            ServiceConfigImpl serviceConfig = new ServiceConfigImpl(name, this, serviceData._initParams);
            ServiceInitTimeBoundRunner runner = new ServiceInitTimeBoundRunner(service, serviceConfig);
            tbExecutor.run(runner, serviceData._initTimeout);
            if (!isLogger && this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, "Service[" + name + "], initialized");
            }
        }
        catch (TimeoutException tex) {
            String msg = "Service[" + name + "] initialization timed out";
            if (!isLogger) {
                this.getLogger().log(Level.SEVERE, msg, tex);
            }
            throw new ServiceException(102, "Service[" + name + "]", tex);
        }
        catch (TimeBoundRunnableException tbrex) {
            Throwable t = tbrex.getCause();
            String msg = "Service[" + name + "] initialization failed";
            if (!isLogger) {
                this.getLogger().log(Level.SEVERE, msg, t);
            }
            if (t instanceof ServiceException) {
                throw (ServiceException)t;
            }
            throw new ServiceException(101, "Service[" + name + "]", t);
        }
        catch (Exception ex) {
            String msg = "Service[" + name + "] instantiation failed";
            if (!isLogger) {
                this.getLogger().log(Level.SEVERE, msg, ex);
            }
            this.destroy();
            throw new ServiceException(100, msg, ex);
        }
        tbExecutor.destroy();
        return service;
    }

    synchronized void destroy() {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("ServiceContext[" + this._contextName + "], destroying");
        }
        for (int i = this._servicesData.length - 1; i >= 1; --i) {
            String name = this._servicesData[i]._name;
            Service service = (Service)this._services.get(name);
            this.destroyService(this._servicesData[i], service, false);
        }
        this._services = null;
        if (this.getLogger().isLoggable(Level.INFO)) {
            this.getLogger().info("ServiceContext[" + this._contextName + "], destroyed");
        }
        this.destroyService(this._servicesData[0], this._logger, true);
        this._logger = null;
    }

    private void destroyService(ServiceData serviceData, Service service, boolean isLogger) {
        TimeBoundExecutor tbExecutor;
        block8: {
            String name = serviceData._name;
            tbExecutor = new TimeBoundExecutor();
            try {
                if (!isLogger && this.getLogger().isLoggable(Level.FINEST)) {
                    this.getLogger().log(Level.FINEST, "Service[" + name + "], destroying");
                }
                ServiceDestroyTimeBoundRunner runner = new ServiceDestroyTimeBoundRunner(service);
                tbExecutor.run(runner, serviceData._destroyTimeout);
                if (!isLogger && this.getLogger().isLoggable(Level.FINER)) {
                    this.getLogger().log(Level.FINER, "Service[" + name + "], destroyed");
                }
            }
            catch (TimeoutException tex) {
                if (!isLogger) {
                    String msg = "Service[" + name + "] destruction timed out";
                    this.getLogger().log(Level.SEVERE, msg, tex);
                }
            }
            catch (TimeBoundRunnableException tbrex) {
                if (!isLogger) {
                    Throwable t = tbrex.getCause();
                    String msg = "Service[" + name + "] destruction failed";
                    this.getLogger().log(Level.SEVERE, msg, t);
                }
            }
            catch (Exception ex) {
                if (isLogger) break block8;
                String msg = "Service[" + name + "] destruction failed";
                this.getLogger().log(Level.SEVERE, msg, ex);
            }
        }
        tbExecutor.destroy();
    }

    public Service getService(String name) {
        return (Service)this._services.get(name);
    }

    public String getInitParameter(String name) {
        return (String)this._initParams.get(name);
    }

    public Iterator getInitParameterNames() {
        return this._initParamNames.iterator();
    }

    public Iterator getAttributeNames() {
        return this._attributeNames.iterator();
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    public Logger getLogger() {
        return this._logger;
    }

    private class ServiceDestroyTimeBoundRunner
    implements TimeBoundRunnable {
        private Service _service;

        public ServiceDestroyTimeBoundRunner(Service service) {
            this._service = service;
        }

        public void run() throws TimeBoundRunnableException {
            String name = null;
            try {
                name = this._service.getConfig().getServiceName();
                this._service.destroy();
            }
            catch (Exception ex) {
                throw new TimeBoundRunnableException(ex);
            }
        }
    }

    private class ServiceInitTimeBoundRunner
    implements TimeBoundRunnable {
        private Service _service;
        private ServiceConfig _config;

        public ServiceInitTimeBoundRunner(Service service, ServiceConfig config) {
            this._service = service;
            this._config = config;
        }

        public void run() throws TimeBoundRunnableException {
            try {
                this._service.init(this._config);
            }
            catch (Exception ex) {
                throw new TimeBoundRunnableException(ex);
            }
        }
    }

    static class ServiceData {
        private String _name;
        private String _className;
        private Map _initParams;
        private int _initTimeout;
        private int _destroyTimeout;

        public ServiceData(String name, String className, Map initParams, int initTimeout, int destroyTimeout) {
            this._name = name;
            this._className = className;
            this._initParams = initParams;
            this._initTimeout = initTimeout;
            this._destroyTimeout = destroyTimeout;
        }
    }
}

