/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.service.impl;

import com.sun.portal.common.logging.Logger;
import com.sun.portal.common.service.ServiceContainer;
import com.sun.portal.common.service.ServiceContext;
import com.sun.portal.common.service.ServiceException;
import com.sun.portal.common.service.impl.ServiceContextImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ServiceContainerImpl
extends ServiceContainer {
    public static final int EXCO_OFFSET = 0;
    public static final int EXCO_SERVICE_CONTEXT_FACTORY_INIT = 0;
    private static final String SERVICES_DD_FILE = "services.xml";
    private static final String SERVICES_E = "services";
    private static final String SERVICES_INIT_PARAM_E = "init-param";
    private static final String SERVICES_INIT_PARAM_NAME_E = "param-name";
    private static final String SERVICES_INIT_PARAM_VALUE_E = "param-value";
    private static final String LOGGER_SERVICE_E = "logger-service";
    private static final String SERVICE_E = "service";
    private static final String SERVICE_NAME_E = "service-name";
    private static final String SERVICE_CLASS_E = "service-class";
    private static final String SERVICE_INIT_TIME_OUT_E = "init-timeout";
    private static final String SERVICE_DESTROY_TIME_OUT_E = "destroy-timeout";
    private static final String SERVICE_INIT_PARAM_E = "init-param";
    private static final String SERVICE_INIT_PARAM_NAME_E = "param-name";
    private static final String SERVICE_INIT_PARAM_VALUE_E = "param-value";
    private ServiceContextImpl _context;

    public void init() throws ServiceException {
        HashMap<String, String> initParams = new HashMap<String, String>();
        ServiceContextImpl.ServiceData[] serviceData = null;
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(SERVICES_DD_FILE);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            is.close();
            Element servicesE = doc.getRootElement();
            List servicesInitParamsE = servicesE.getChildren("init-param");
            for (int i = 0; i < servicesInitParamsE.size(); ++i) {
                Element initParam = (Element)servicesInitParamsE.get(i);
                String name = initParam.getChild("param-name").getTextTrim();
                String value = initParam.getChild("param-value").getTextTrim();
                initParams.put(name, value);
            }
            ArrayList<ServiceContextImpl.ServiceData> services = new ArrayList<ServiceContextImpl.ServiceData>();
            Element loggerE = servicesE.getChild(LOGGER_SERVICE_E);
            services.add(this.parseService(loggerE, "defaultCtxLog"));
            List serviceListE = servicesE.getChildren(SERVICE_E);
            for (int i = 0; i < serviceListE.size(); ++i) {
                Element serviceE = (Element)serviceListE.get(i);
                services.add(this.parseService(serviceE, null));
            }
            serviceData = new ServiceContextImpl.ServiceData[services.size()];
            services.toArray(serviceData);
        }
        catch (Exception ex) {
            throw new ServiceException(0, "reading SDD", ex);
        }
        this._context = new ServiceContextImpl("default", initParams, serviceData);
        this._context.init();
        Logger logger = this._context.getLogger();
        if (logger != null) {
            logger.info("ServiceContainer, initialized");
        }
    }

    private ServiceContextImpl.ServiceData parseService(Element serviceE, String forceName) {
        String serviceName = forceName != null ? forceName : serviceE.getChild(SERVICE_NAME_E).getTextTrim();
        String serviceClassName = serviceE.getChild(SERVICE_CLASS_E).getTextTrim();
        int initTimeout = -1;
        Element initTimeoutE = serviceE.getChild(SERVICE_INIT_TIME_OUT_E);
        if (initTimeoutE != null) {
            initTimeout = Integer.parseInt(initTimeoutE.getTextTrim());
        }
        int destroyTimeout = -1;
        Element destroyTimeoutE = serviceE.getChild(SERVICE_DESTROY_TIME_OUT_E);
        if (destroyTimeoutE != null) {
            destroyTimeout = Integer.parseInt(destroyTimeoutE.getTextTrim());
        }
        HashMap<String, String> serviceInitParams = new HashMap<String, String>();
        List serviceInitParamsE = serviceE.getChildren("init-param");
        for (int j = 0; j < serviceInitParamsE.size(); ++j) {
            Element initParam = (Element)serviceInitParamsE.get(j);
            String name = initParam.getChild("param-name").getTextTrim();
            String value = initParam.getChild("param-value").getTextTrim();
            serviceInitParams.put(name, value);
        }
        return new ServiceContextImpl.ServiceData(serviceName, serviceClassName, serviceInitParams, initTimeout, destroyTimeout);
    }

    public ServiceContext getContext(String name) {
        return name.equals("default") ? this._context : null;
    }

    public void destroy() {
        Logger logger = this._context.getLogger();
        if (logger != null) {
            logger.info("ServiceContainer, destroying");
        }
        this._context.destroy();
    }
}

