/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.pool;

import com.sun.portal.common.pool.ObjectManager;
import com.sun.portal.common.pool.ObjectPool;
import com.sun.portal.common.pool.ParallelObjectPool;
import com.sun.portal.common.pool.ReusableThread;

public class ThreadPool {
    private ObjectPool _pool;

    public ThreadPool(int minSize, int maxSize, boolean overflow, int partitions) {
        this._pool = new ObjectPool(new ThreadManager(this), minSize, maxSize, overflow, partitions);
    }

    public ReusableThread obtainThread(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("ThreadPool.obtainThread() - runnable can not be null");
        }
        ReusableThread rt = (ReusableThread)this._pool.getPool().obtainObject(null);
        if (rt != null) {
            rt.setRunnable(runnable);
            rt.setReuseThread(this._pool.getPool().doesReuseObjects());
        }
        return rt;
    }

    void releaseThread(ReusableThread thread) {
        this._pool.getPool().releaseObject(thread);
    }

    public int getLeased() {
        return this._pool.getPool().getLeased();
    }

    public int getMinSize() {
        return this._pool.getPool().getMinSize();
    }

    public int getMaxSize() {
        return this._pool.getPool().getMaxSize();
    }

    public void setMaxSize(int maxSize) {
        this._pool.getPool().setMaxSize(maxSize);
    }

    public void destroy() {
        this._pool.getPool().destroy();
    }

    public int[] getPartitionUse() {
        return this._pool.getPool() instanceof ParallelObjectPool ? ((ParallelObjectPool)this._pool.getPool()).getPartitionUse() : null;
    }

    private static class ThreadManager
    implements ObjectManager {
        private ThreadPool _threadPool;

        private ThreadManager(ThreadPool threadPool) {
            this._threadPool = threadPool;
        }

        public Object createObject(Object param) {
            return new ReusableThread(this._threadPool);
        }

        public void destroyObject(Object o) {
            ((ReusableThread)o).finish();
        }
    }
}

