/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.pool;

import com.sun.portal.common.pool.ObjectManager;
import com.sun.portal.common.pool.Pool;

public class NullObjectPool
implements Pool {
    private ObjectManager _objectManager;
    private boolean _destroyed;
    private int _leased;

    public NullObjectPool(ObjectManager objectManager) {
        this._objectManager = objectManager;
        this._destroyed = false;
    }

    public Object obtainObject(Object param) {
        if (this._destroyed) {
            throw new IllegalStateException();
        }
        ++this._leased;
        return this._objectManager.createObject(param);
    }

    public void releaseObject(Object o) {
        this._objectManager.destroyObject(o);
        --this._leased;
    }

    public int getLeased() {
        return this._leased;
    }

    public int getMinSize() {
        return 0;
    }

    public int getMaxSize() {
        return 0;
    }

    public void setMaxSize(int maxSize) {
    }

    public void destroy() {
        this._destroyed = true;
    }

    public final boolean doesReuseObjects() {
        return false;
    }
}

