/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.logging.impl;

import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import com.sun.portal.common.logging.impl.LogOutputStream;
import com.sun.portal.common.logging.impl.LogWriter;
import com.sun.portal.common.text.QuickMessageFormat;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class LoggerImpl
implements Logger {
    public static final String LOG_LEVEL = "log.level";
    public static final String FILE_NAME = "file.name";
    public static final String FILE_ROLLOVER = "file.rollover";
    public static final String FILE_BUFFER = "file.buffer";
    public static final String FILE_FLUSHTIME = "file.flushtime";
    private static final String LOG_LEVEL_NAME = "LOG    ";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS zzz");
    private static final QuickMessageFormat LOG_LINE = new QuickMessageFormat("{0} | {1} | {2} | {3} | {4} | {5}\n");
    private static final QuickMessageFormat LOGP = new QuickMessageFormat("{0}.{1}() - {2}");
    private static final QuickMessageFormat ENTERING = new QuickMessageFormat("{0}.{1} ENTRY ({2})");
    private static final QuickMessageFormat EXITS = new QuickMessageFormat("{0}.{1}() RETURN ({2})");
    private static final QuickMessageFormat THROWS = new QuickMessageFormat("{0}.{1}() THROWS ({2})");
    private String _name;
    private Level _level;
    private int _traceLevel;
    private Writer _writer;
    private boolean _writerIsSystemErr;

    public void init(String name, Properties config) {
        try {
            this._name = name;
            this._level = LoggerImpl.parseLevel(config.getProperty(LOG_LEVEL));
            String fileName = config.getProperty(FILE_NAME);
            String rollover = config.getProperty(FILE_ROLLOVER);
            String buffer = config.getProperty(FILE_BUFFER);
            String flushtime = config.getProperty(FILE_FLUSHTIME);
            LogOutputStream os = new LogOutputStream(new File(fileName), Long.parseLong(rollover), Integer.parseInt(buffer), Integer.parseInt(flushtime));
            this._writer = new LogWriter(os);
            this.writeFields();
            this.write(LOG_LEVEL_NAME, "Logger begins", null);
            this.setLevel(this._level);
        }
        catch (Exception ex) {
            throw new RuntimeException("LoggerImpl.init() - Could nit initialize Log file, " + ex.getMessage());
        }
    }

    public void destroy() {
        try {
            this.write(LOG_LEVEL_NAME, "Logger ends  ", null);
            this._writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Level parseLevel(String levelStr) {
        Level level = Level.ALL;
        if (Level.SEVERE.getName().equals(levelStr)) {
            level = Level.SEVERE;
        } else if (Level.WARNING.getName().equals(levelStr)) {
            level = Level.WARNING;
        } else if (Level.INFO.getName().equals(levelStr)) {
            level = Level.INFO;
        } else if (Level.CONFIG.getName().equals(levelStr)) {
            level = Level.CONFIG;
        } else if (Level.FINE.getName().equals(levelStr)) {
            level = Level.FINE;
        } else if (Level.FINER.getName().equals(levelStr)) {
            level = Level.FINER;
        } else if (Level.FINEST.getName().equals(levelStr)) {
            level = Level.FINEST;
        } else if (Level.ALL.getName().equals(levelStr)) {
            level = Level.ALL;
        } else if (Level.OFF.getName().equals(levelStr)) {
            level = Level.OFF;
        }
        return level;
    }

    private void writeFields() {
        block4: {
            String[] params = new String[]{"TIME                       ", "LOGGER NAME      ", "LEVEL  ", "THREAD ID      ", "MESSAGE   ", "EXCEPTION"};
            String line = LOG_LINE.format(params);
            try {
                this._writer.write(line);
            }
            catch (IOException ex) {
                if (this._writerIsSystemErr) break block4;
                this._writerIsSystemErr = true;
                this._writer = new PrintWriter(System.err, true);
                this.write(LOG_LEVEL_NAME, "LOG FILE FAILED - Could not write to log file, fallback to standard error", ex);
                try {
                    this._writer.write(line);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
    }

    private void write(String level, String msg, Throwable exception) {
        block4: {
            try {
                String[] params = new String[]{DATE_FORMAT.format(new Date()), (this._name + "                 ").substring(0, 17), level, (Thread.currentThread().getName() + "               ").substring(0, 15), msg, exception != null ? exception.getMessage() : "-"};
                String line = LOG_LINE.format(params);
                if (exception != null) {
                    StringBuffer sb = new StringBuffer(1024);
                    sb.append("x -----------------------------------------------------------------------------\n");
                    CharArrayWriter caw = new CharArrayWriter(4096);
                    PrintWriter pw = new PrintWriter(caw);
                    exception.printStackTrace(pw);
                    pw.close();
                    String st = caw.toString();
                    int start = 0;
                    int pos = st.indexOf("\n", 0);
                    while (pos > -1) {
                        sb.append("X ").append(st.substring(start, pos + 1));
                        start = pos + 1;
                        pos = st.indexOf("\n", start);
                    }
                    sb.append("X -----------------------------------------------------------------------------\n");
                    line = line + sb.toString();
                }
                this._writer.write(line);
            }
            catch (IOException ex) {
                if (this._writerIsSystemErr) break block4;
                this._writerIsSystemErr = true;
                this._writer = new PrintWriter(System.err, true);
                this.write(LOG_LEVEL_NAME, "LOG FILE FAILED - Could not write to log file, fallback to standard error", ex);
                this.write(level.toString(), msg, exception);
            }
        }
    }

    public Level getLevel() {
        return this._level;
    }

    public void setLevel(Level level) {
        this._level = level;
        this._traceLevel = this._level.intValue();
        this.write(LOG_LEVEL_NAME, "Logger log level set to: " + level.getName(), null);
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this._traceLevel && this._traceLevel != Level.OFF.intValue();
    }

    public void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            this.write(level.toString(), msg, null);
        }
    }

    public void log(Level level, String msg, String param) {
        if (this.isLoggable(level)) {
            msg = QuickMessageFormat.format(msg, param);
            this.write(level.toString(), msg, null);
        }
    }

    public void log(Level level, String msg, String[] params) {
        if (this.isLoggable(level)) {
            msg = QuickMessageFormat.format(msg, params);
            this.write(level.toString(), msg, null);
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.write(level.toString(), msg, thrown);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (this.isLoggable(level)) {
            msg = LOGP.format(new String[]{sourceClass, sourceMethod, msg});
            this.write(level.toString(), msg, null);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, String param) {
        if (this.isLoggable(level)) {
            msg = QuickMessageFormat.format(msg, param);
            msg = LOGP.format(new String[]{sourceClass, sourceMethod, msg});
            this.write(level.toString(), msg, null);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, String[] params) {
        if (this.isLoggable(level)) {
            msg = QuickMessageFormat.format(msg, params);
            msg = LOGP.format(new String[]{sourceClass, sourceMethod, msg});
            this.write(level.toString(), msg, null);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            msg = LOGP.format(new String[]{sourceClass, sourceMethod, msg});
            this.write(level.toString(), msg, thrown);
        }
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            String msg = ENTERING.format(new String[]{sourceClass, sourceMethod, ""});
            this.write(Level.FINER.toString(), msg, null);
        }
    }

    public void entering(String sourceClass, String sourceMethod, String param) {
        if (this.isLoggable(Level.FINER)) {
            String msg = ENTERING.format(new String[]{sourceClass, sourceMethod, param});
            this.write(Level.FINER.toString(), msg, null);
        }
    }

    public void entering(String sourceClass, String sourceMethod, String[] params) {
        if (this.isLoggable(Level.FINER)) {
            int separator = 32;
            StringBuffer sb = new StringBuffer(100 * params.length);
            for (int i = 0; i < params.length; ++i) {
                sb.append((char)separator).append(params[i]);
                separator = 44;
            }
            String msg = ENTERING.format(new String[]{sourceClass, sourceMethod, sb.toString()});
            this.write(Level.FINER.toString(), msg, null);
        }
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (this.isLoggable(Level.FINER)) {
            String msg = ENTERING.format(new String[]{sourceClass, sourceMethod, ""});
            this.write(Level.FINER.toString(), msg, null);
        }
    }

    public void exiting(String sourceClass, String sourceMethod, String result) {
        if (this.isLoggable(Level.FINER)) {
            String msg = ENTERING.format(new String[]{sourceClass, sourceMethod, result.toString()});
            this.write(Level.FINER.getName(), msg, null);
        }
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.isLoggable(Level.FINER)) {
            String msg = THROWS.format(new String[]{sourceClass, sourceMethod, thrown.getMessage()});
            this.write(Level.FINER.toString(), msg, thrown);
        }
    }

    public void severe(String msg) {
        if (this.isLoggable(Level.SEVERE)) {
            this.write(Level.SEVERE.toString(), msg, null);
        }
    }

    public void warning(String msg) {
        if (this.isLoggable(Level.WARNING)) {
            this.write(Level.WARNING.toString(), msg, null);
        }
    }

    public void info(String msg) {
        if (this.isLoggable(Level.INFO)) {
            this.write(Level.INFO.toString(), msg, null);
        }
    }

    public void config(String msg) {
        if (this.isLoggable(Level.CONFIG)) {
            this.write(Level.CONFIG.toString(), msg, null);
        }
    }

    public void fine(String msg) {
        if (this.isLoggable(Level.FINE)) {
            this.write(Level.FINE.toString(), msg, null);
        }
    }

    public void finer(String msg) {
        if (this.isLoggable(Level.FINER)) {
            this.write(Level.FINER.toString(), msg, null);
        }
    }

    public void finest(String msg) {
        if (this.isLoggable(Level.FINEST)) {
            this.write(Level.FINEST.toString(), msg, null);
        }
    }
}

