/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DeltaMap
implements Map {
    public static final int PUT = 0;
    public static final int REMOVE = 1;
    private Map _mainMap;
    private Map _deltas;
    private boolean _removedAll;
    private boolean _changed;

    public DeltaMap(Map map) {
        this._mainMap = map;
        this._deltas = new HashMap();
    }

    public Map getMainMap() {
        return this._mainMap;
    }

    public boolean hasDeltas() {
        return this._changed;
    }

    public Collection getDeltas() {
        return this._deltas.values();
    }

    public void applyDeltas() {
        if (this._changed) {
            if (this._removedAll) {
                this._mainMap.clear();
            }
            Iterator iterator = this._deltas.keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                DeltaEntry entry = (DeltaEntry)this._deltas.get(key);
                if (entry._action == 0) {
                    this._mainMap.put(key, entry._value);
                    continue;
                }
                this._mainMap.remove(key);
            }
            this._deltas.clear();
            this._changed = false;
        }
    }

    public int size() {
        int size = this._removedAll ? 0 : this._mainMap.size();
        Iterator iterator = this._deltas.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            DeltaEntry entry = (DeltaEntry)this._deltas.get(key);
            if (entry._action == 0) {
                size += this._mainMap.containsKey(key) ? 0 : 1;
                continue;
            }
            --size;
        }
        return size;
    }

    public boolean isEmpty() {
        return this._deltas.isEmpty() && (this._removedAll || this._mainMap.isEmpty());
    }

    public boolean containsKey(Object key) {
        boolean isIn = this._removedAll ? false : this._mainMap.containsKey(key);
        DeltaEntry entry = (DeltaEntry)this._deltas.get(key);
        return entry == null ? isIn : entry._action == 0;
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Object get(Object key) {
        Object value = this._removedAll ? null : (Object)this._mainMap.get(key);
        DeltaEntry entry = (DeltaEntry)this._deltas.get(key);
        if (entry != null) {
            value = entry._action == 0 ? entry._value : null;
        }
        return value;
    }

    public Object put(Object key, Object value) {
        this._changed = true;
        Object oldValue = this.get(key);
        this._deltas.put(key, new DeltaEntry(0, key, value));
        return oldValue;
    }

    public Object remove(Object key) {
        this._changed = true;
        Object oldValue = this.get(key);
        this._deltas.put(key, new DeltaEntry(1, key, null));
        return oldValue;
    }

    public void putAll(Map t) {
        Iterator iterator = t.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = t.get(key);
            this.put(key, value);
        }
    }

    public void clear() {
        this._changed = true;
        this._removedAll = true;
        this._deltas.clear();
    }

    public Set keySet() {
        HashSet keys = this._removedAll ? new HashSet() : new HashSet(this._mainMap.keySet());
        Iterator iterator = this._deltas.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            DeltaEntry entry = (DeltaEntry)this._deltas.get(key);
            if (entry._action == 0) {
                keys.add(key);
                continue;
            }
            keys.remove(key);
        }
        return Collections.unmodifiableSet(keys);
    }

    public Collection values() {
        ArrayList values = new ArrayList();
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            values.add(entry.getValue());
        }
        return Collections.unmodifiableCollection(values);
    }

    public Set entrySet() {
        HashSet<MapEntry> entrySet = new HashSet<MapEntry>();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = this.get(key);
            entrySet.add(new MapEntry(key, value));
        }
        return entrySet;
    }

    private static class MapEntry
    implements Map.Entry {
        private Object _key;
        private Object _value;

        public MapEntry(Object key, Object value) {
            this._key = key;
            this._value = value;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("ParallelHashMap.MapEntry.setValue()");
        }

        public String toString() {
            return "(" + this._key + "," + this._value + ")";
        }
    }

    public static class DeltaEntry {
        private int _action;
        private Object _key;
        private Object _value;

        private DeltaEntry(int action, Object key, Object value) {
            this._action = action;
            this._key = key;
            this._value = value;
        }

        public int getAction() {
            return this._action;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public String toString() {
            return "Delta: action=" + (this._action == 0 ? "PUT" : "REMOVE") + " key=" + this._key + " value=" + this._value;
        }
    }
}

