/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.demo;

import com.sun.portal.search.rdm.RDMHeader;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.util.Encoder;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;

public class Search {
    protected String query;
    protected String scope;
    protected String database;
    protected String RDMServer;
    protected String viewAttributes;
    protected String viewOrder;
    protected String SSOToken;
    protected int viewHits;
    protected int firstHit;
    protected String RDMType;
    protected String queryLanguage;
    private boolean streamMode = false;
    private SOIFInputStream resultStream;
    private RDMHeader rdmHeader;
    private boolean doSOIFParse;
    private int RDM_Results = 0;
    private int RDM_Hits = 0;
    private int RDM_Documents = 0;
    private String RDM_Response_Interpret = null;
    public String proxyDN = null;

    public Search() {
        this.scope = "";
        this.viewAttributes = "";
        this.viewOrder = "";
        this.firstHit = 0;
        this.viewHits = 0;
        this.queryLanguage = "";
        this.database = null;
        this.query = "";
        this.doSOIFParse = false;
        this.RDMServer = "";
        this.RDMType = "rd-request";
        this.SSOToken = "";
    }

    public Search(String string, String string2) {
        this(string, "", "", 1, 10, "search", null, string2, "");
    }

    public Search(String string, String string2, String string3, int n, int n2, String string4, String string5, String string6, String string7) {
        this.scope = string;
        this.viewAttributes = string2;
        this.viewOrder = string3;
        this.firstHit = n;
        this.viewHits = n2;
        this.queryLanguage = string4;
        this.database = string5;
        this.RDMType = "rd-request";
        this.doSOIFParse = true;
        this.SSOToken = string7;
        this.RDMServer = string6;
    }

    public void setSOIFParse(boolean bl) {
        this.doSOIFParse = bl;
    }

    public void setStreamMode(boolean bl) {
        this.streamMode = bl;
    }

    public int getFirstHit() {
        return this.firstHit;
    }

    public void setFirstHit(int n) {
        this.firstHit = n;
    }

    public int getViewHits() {
        return this.viewHits;
    }

    public void setViewHits(int n) {
        this.viewHits = n;
    }

    public String getRDMServer() {
        return this.RDMServer;
    }

    public void setRDMServer(String string) {
        this.RDMServer = string;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public String getRDMType() {
        return this.RDMType;
    }

    public String getProxyDN() {
        return this.proxyDN;
    }

    public void setProxyDN(String string) {
        this.proxyDN = string;
    }

    public void setRDMType(String string) {
        this.RDMType = string;
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public void setQueryLanguage(String string) {
        this.queryLanguage = string;
    }

    public String getViewAttributes() {
        return this.viewAttributes;
    }

    public void setViewAttributes(String string) {
        this.viewAttributes = string;
    }

    public String getViewOrder() {
        return this.viewOrder;
    }

    public void setViewOrder(String string) {
        this.viewOrder = string;
    }

    public String getQuery() {
        this.query = this.formatQuery();
        return this.query;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setSessionID(String string) {
        this.SSOToken = string;
    }

    public String getSessionID() {
        return this.SSOToken;
    }

    public void doQuery() {
        this.rdmHeader = null;
        this.RDM_Response_Interpret = null;
        this.query = this.formatQuery();
        try {
            URLConnection uRLConnection = new URL(this.query).openConnection();
            uRLConnection.setAllowUserInteraction(true);
            this.resultStream = new SOIFInputStream(uRLConnection.getInputStream());
            this.rdmHeader = new RDMHeader(this.resultStream);
            String string = this.rdmHeader.getErrorMessage();
            if (string != null && !string.equalsIgnoreCase("0 results")) {
                System.out.println("RDM Error: " + string);
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return;
        }
    }

    public void doQuery(int n, int n2) {
        this.setFirstHit(n);
        this.setViewHits(n2);
        this.doQuery();
    }

    public SOIF getRDMHeaderSOIF() {
        return this.rdmHeader.getSOIF();
    }

    public SOIFInputStream getResultStream() {
        return this.resultStream;
    }

    private void parseResponseHeader() {
        if (this.RDM_Response_Interpret == null && this.rdmHeader != null) {
            this.RDM_Response_Interpret = this.rdmHeader.getResponseInterpret();
        }
        if (this.RDM_Response_Interpret == null) {
            return;
        }
        String string = this.RDM_Response_Interpret;
        try {
            this.RDM_Results = this.getKeyedInt(string, "result");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.RDM_Hits = this.getKeyedInt(string, "hit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.RDM_Documents = this.getKeyedInt(string, "document");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getKeyedInt(String string, String string2) throws NumberFormatException {
        int n = 0;
        try {
            String string3 = " " + string2;
            int n2 = string.indexOf(string3);
            if (n2 <= 0) {
                throw new Exception();
            }
            --n2;
            while (n2 >= 0 && string.charAt(n2) == ' ') {
                --n2;
            }
            int n3 = n2 + 1;
            while (n2 >= 0 && string.charAt(n2) != ' ') {
                --n2;
            }
            int n4 = n2 + 1;
            String string4 = string.substring(n4, n3);
            n = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            throw new NumberFormatException();
        }
        return n;
    }

    public int getResultCount() {
        this.parseResponseHeader();
        return this.RDM_Results;
    }

    public int getHitCount() {
        this.parseResponseHeader();
        return this.RDM_Hits;
    }

    public int getDocumentCount() {
        this.parseResponseHeader();
        return this.RDM_Documents;
    }

    public int getToHit() {
        return this.firstHit + this.getResultCount() - 1;
    }

    public boolean noHits() {
        return this.getResultCount() <= 0;
    }

    public String toString() {
        return "Search instance:\n\tRDMType    = [" + this.RDMType + "]\n" + "\tqueryLanguage         = [" + this.queryLanguage + "]\n" + "\tscope      = [" + this.scope + "]\n" + "\tviewAttributes = [" + this.viewAttributes + "]\n" + "\tviewOrder  = [" + this.viewOrder + "]\n" + "\tviewHits   = [" + this.firstHit + ".." + (this.firstHit + this.viewHits - 1) + "]\n" + "\tdatabase   = [" + this.database + "]\n" + "\tRDMServer  = [" + this.RDMServer + "]\n" + "\tSSOToken   = [" + this.SSOToken + "]\n";
    }

    private String formatQuery() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (this.RDMServer != null) {
                stringBuffer.append(this.RDMServer);
            }
            if (this.RDMType != null) {
                stringBuffer.append("?type=" + this.RDMType);
            }
            if (this.queryLanguage != null) {
                stringBuffer.append("&ql=" + this.queryLanguage);
            }
            if (this.scope != null) {
                stringBuffer.append("&scope=").append(Encoder.urlEncode(this.scope, "UTF-8"));
            }
            if (this.viewAttributes != null) {
                stringBuffer.append("&view-attributes=").append(Encoder.urlEncode(this.viewAttributes, "UTF-8"));
            }
            if (this.viewOrder != null) {
                stringBuffer.append("&view-order=").append(Encoder.urlEncode(this.viewOrder, "UTF-8"));
            }
            if (this.viewHits != 0) {
                stringBuffer.append("&view-hits=").append(this.firstHit + ".." + (this.firstHit + this.viewHits - 1));
            }
            if (this.database != null) {
                stringBuffer.append("&database=").append(Encoder.urlEncode(this.database, "UTF-8"));
            }
            if (this.SSOToken != null) {
                stringBuffer.append("&stoken=").append(Encoder.urlEncode(this.SSOToken, "UTF-8"));
            }
            if (this.proxyDN != null) {
                stringBuffer.append("&proxyDN=").append(Encoder.urlEncode(this.proxyDN, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

