/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.BasicCookieBox;
import HTTPClient.Cookie;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.Util;

class DefaultCookiePolicyHandler
implements CookiePolicyHandler {
    private String[] accept_domains = new String[0];
    private String[] reject_domains = new String[0];
    private BasicCookieBox popup = null;

    DefaultCookiePolicyHandler() {
        String string;
        try {
            string = System.getProperty("HTTPClient.cookies.hosts.accept");
        }
        catch (Exception exception) {
            string = null;
        }
        String[] stringArray = Util.splitProperty(string);
        int n = 0;
        while (n < stringArray.length) {
            this.addAcceptDomain(stringArray[n].toLowerCase());
            ++n;
        }
        try {
            string = System.getProperty("HTTPClient.cookies.hosts.reject");
        }
        catch (Exception exception) {
            string = null;
        }
        stringArray = Util.splitProperty(string);
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.addRejectDomain(stringArray[n2].toLowerCase());
            ++n2;
        }
    }

    public boolean acceptCookie(Cookie cookie, RoRequest roRequest, RoResponse roResponse) {
        String string = roRequest.getConnection().getHost();
        if (string.indexOf(46) == -1) {
            string = string + ".local";
        }
        int n = 0;
        while (n < this.reject_domains.length) {
            if (this.reject_domains[n].length() == 0 || this.reject_domains[n].charAt(0) == '.' && string.endsWith(this.reject_domains[n]) || this.reject_domains[n].charAt(0) != '.' && string.equals(this.reject_domains[n])) {
                return false;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.accept_domains.length) {
            if (this.accept_domains[n2].length() == 0 || this.accept_domains[n2].charAt(0) == '.' && string.endsWith(this.accept_domains[n2]) || this.accept_domains[n2].charAt(0) != '.' && string.equals(this.accept_domains[n2])) {
                return true;
            }
            ++n2;
        }
        if (!roRequest.allowUI()) {
            return true;
        }
        if (this.popup == null) {
            this.popup = new BasicCookieBox();
        }
        return this.popup.accept(cookie, this, string);
    }

    public boolean sendCookie(Cookie cookie, RoRequest roRequest) {
        return true;
    }

    void addAcceptDomain(String string) {
        if (string.indexOf(46) == -1 && string.length() > 0) {
            string = string + ".local";
        }
        int n = 0;
        while (n < this.accept_domains.length) {
            if (string.endsWith(this.accept_domains[n])) {
                return;
            }
            if (this.accept_domains[n].endsWith(string)) {
                this.accept_domains[n] = string;
                return;
            }
            ++n;
        }
        this.accept_domains = Util.resizeArray(this.accept_domains, this.accept_domains.length + 1);
        this.accept_domains[this.accept_domains.length - 1] = string;
    }

    void addRejectDomain(String string) {
        if (string.indexOf(46) == -1 && string.length() > 0) {
            string = string + ".local";
        }
        int n = 0;
        while (n < this.reject_domains.length) {
            if (string.endsWith(this.reject_domains[n])) {
                return;
            }
            if (this.reject_domains[n].endsWith(string)) {
                this.reject_domains[n] = string;
                return;
            }
            ++n;
        }
        this.reject_domains = Util.resizeArray(this.reject_domains, this.reject_domains.length + 1);
        this.reject_domains[this.reject_domains.length - 1] = string;
    }
}

