/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.protocol;

import com.sun.portal.netmail.protocol.AddressList;
import com.sun.portal.netmail.protocol.Controller;
import com.sun.portal.netmail.protocol.Folder;
import com.sun.portal.netmail.protocol.MessagePart;
import com.sun.portal.netmail.protocol.Requestor;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class Message
extends MessagePart
implements Cloneable,
Serializable,
Requestor {
    public static final byte recentFlag = 1;
    public static final byte deletedFlag = 4;
    public static final int copyOTHER = 2;
    Vector targetMessages;
    public transient int displayIndex = -1;
    public Folder folder;
    public String subj = "";
    Message originalMessage;
    public long UID = -1L;
    Vector targetFolderRefs;
    public byte flags = 0;
    public transient boolean found = false;
    transient byte resyncFlags;
    public AddressList to;
    public static final int statusSeen = 1;
    public AddressList cc;
    public int intsize = 0;
    int IMAPnum = 0;
    public Date date;
    public static final byte seenFlag = 8;
    public boolean isAttachment = false;
    public static final int statusDeleted = 0;
    public AddressList from = new AddressList();
    public static final int copyOK = 0;
    public int sizeLines = 0;
    public static final byte answeredFlag = 2;
    public static final int statusUnread = 3;
    public byte serverFlags = 0;
    public AddressList replyto;
    public transient String griddate = null;
    public String fullheader = null;
    public MessagePart[] messageParts;
    public int statusweight = 0;
    public static final int statusNew = 4;
    public static final int copyNOFOLDER = 1;
    public static final int statusReplied = 2;

    void updateFlags(Controller controller, byte by) {
        this.resyncFlags = this.serverFlags = by;
        this.flags = this.serverFlags;
        this.markStatus();
        controller.messageUpdated(this);
    }

    public Message(Folder folder, int n) {
        this.to = new AddressList();
        this.cc = new AddressList();
        this.replyto = new AddressList();
        this.date = new Date();
        this.messageParts = new MessagePart[0];
        this.folder = folder;
        this.originalMessage = null;
        this.setIMAPnumber(n);
        this.markStatus();
    }

    public boolean flagsChanged() {
        return this.flags != this.serverFlags;
    }

    public boolean isDeleted() {
        return (this.flags & 4) != 0;
    }

    public void loadFullHeader(Controller controller) {
        controller.getRequest().startOp((Requestor)this, 14, this.getRef());
    }

    public int statusWeight() {
        return this.statusweight;
    }

    public boolean flagsMatchForCopy(Message message) {
        return message.flags == this.serverFlags;
    }

    public int load(Controller controller, boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        for (int i = 0; i < this.messageParts.length; ++i) {
            if (bl) {
                n += this.messageParts[i].load(controller, bl, bl2, bl3);
                continue;
            }
            if (!this.messageParts[i].getMIMEType().equalsIgnoreCase("text/plain")) continue;
            n += this.messageParts[i].load(controller, bl, bl2, bl3);
            break;
        }
        return n;
    }

    public void markStatus() {
        this.statusweight = (this.flags & 4) != 0 ? 0 : ((this.flags & 2) != 0 ? 2 : ((this.flags & 1) != 0 && (this.flags & 8) == 0 ? 4 : ((this.flags & 8) != 0 ? 1 : 3)));
    }

    public synchronized void setFlagsFromMsg(Controller controller, Message message) {
        if (this.folder != null && this.UID != -1L) {
            Serializable[] serializableArray = new Serializable[]{this.getRef(), new Byte(message.flags)};
            controller.getRequest().startOp((Requestor)this, 13, serializableArray);
        }
        this.resyncFlags = message.flags;
    }

    public String getMIMEType() {
        return "message/rfc822";
    }

    public MessagePart.Ref getRef() {
        return new Ref(this);
    }

    public int getSize() {
        return this.intsize;
    }

    public synchronized void opCompleted(Controller controller, int n, Serializable[] serializableArray, Serializable[] serializableArray2) {
        switch (n) {
            case 13: {
                byte by = (Byte)serializableArray2[0];
                if (by == -1) break;
                this.resyncFlags = this.serverFlags = by;
                this.flags = this.serverFlags;
                this.markStatus();
                break;
            }
            case 8: {
                int n2 = (Integer)serializableArray2[0];
                Message message = null;
                for (int i = 0; i < this.targetFolderRefs.size(); ++i) {
                    Folder.Ref ref = (Folder.Ref)this.targetFolderRefs.elementAt(i);
                    if (ref != serializableArray[1]) continue;
                    message = (Message)this.targetMessages.elementAt(i);
                    this.targetMessages.removeElementAt(i);
                    this.targetFolderRefs.removeElementAt(i);
                    message.folder.removeMessage(message);
                    if (this.targetMessages.size() != 0) break;
                    this.targetFolderRefs = null;
                    this.targetMessages = null;
                    break;
                }
                if (n2 == 0) break;
                if (serializableArray2.length > 1) {
                    System.out.println((String)((Object)serializableArray2[1]));
                }
                controller.copyFailed(this, message, n2);
                break;
            }
            case 14: {
                this.fullheader = (String)((Object)serializableArray2[0]);
            }
        }
        controller.messageUpdated(this);
    }

    public int IMAPnumber() {
        return this.IMAPnum;
    }

    public boolean isCached() {
        for (int i = 0; i < this.messageParts.length; ++i) {
            if (this.messageParts[i].isCached()) continue;
            return false;
        }
        return true;
    }

    public long UID() {
        return this.UID;
    }

    synchronized void resync(Controller controller) {
        if (this.isClone()) {
            return;
        }
        if (this.targetMessages != null) {
            for (int i = 0; i < this.targetMessages.size(); ++i) {
                Message message = (Message)this.targetMessages.elementAt(i);
                if (message == null || message.folder == null || message.folder.isDeleted) continue;
                if (!this.flagsMatchForCopy(message)) {
                    this.setFlagsFromMsg(controller, message);
                }
                Folder.Ref ref = (Folder.Ref)this.targetFolderRefs.elementAt(i);
                controller.getRequest().startOp((Requestor)this, 8, new Serializable[]{this.getRef(), ref});
            }
        }
        if (this.targetMessages != null && this.flags != this.resyncFlags || this.flags != this.serverFlags) {
            this.setFlagsFromMsg(controller, this);
        }
    }

    public void setIMAPnumber(int n) {
        this.IMAPnum = n;
    }

    public boolean isAttachment() {
        return this.parent != null || this.isAttachment;
    }

    public boolean hasAttachments() {
        return this.messageParts.length > 1;
    }

    public void setUID(int n) {
        this.UID = n;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.originalMessage != null) {
            return this.originalMessage.clone();
        }
        Message message = (Message)super.clone();
        message.originalMessage = this;
        message.displayIndex = -1;
        message.date = new Date(this.date.getTime());
        message.to = (AddressList)this.to.clone();
        message.from = (AddressList)this.from.clone();
        message.cc = (AddressList)this.cc.clone();
        message.replyto = (AddressList)this.replyto.clone();
        message.messageParts = new MessagePart[this.messageParts.length];
        for (int i = 0; i < this.messageParts.length; ++i) {
            message.messageParts[i] = (MessagePart)this.messageParts[i].clone();
        }
        return message;
    }

    public Message(Message message, int n) {
        super(message, n);
        this.to = new AddressList();
        this.cc = new AddressList();
        this.replyto = new AddressList();
        this.date = new Date();
        this.messageParts = new MessagePart[0];
        this.folder = message.folder;
        this.originalMessage = null;
        this.setIMAPnumber(message.IMAPnumber());
        this.markStatus();
    }

    public boolean isReadOnly() {
        return this.isAttachment() || this.folder == null || this.folder.isReadOnly;
    }

    public boolean isClone() {
        return this.originalMessage != null;
    }

    public synchronized void setFlag(Controller controller, byte by, boolean bl) {
        if ((this.flags & by) != 0 == bl && (this.serverFlags & by) != 0 == bl) {
            return;
        }
        this.flags = bl ? (byte)(this.flags | by) : (byte)(this.flags & ~by);
        if (this.folder != null && this.UID != -1L) {
            Serializable[] serializableArray = new Serializable[]{this.getRef(), new Byte(this.flags)};
            controller.getRequest().startOp((Requestor)this, 13, serializableArray);
        }
        this.markStatus();
    }

    public void copyTo(Controller controller, Folder folder) {
        try {
            Message message = (Message)this.clone();
            message.setIMAPnumber(0);
            message.UID = folder.nextCloneUID--;
            folder.addMessage(message);
            if (this.targetMessages == null) {
                this.targetMessages = new Vector();
                this.targetFolderRefs = new Vector();
            }
            this.targetMessages.addElement(message);
            Folder.Ref ref = folder.getRef();
            this.targetFolderRefs.addElement(ref);
            message.originalMessage = this;
            Serializable[] serializableArray = new Serializable[]{this.getRef(), ref};
            controller.getRequest().startOp((Requestor)this, 8, serializableArray);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public boolean isExpunged() {
        MessagePart messagePart = this;
        while (messagePart.parent != null) {
            messagePart = messagePart.parent;
        }
        Message message = messagePart;
        return message.folder == null;
    }

    public static class Ref
    extends MessagePart.Ref
    implements Serializable {
        public long UID;
        public Folder.Ref folder;

        public String toArgString() {
            String string = "";
            if (this.UID >= 0L && this.folder != null) {
                string = string + this.folder.toArgString() + "&UID=" + this.UID;
            }
            string = string + super.toArgString();
            return string;
        }

        public Ref(Message message) {
            super(message);
            if (message.folder != null) {
                this.folder = message.folder.getRef();
            }
            this.UID = message.UID;
        }
    }
}

