/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp;

import com.sun.portal.desktop.util.NSPrintWriter;
import com.sun.portal.desktop.util.NSStringWriter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.jsp.Request;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

class Response
implements HttpServletResponse {
    private static final String headerMsg = "headers cannot be modified by JSP providers";
    protected String characterEncoding = System.getProperty("file.encoding", "iso-8859-1");
    protected PrintWriter writer = null;
    protected StringWriter stringWriter = new NSStringWriter(4096);
    protected Request request;
    protected HttpServletResponse servletResponse;
    protected boolean usingStream = false;
    protected boolean usingWriter = false;
    protected boolean started = false;
    protected boolean committed = false;
    private String location = null;
    protected int status = 200;
    protected ProviderContext context;

    public Response(Request req, HttpServletResponse res, ProviderContext c) {
        this.request = req;
        this.servletResponse = res;
        this.context = c;
    }

    public URL getLocation() throws MalformedURLException {
        if (this.location == null) {
            return null;
        }
        URL loc = new URL(this.location);
        return loc;
    }

    public StringBuffer getBody() throws ProviderException {
        return this.stringWriter.getBuffer();
    }

    public void addCookie(Cookie cookie) {
        this.servletResponse.addCookie(cookie);
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeRedirectUrl(String location) {
        return this.encodeRedirectURL(location);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() {
        throw new IllegalStateException("stream output not supported");
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new NSPrintWriter((Writer)this.stringWriter);
        }
        return this.writer;
    }

    public void sendError(int sc) throws IOException {
        this.status = sc;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.status = sc;
        this.sendBodyText(msg);
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.location = this.makeAbsolute(location);
        this.close();
    }

    public void setContentLength(int len) {
        throw new UnsupportedOperationException("setContentLength is not available to JSP providers");
    }

    public void setContentType(String type) {
    }

    public boolean containsHeader(String name) {
        throw new UnsupportedOperationException(headerMsg);
    }

    public void setDateHeader(String name, long date) {
        throw new UnsupportedOperationException(headerMsg);
    }

    public void addDateHeader(String name, long value) {
        throw new UnsupportedOperationException(headerMsg);
    }

    public void setHeader(String name, String value) {
        throw new UnsupportedOperationException(headerMsg);
    }

    public void addHeader(String name, String value) {
        this.servletResponse.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        throw new UnsupportedOperationException(headerMsg);
    }

    public void addIntHeader(String name, int value) {
        throw new UnsupportedOperationException(headerMsg);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return -1;
    }

    public void reset() throws IllegalStateException {
        this.stringWriter = new NSStringWriter(4096);
    }

    public boolean isCommitted() {
        return false;
    }

    public void flushBuffer() throws IOException {
    }

    public void setLocale(Locale loc) {
    }

    public Locale getLocale() {
        return null;
    }

    public void setStatus(int sc, String msg) {
        this.setStatus(sc);
    }

    private String makeAbsolute(String location) {
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            try {
                url = new URL(new URL(this.context.getRequestServer(this.request).toString()), location);
            }
            catch (MalformedURLException ignored) {
                return location;
            }
        }
        return url.toString();
    }

    private void sendBodyText(String s) throws IOException {
        try {
            PrintWriter out = this.getWriter();
            out.print(s);
        }
        catch (IllegalStateException ise) {
            ServletOutputStream out = this.getOutputStream();
            out.print(s);
        }
    }

    private void close() throws IOException {
        try {
            PrintWriter out = this.getWriter();
            out.close();
        }
        catch (IllegalStateException ise) {
            ServletOutputStream out = this.getOutputStream();
            out.close();
        }
    }
}

