/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.portal.servlet;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class submitServlet
extends HttpServlet {
    static String baseDir;
    static String instancePath;
    PrintWriter out;
    static String RDMGR;
    static Timer t;
    static String logFile;
    static String submitFile;
    static String indexFile;
    static String deleteFile;
    static final int SUBMIT_RETRIES = 3;
    static final int INDEX_RETRIES = 3;
    static final int DELETE_RETRIES = 3;
    static String CGI_URL;
    static Debug debug;
    private static String BOUNDARY;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String serverInstance = SystemProperties.get((String)"com.iplanet.am.server.host");
        try {
            BufferedReader in = new BufferedReader(new FileReader("/etc/opt/SUNWps/.deploy"));
            StringTokenizer st = new StringTokenizer(in.readLine(), "=");
            st.nextToken();
            String deployURI = st.nextToken();
            st = new StringTokenizer(SystemProperties.get((String)"com.iplanet.am.installdir"), "/");
            StringBuffer buf = new StringBuffer();
            String str = st.nextToken();
            while (st.hasMoreTokens()) {
                buf.append("/" + str);
                str = st.nextToken();
            }
            baseDir = buf.toString();
            instancePath = "/var/opt/SUNWps/https-" + serverInstance + deployURI + "/";
            RDMGR = instancePath + "run-cs-cli " + baseDir + "/SUNWps/bin/rdmgr";
            submitFile = instancePath + "logs/IMArchiveSubmit.soif";
            indexFile = instancePath + "logs/IMArchiveIndex.soif";
            deleteFile = instancePath + "logs/IMArchiveDelete.soif";
            t = new Timer();
            t.start();
        }
        catch (Exception e) {
            submitServlet.error("Exception", e);
        }
    }

    private void retry(String cmd, String file, int N) throws Exception {
        this.retry(cmd, file, N, false);
    }

    private void retry(String arg, String file, int N, boolean submit) throws Exception {
        for (int i = N; i >= 0; --i) {
            File f;
            if (i == 0) {
                if (!new File(file).exists()) continue;
                submitServlet.message(file + " exists");
                f = File.createTempFile("RDs", null);
                this.append(file, f.getAbsolutePath(), true);
            } else {
                if (!new File(file + ".try" + i).exists()) continue;
                submitServlet.message(file + ".try" + i + " exists");
                f = File.createTempFile("RDs", null);
                this.append(file + ".try" + i, f.getAbsolutePath(), true);
            }
            int exitValue = 0;
            if (CGI_URL != null) {
                exitValue = this.callCGI(URLEncoder.encode(arg + f.getAbsolutePath()));
            } else {
                Process p = Runtime.getRuntime().exec(RDMGR + arg + f.getAbsolutePath());
                p.waitFor();
                exitValue = p.exitValue();
            }
            if (exitValue != 0) {
                submitServlet.message("rdmgr failed");
                if (i == N) {
                    this.append(f.getAbsolutePath(), file + ".corrupted", true);
                    submitServlet.message("Creating the .corrupted file");
                    continue;
                }
                this.append(f.getAbsolutePath(), file + ".try" + (i + 1), true);
                submitServlet.message("Moving the data to next level. Try " + (i + 1));
                continue;
            }
            if (submit) {
                this.append(f.getAbsolutePath(), indexFile, true);
                continue;
            }
            f.delete();
        }
    }

    private synchronized void append(String source, String destination, boolean delete) {
        try {
            File sourceFile = new File(source);
            if (!sourceFile.exists()) {
                return;
            }
            FileOutputStream fos = new FileOutputStream(destination, true);
            byte[] b = submitServlet.readFile(sourceFile);
            if (b != null) {
                fos.write(b);
            }
            if (delete) {
                sourceFile.delete();
            }
        }
        catch (Exception e) {
            submitServlet.error("Exception in append method", e);
        }
    }

    private int callCGI(String arg) {
        try {
            HttpURLConnection conn = this.openConnection(arg);
            BufferedReader inStream = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String currentLine = null;
            while (null != (currentLine = inStream.readLine())) {
                submitServlet.message("Current line = " + currentLine);
                if (!currentLine.equals("Error")) continue;
                submitServlet.message("Submission to CGI script failed");
                return 1;
            }
            inStream.close();
            Object var3_4 = null;
        }
        catch (Exception e) {
            submitServlet.error("Exception while submitting the data to CGI script", e);
            return 1;
        }
        return 0;
    }

    private HttpURLConnection openConnection(String arg) throws Exception {
        URL url = new URL(CGI_URL + "?" + arg);
        submitServlet.message("The url is " + url.toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        DataOutputStream outStream = null;
        outStream = new DataOutputStream(conn.getOutputStream());
        outStream.writeBytes("\r\n");
        if (outStream != null) {
            outStream.close();
        }
        outStream = null;
        conn.connect();
        return conn;
    }

    public static void message(String str) {
        if (debug.messageEnabled()) {
            debug.message(str);
        }
    }

    public static void error(String str, Throwable t) {
        debug.error(str, t);
    }

    public void destroy() {
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        boolean mimeBody = false;
        try {
            String user;
            long startTime = System.currentTimeMillis();
            String urlData = request.getParameter("data");
            String operation = request.getParameter("op");
            if (operation == null) {
                operation = "";
                mimeBody = true;
            }
            if ((user = request.getParameter("user")) == null) {
                user = "";
            }
            if (!mimeBody) {
                submitServlet.message("URL data = " + urlData);
                submitServlet.message("op = " + operation);
                submitServlet.message("user = " + user);
            }
            Object is = request.getInputStream();
            submitServlet.message("content-length: " + request.getContentLength());
            String cmd = "";
            if (operation.equals("get") || operation.equals("removeacl")) {
                String line;
                BufferedReader in;
                if (CGI_URL != null) {
                    HttpURLConnection conn = this.openConnection(URLEncoder.encode("-Q " + urlData));
                    in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                } else {
                    String[] cmdArray = new String[]{instancePath + "run-cs-cli", baseDir + "/SUNWps/bin/rdmgr", "-Q", urlData};
                    Process p = Runtime.getRuntime().exec(cmdArray);
                    p.waitFor();
                    in = new BufferedReader(new InputStreamReader(p.getInputStream(), "UTF-8"));
                }
                StringBuffer str = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    if (operation.equals("removeacl") && line.indexOf(user) != -1) continue;
                    str.append(line);
                    str.append("\n");
                }
                if (operation.equals("get")) {
                    out.println(str.toString());
                    return;
                }
                is = new ByteArrayInputStream(str.toString().getBytes("UTF-8"));
                operation = "";
            }
            if (operation.equals("runrdmgr")) {
                submitServlet.t.RDMGR_TIMER = Long.parseLong(urlData.trim());
                if (!t.isAlive()) {
                    t.start();
                }
            }
            if (operation.equals("cgiurl")) {
                CGI_URL = urlData.trim();
            } else {
                String filename = operation.equals("delete") ? deleteFile : submitFile;
                byte[] b = new byte[1024];
                if (mimeBody) {
                    is.readLine(b, 0, 1024);
                    is.readLine(b, 0, 1024);
                    is.readLine(b, 0, 1024);
                    is.readLine(b, 0, 1024);
                }
                FileOutputStream soifos = new FileOutputStream(filename, true);
                int offset = 0;
                while (true) {
                    int i;
                    int len = 0;
                    try {
                        len = is.available();
                    }
                    catch (Exception e) {
                        submitServlet.message("available() thows IOException: " + e.toString() + " offset=" + offset);
                        break;
                    }
                    if (len <= 0) break;
                    len = is.read(b, offset, 1024 - offset);
                    submitServlet.message("Read " + len + " new bytes.");
                    int wlen = len;
                    if (mimeBody && (wlen = len + offset - BOUNDARY.length()) < 0) {
                        wlen = 0;
                    }
                    if (wlen > 0) {
                        soifos.write(b, 0, wlen);
                        submitServlet.message("Wrote " + wlen + " bytes to logs.");
                    }
                    if (!mimeBody || wlen <= 0) continue;
                    for (i = 0; i < len + offset - wlen; ++i) {
                        b[i] = b[i + wlen];
                    }
                    offset = i;
                    submitServlet.message("Held " + offset + " bytes");
                }
                soifos.close();
                this.retry(" -D ", submitFile, 3, true);
            }
            out.println("Operation completed Successfully");
            submitServlet.message("Time required to process the request " + (System.currentTimeMillis() - startTime) + "msec");
        }
        catch (Exception e) {
            out.println("Error");
            submitServlet.error("Error", e);
        }
    }

    private static synchronized byte[] readFile(File f) throws Exception {
        if (!f.exists()) {
            return null;
        }
        byte[] b = new byte[(int)f.length()];
        FileInputStream is = new FileInputStream(f);
        int len = is.read(b);
        submitServlet.message("Read " + len + " bytes.");
        is.close();
        return b;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Submits the resource descriptors to the portal server search database";
    }

    static {
        logFile = "IMArchiveSubmit.log";
        CGI_URL = null;
        debug = Debug.getInstance((String)logFile);
        BOUNDARY = "\r\n-----------------------------soimsoif--\r\n";
    }

    class Timer
    extends Thread {
        long RDMGR_TIMER = 120000L;

        Timer(long time) {
            this.RDMGR_TIMER = time;
        }

        Timer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            submitServlet.message("Starting timer thread with period " + this.RDMGR_TIMER);
            while (true) {
                try {
                    submitServlet.message("Submitting the data for indexing");
                    submitServlet.this.retry(" -V ", indexFile, 3);
                    submitServlet.this.retry(" -d ", deleteFile, 3);
                    continue;
                }
                catch (Exception e) {
                    submitServlet.error("Exception in Thread timer", e);
                    continue;
                }
                finally {
                    try {
                        Thread.sleep(this.RDMGR_TIMER);
                    }
                    catch (InterruptedException e) {
                        submitServlet.error("Interrupted exception", e);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

