/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.impl;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.addressbook.ABSession;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.ValidationException;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;

public class LDAPABSSOAdapter
extends SSOAdapter {
    protected ABStore abStore = null;
    protected ABSession abSession = null;
    protected long lastCheckTime = 0L;
    protected static String LDAP_DEFAULT_PORT = "389";
    protected static String IMAP_DEFAULT_PORT = "143";
    protected static String CLIENT_DEFAULT_PORT = "80";
    protected static String CLIENT_DEFAULT_PROTOCOL = "http";
    protected static String serviceClass = "com.sun.addressbook.ldap.LdapABStore";

    public void init(String adapterName, SSOToken token, Properties adapterProperties) throws SSOAdapterException {
        super.init(adapterName, token, adapterProperties);
        if (adapterProperties.getProperty("validate", "false").equals("true")) {
            try {
                this.validate();
            }
            catch (ValidationException ve) {
                throw new SSOAdapterException(ve.getLocalizedMessage("ssoadapter", this.locale), true);
            }
        }
    }

    public void validate() throws ValidationException {
        String enableProxyAuth;
        String timeoutString;
        String connPoolMaxString;
        String aidString;
        String imapHostString;
        String hostString;
        String portString = this.adapterProperties.getProperty("port");
        if (portString != null) {
            try {
                int testInt = Integer.parseInt(portString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidPort");
                throw ve;
            }
        }
        if ((hostString = this.adapterProperties.getProperty("host")) == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingHost");
            throw ve;
        }
        String clientPortString = this.adapterProperties.getProperty("clientPort");
        if (clientPortString != null) {
            try {
                int testInt = Integer.parseInt(clientPortString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidClientPort");
                throw ve;
            }
        }
        if ((imapHostString = this.adapterProperties.getProperty("imapHost")) == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingImapHost");
            throw ve;
        }
        String imapPortString = this.adapterProperties.getProperty("imapPort");
        if (imapPortString != null) {
            try {
                int testInt = Integer.parseInt(imapPortString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidImapPort");
                throw ve;
            }
        }
        if ((aidString = this.adapterProperties.getProperty("aid")) == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingAid");
            throw ve;
        }
        String adminPasswordString = this.adapterProperties.getProperty("adminPassword");
        if (adminPasswordString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingAdminPassword");
            throw ve;
        }
        String userSearchBaseString = this.adapterProperties.getProperty("userSearchBase");
        if (userSearchBaseString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingUserSearchBase");
            throw ve;
        }
        String pabSearchBaseString = this.adapterProperties.getProperty("pabSearchBase");
        if (pabSearchBaseString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingPabSearchBase");
            throw ve;
        }
        String connPoolMinString = this.adapterProperties.getProperty("connPoolMin");
        if (connPoolMinString != null) {
            try {
                int testInt = Integer.parseInt(connPoolMinString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidConnPoolMin");
                throw ve;
            }
        }
        if ((connPoolMaxString = this.adapterProperties.getProperty("connPoolMax")) != null) {
            try {
                int testInt = Integer.parseInt(connPoolMaxString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidConnPoolMax");
                throw ve;
            }
        }
        if ((timeoutString = this.adapterProperties.getProperty("timeout")) != null) {
            try {
                int testInt = Integer.parseInt(timeoutString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidTimeout");
                throw ve;
            }
        }
        if ((enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false")).equals("false")) {
            String uidString = this.adapterProperties.getProperty("uid");
            if (uidString == null) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("missingUid");
                throw ve;
            }
            String passwordString = this.adapterProperties.getProperty("password");
            if (passwordString == null) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("missingPassword");
                throw ve;
            }
        }
    }

    public Object getConnection() {
        ABStore obj = null;
        try {
            obj = this.getABStore();
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to get connection. ", e);
        }
        if (obj != null) {
            SSOAdapterDebug.logMessage(this.identifier + " connected to store");
        }
        return obj;
    }

    public ABStore getABStore() throws Exception {
        if (this.isAvailable()) {
            return this.abStore;
        }
        String imapServer = this.adapterProperties.getProperty("imapHost");
        String imapPortStr = this.adapterProperties.getProperty("imapPort", IMAP_DEFAULT_PORT);
        String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false");
        String user = null;
        String pass = null;
        if (imapPortStr == null) {
            imapPortStr = IMAP_DEFAULT_PORT;
        }
        int imapPort = Integer.parseInt(imapPortStr);
        if (enableProxyAuth.equals("true")) {
            SSOToken tok = this.getSSOToken();
            if (tok != null) {
                user = this.adapterProperties.getProperty("proxyAdminUid");
                pass = this.adapterProperties.getProperty("proxyAdminPassword");
            }
        } else {
            user = this.adapterProperties.getProperty("uid");
            pass = this.adapterProperties.getProperty("password");
        }
        if (!this.authenticate(user, pass, imapServer, imapPort)) {
            throw new Exception("LDAPABSSOAdapter.getABStore(): User credentials invalid. Access to Address Book denied!");
        }
        this.abSession = this.getABSession();
        this.abStore = this.abSession.getABStore(serviceClass);
        this.abStore.connect();
        return this.abStore;
    }

    public ABSession getABSession() throws Exception {
        if (this.abSession != null) {
            return this.abSession;
        }
        Properties props = new Properties();
        String host = this.adapterProperties.getProperty("host");
        String port = this.adapterProperties.getProperty("port", LDAP_DEFAULT_PORT);
        String aid = this.adapterProperties.getProperty("aid");
        String adminPassword = this.adapterProperties.getProperty("adminPassword");
        String userSearchBase = this.adapterProperties.getProperty("userSearchBase");
        String pabSearchBase = this.adapterProperties.getProperty("pabSearchBase");
        String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false");
        String uid = null;
        if (enableProxyAuth.equals("true")) {
            SSOToken tok = this.getSSOToken();
            AMStoreConnection amsc = null;
            AMUser auser = null;
            String usrAttr = null;
            if (tok != null) {
                usrAttr = this.adapterProperties.getProperty("userAttribute", "uid");
                try {
                    amsc = new AMStoreConnection(tok);
                    auser = amsc.getUser(tok.getPrincipal().getName());
                    uid = auser.getStringAttribute(usrAttr);
                }
                catch (SSOException ssoe) {
                    SSOAdapterDebug.logError(this.identifier + "proxy uid retrieval failed ", ssoe);
                }
                catch (AMException ame) {
                    SSOAdapterDebug.logError(this.identifier + "proxy uid retrieval failed ", ame);
                }
                SSOAdapterDebug.logMessage(this.identifier + "connecting with proxy uid=" + uid);
            }
        } else {
            uid = this.adapterProperties.getProperty("uid");
        }
        String lang = this.adapterProperties.getProperty("lang");
        String connPoolMin = this.adapterProperties.getProperty("connPoolMin");
        String connPoolMax = this.adapterProperties.getProperty("connPoolMax");
        String connTimeout = this.adapterProperties.getProperty("timeout");
        if (host != null) {
            props.put("ab.host", host);
        }
        if (port != null) {
            props.put("ab.port", port);
        }
        if (aid != null) {
            props.put("ab.ldap.authId", aid);
        }
        if (adminPassword != null) {
            props.put("ab.ldap.authPw", adminPassword);
        }
        if (userSearchBase != null) {
            props.put("ab.ldap.dirSearchBase", userSearchBase);
        }
        if (pabSearchBase != null) {
            props.put("ab.ldap.pabSearchBase", pabSearchBase);
        }
        if (uid != null) {
            props.put("ab.userName", uid);
        }
        if (lang != null) {
            props.put("ab.ldap.lang", lang);
        }
        if (connPoolMin != null) {
            props.put("ab.ldap.connPoolMin", connPoolMin);
        }
        if (connPoolMax != null) {
            props.put("ab.ldap.connPoolMax", connPoolMax);
        }
        if (connTimeout != null) {
            props.put("ab.ldap.timeout", connTimeout);
        }
        this.abSession = ABSession.getInstance((Properties)props);
        return this.abSession;
    }

    protected boolean authenticate(String user, String pass, String imapServer, int imapPort) {
        try {
            Properties props = new Properties();
            props.put("mail.host", imapServer);
            props.put("mail.user", user);
            Session session = Session.getInstance((Properties)props, null);
            Store newStore = session.getStore("imap");
            newStore.connect(imapServer, imapPort, user, pass);
            newStore.close();
        }
        catch (AuthenticationFailedException afe) {
            SSOAdapterDebug.logMessage("LDAPABSSOAdapter.authenticate(): Failed to authenticate: " + afe.getMessage());
            return false;
        }
        catch (MessagingException me) {
            SSOAdapterDebug.logMessage("LDAPABSSOAdapter.authenticate(): Failed to authenticate: " + me.getMessage());
            return false;
        }
        return true;
    }

    public boolean isAvailable() {
        try {
            return this.abStore != null && this.abStore.isConnected();
        }
        catch (ABStoreException abse) {
            SSOAdapterDebug.logMessage("LDAPABSSOAdapter.isAvailable(): Failed to check is ABStore connected");
            return false;
        }
    }

    public boolean closeConnection() {
        boolean retval = true;
        try {
            this.abStore.disconnect();
            this.abStore = null;
            this.abSession = null;
        }
        catch (Exception e) {
            retval = false;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
        return retval;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int evtType = evt.getType();
            if (this.abStore != null) {
                this.abStore.disconnect();
            }
            this.abStore = null;
            this.abSession = null;
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to close connection " + "to store ", e);
            return;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
    }
}

