/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.config;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.ssoadapter.config.DSAMEConstants;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DSAMEConnection
implements DSAMEConstants {
    public static Debug debug = Debug.getInstance((String)"SAALContext");
    private static String thisClass = null;
    protected AMUser user = null;
    protected AMStoreConnection connection = null;
    protected SSOToken userToken = null;
    private static SSOToken adminToken = null;
    private static SSOTokenManager _tokenMgr = null;
    private static AMStoreConnection adminConnection = null;
    private static ServiceManager sManager = null;

    public DSAMEConnection(HttpServletRequest req) throws IllegalStateException {
        this(DSAMEConnection.getSSOToken(req));
    }

    public DSAMEConnection(SSOToken token) throws IllegalStateException {
        if (thisClass == null) {
            thisClass = this.getClass().getName();
        }
        this.userToken = token;
        try {
            this.connection = new AMStoreConnection(token);
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + "(): Invalid Token: " + (Object)((Object)se));
        }
        this.init(token);
    }

    public DSAMEConnection(String uid, String pw) throws SSOException {
        SSOToken token = null;
        SSOTokenManager ssom = DSAMEConnection.getSSOTokenManager();
        MyPrincipal ap = new MyPrincipal(uid);
        token = ssom.createSSOToken((Principal)ap, pw);
        this.connection = new AMStoreConnection(token);
        this.user = this.connection.getUser(uid);
    }

    public DSAMEConnection(String uid, String pw, String userDN) throws SSOException {
        SSOToken token = null;
        SSOTokenManager ssom = DSAMEConnection.getSSOTokenManager();
        MyPrincipal ap = new MyPrincipal(uid);
        token = ssom.createSSOToken((Principal)ap, pw);
        this.connection = new AMStoreConnection(token);
        this.user = this.connection.getUser(userDN);
    }

    protected void init(SSOToken token) throws IllegalStateException {
        try {
            String uid = token.getPrincipal().getName();
            this.user = this.connection.getUser(uid);
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + ".init()" + (Object)((Object)se));
        }
    }

    private static boolean isTokenValid(SSOToken token) {
        boolean valid = false;
        try {
            if (token != null) {
                token.getPrincipal();
                valid = true;
            }
        }
        catch (SSOException ssoe) {
            valid = false;
        }
        return valid;
    }

    private static AMStoreConnection getAdminConnection() {
        if (adminConnection == null || !DSAMEConnection.isTokenValid(adminToken)) {
            String bindDN = AdminUtils.getAdminDN();
            String password = new String(AdminUtils.getAdminPassword());
            try {
                SSOTokenManager ssom = DSAMEConnection.getSSOTokenManager();
                MyPrincipal ap = new MyPrincipal(bindDN);
                adminToken = ssom.createSSOToken((Principal)ap, password);
                adminConnection = new AMStoreConnection(adminToken);
                sManager = new ServiceManager(adminToken);
            }
            catch (Exception e) {
                debug.error(thisClass + ".getAdminConnection() failed: ", (Throwable)e);
                throw new RuntimeException(thisClass + ".getAdminConnection(): " + e);
            }
        }
        return adminConnection;
    }

    private ServiceSchemaManager getServiceSchemaManager(String srvcName) throws SMSException, IllegalStateException {
        ServiceSchemaManager ssMngr = null;
        try {
            ssMngr = sManager.getSchemaManager(srvcName, "1.0");
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + ".getServiceSchemaManager()" + (Object)((Object)se));
        }
        return ssMngr;
    }

    public String getStringAttribute(String attributeName) throws IllegalStateException, IOException {
        String val = null;
        Set vals = this.getAttribute(attributeName);
        if (vals != null && vals.size() > 0) {
            Iterator iter = vals.iterator();
            val = (String)iter.next();
        }
        return val;
    }

    public Set getAttribute(String attributeName) throws IllegalStateException, IOException {
        Set vals = null;
        if (debug.messageEnabled()) {
            debug.message(thisClass + ".getAttribute():Attr= " + attributeName);
        }
        try {
            vals = this.user.getAttribute(attributeName);
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + ".getAttributeMultiVal()" + (Object)((Object)se));
        }
        catch (AMException ae) {
            throw new IOException(thisClass + ".getAttributeMultiVal()" + (Object)((Object)ae));
        }
        return vals;
    }

    public void setStringAttribute(String attributeName, String val) throws IllegalStateException, IOException {
        if (debug.messageEnabled()) {
            debug.message(thisClass + ".setStringAttribute(): Attr = " + attributeName + " :: val = " + val);
        }
        try {
            this.user.setStringAttribute(attributeName, val);
            this.user.store();
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + ".setAttribute(): " + "attributeName=" + attributeName);
        }
        catch (AMException ae) {
            throw new IOException(thisClass + ".setAttribute(): Attr = " + attributeName + " value = " + val + " Exception = " + (Object)((Object)ae));
        }
    }

    public void setAttribute(String attributeName, Set vals) throws IllegalStateException, IOException {
        HashMap<String, Set> map = new HashMap<String, Set>();
        map.put(attributeName, vals);
        if (debug.messageEnabled()) {
            debug.message(thisClass + ".setAttribute(): Name = " + attributeName + " :: vals = " + vals);
        }
        try {
            this.user.setAttributes(map);
            this.user.store();
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + ".setAttribute(): " + "Attr = " + attributeName);
        }
        catch (AMException ae) {
            throw new IOException(thisClass + ".setAttribute(): Attr = " + attributeName + " :: value= " + vals + " Exception = " + (Object)((Object)ae));
        }
    }

    public String getOrganizationStringAttribute(String serviceName, String attributeName) throws IllegalStateException, IOException {
        String val = null;
        Set vals = this.getOrganizationAttribute(serviceName, attributeName);
        if (vals != null && vals.size() > 0) {
            Iterator iter = vals.iterator();
            val = (String)iter.next();
        }
        return val;
    }

    public Set getOrganizationAttribute(String serviceName, String attributeName) throws IllegalStateException, IOException {
        Set vals = null;
        if (debug.messageEnabled()) {
            debug.message(thisClass + ".getOrgAttribute() service = " + serviceName + " :: Attr = " + attributeName);
        }
        try {
            boolean tempExists;
            String orgDN = null;
            orgDN = this.user.getOrganizationDN();
            AMOrganization org = DSAMEConnection.getAdminConnection().getOrganization(orgDN);
            if (org == null) {
                return null;
            }
            AMTemplate temp = org.getTemplate(serviceName, 302);
            boolean bl = tempExists = temp != null && temp.isExists();
            if (!tempExists) {
                return null;
            }
            vals = temp.getAttribute(attributeName);
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + ".getOrganizationAttribute(): " + "serviceName=" + serviceName + (Object)((Object)se));
        }
        catch (AMException ae) {
            throw new IOException(thisClass + ".getOrganizationAttribute(): " + "serviceName=" + serviceName + "+ attributeName=" + attributeName + (Object)((Object)ae));
        }
        return vals;
    }

    public String getGlobalStringAttribute(String serviceName, String attributeName) throws IOException {
        String val = null;
        Set vals = this.getGlobalAttribute(serviceName, attributeName);
        if (vals != null && vals.size() > 0) {
            Iterator iter = vals.iterator();
            val = (String)iter.next();
        }
        return val;
    }

    public Set getGlobalAttribute(String serviceName, String attributeName) throws IOException {
        Set vals = null;
        if (debug.messageEnabled()) {
            debug.message(thisClass + ".getGlobalAttribute(): service = " + serviceName + " :: Attrname = " + attributeName);
        }
        try {
            ServiceSchemaManager ssMngr = this.getServiceSchemaManager(serviceName);
            ServiceSchema schema = ssMngr.getGlobalSchema();
            Map attrs = schema.getAttributeDefaults();
            vals = (Set)attrs.get(attributeName);
        }
        catch (SMSException sme) {
            throw new IOException(thisClass + ".getGlobalAttributes(): " + serviceName + ": " + (Object)((Object)sme));
        }
        return vals;
    }

    public void setGlobalAttribute(String serviceName, String attributeName, Set vals) throws IOException {
        if (debug.messageEnabled()) {
            debug.message(thisClass + ".setGlobalAttribute(): service = " + serviceName + " :: Attr = " + attributeName + " :: vals = " + vals);
        }
        try {
            ServiceSchemaManager ssMngr = new ServiceSchemaManager(this.userToken, serviceName, "1.0");
            ServiceSchema schema = ssMngr.getGlobalSchema();
            schema.setAttributeDefaults(attributeName, vals);
        }
        catch (SMSException smse) {
            throw new IOException(thisClass + ".setGlobalAttribute(): " + serviceName + "." + attributeName + " = " + vals + (Object)((Object)smse));
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + ".setGlobalAttribute()" + (Object)((Object)se));
        }
    }

    public void setOrganizationAttribute(String serviceName, String attributeName, Set vals) throws IllegalStateException, IOException {
        boolean noPerms = false;
        String msg = null;
        HashMap<String, Set> map = new HashMap<String, Set>();
        map.put(attributeName, vals);
        if (debug.messageEnabled()) {
            debug.message(thisClass + ".setOrgAttribute(): service = " + serviceName + " :: Attr = " + attributeName + " :: vals = " + vals);
        }
        try {
            String orgDN = null;
            orgDN = this.user.getOrganizationDN();
            AMOrganization org = this.connection.getOrganization(orgDN);
            if (org == null) {
                noPerms = true;
                msg = "Insufficient Permission";
            } else {
                boolean tempExists;
                AMTemplate temp = org.getTemplate(serviceName, 302);
                boolean bl = tempExists = temp != null && temp.isExists();
                if (!tempExists) {
                    noPerms = true;
                    msg = "Insufficient Permission";
                } else {
                    temp.setAttributes(map);
                }
            }
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + ".getOrganizationAttribute(): " + "serviceName=" + serviceName + (Object)((Object)se));
        }
        catch (AMException ae) {
            noPerms = true;
            msg = ae.toString();
        }
        if (noPerms) {
            throw new IOException(thisClass + ".getOrganizationAttribute():: " + msg);
        }
    }

    protected static SSOToken getSSOToken(HttpServletRequest request) {
        SSOToken token = null;
        try {
            token = DSAMEConnection.getSSOTokenManager().createSSOToken(request);
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + ".getSSOToken(): " + "Failed to get SSOToken.  " + (Object)((Object)se));
        }
        return token;
    }

    public static SSOTokenManager getSSOTokenManager() throws SSOException {
        if (_tokenMgr == null) {
            _tokenMgr = SSOTokenManager.getInstance();
        }
        return _tokenMgr;
    }

    public Set getSchemaTypes(String serviceName) throws SMSException {
        ServiceSchemaManager ssMngr = this.getServiceSchemaManager(serviceName);
        return ssMngr.getSchemaTypes();
    }

    public ServiceSchema getSchema(String serviceName, SchemaType scope) throws SMSException {
        ServiceSchemaManager ssMngr = this.getServiceSchemaManager(serviceName);
        return ssMngr.getSchema(scope);
    }

    public void removeAttribute(Set attrs) throws IllegalStateException, IOException {
        if (debug.messageEnabled()) {
            debug.message(thisClass + ".removeAttribute(): Attr = " + attrs);
        }
        try {
            this.user.removeAttributes(attrs);
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + ".removeAttribute()" + (Object)((Object)se));
        }
        catch (AMException ae) {
            throw new IOException(thisClass + ".removeAttribute()" + (Object)((Object)ae));
        }
    }

    public void removeOrganizationAttribute(String serviceName, Set attrs) throws IllegalStateException, IOException {
        boolean noPerms = false;
        String msg = null;
        if (debug.messageEnabled()) {
            debug.message(thisClass + ".removeOrgAttribute(): service = " + serviceName + " :: Attr = " + attrs);
        }
        try {
            String orgDN = null;
            orgDN = this.user.getOrganizationDN();
            AMOrganization org = this.connection.getOrganization(orgDN);
            if (org == null) {
                noPerms = true;
                msg = "Insufficient Permission";
            } else {
                boolean tempExists;
                AMTemplate temp = org.getTemplate(serviceName, 302);
                boolean bl = tempExists = temp != null && temp.isExists();
                if (!tempExists) {
                    noPerms = true;
                    msg = "Insufficient Permission";
                } else {
                    temp.removeAttributes(attrs);
                }
            }
        }
        catch (SSOException se) {
            throw new IllegalStateException(thisClass + ".removeOrganizationAttribute(): " + "serviceName=" + serviceName + (Object)((Object)se));
        }
        catch (AMException ae) {
            noPerms = true;
            msg = ae.toString();
        }
        if (noPerms) {
            throw new IOException(thisClass + ".removeOrganizationAttribute():: " + msg);
        }
    }

    static {
        DSAMEConnection.getAdminConnection();
    }

    private static class MyPrincipal
    implements Principal {
        protected String name;

        public MyPrincipal(String name) {
            this.name = new String(name);
        }

        public String getName() {
            return this.name;
        }
    }
}

