/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.admin.model;

import com.iplanet.am.console.service.model.SMDataModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.ssoadapter.config.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SSOAdapterModelImpl
extends SMDataModelImpl {
    public static final int DEFAULT_TYPE = 0;
    public static final int MERGE_TYPE = 1;
    public static final int ENCODED_TYPE = 2;
    public static final int NO_TYPE = 3;
    public static final String DEFAULT = "default";
    public static final String MERGE = "merge";
    public static final String ENCODED = "encoded";
    public static final String SERVICE_NAME = "SunSSOAdapterService";
    protected static final String ATTR_TEMPLATES_NAME = "sunConfigurationTemplates";
    protected static final String ATTR_CONFIGURATIONS_NAME = "sunSSOAdapterConfigurations";
    public static final String ATTR_CLIENT_TYPE = "default";
    protected static final String ATTR_GENERIC_TEMPLATE = "GENERIC_TEMPLATE";
    protected String[] currentDefaultProperties = null;
    protected Configuration currentConfig = null;
    private String userDN = null;
    private AMUser user = null;
    protected String id = ((Object)((Object)this)).getClass().getName() + " ";
    static final Comparator ConfigComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            try {
                Configuration c1 = (Configuration)o1;
                Configuration c2 = (Configuration)o2;
                String n1 = c1.getConfigurationName();
                String n2 = c2.getConfigurationName();
                return n1.compareTo(n2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    };

    public SSOAdapterModelImpl(HttpServletRequest req, String rbName, Map map, String svcName, boolean processTemplate) {
        super(req, rbName, map, svcName, processTemplate);
        this.setCurrentUser((String)map.get("com-iplanet-am-admin-user-current-object"));
    }

    public List getConfigurationTemplateNames() {
        return this.getConfigurationTemplateNames(false);
    }

    public List getConfigurationTemplateNames(boolean schemaOverride) {
        Map attrMap = this.getAttributeMap(SchemaType.GLOBAL, schemaOverride);
        Set attrSet = (Set)attrMap.get(ATTR_TEMPLATES_NAME);
        List<Object> templateList = new ArrayList();
        String mid = this.id + ".getConfigurationTemplateNames: ";
        if (attrSet != null) {
            Iterator iter = attrSet.iterator();
            while (iter.hasNext()) {
                Configuration config = new Configuration((String)iter.next());
                if (config == null) continue;
                templateList.add(config.getConfigurationName());
            }
            Object[] templateArray = templateList.toArray();
            Arrays.sort(templateArray);
            templateList = Arrays.asList(templateArray);
        } else {
            debug.warning(mid + "no attribute values found");
        }
        debug.message(this.id + " returning " + templateList);
        return templateList;
    }

    public Configuration getConfigurationTemplate(String templ) {
        return this.getConfigurationTemplate(templ, false);
    }

    public Configuration getConfigurationTemplate(String templ, boolean schemaOverride) {
        Map attrMap = this.getAttributeMap(SchemaType.GLOBAL, schemaOverride);
        Set attrSet = (Set)attrMap.get(ATTR_TEMPLATES_NAME);
        Configuration config = null;
        String mid = this.id + ".getConfigurationTemplate: ";
        if (attrSet != null) {
            Iterator iter = attrSet.iterator();
            while (iter.hasNext() && ((config = new Configuration((String)iter.next())) == null || !config.getConfigurationName().equals(templ))) {
            }
        }
        debug.message(mid + "returning " + config.toString());
        return config;
    }

    public String getHelpDocURL() {
        return this.getHelpDocURL(this.resBundle);
    }

    public String getHelpAnchorTag(String key) {
        return super.getHelpAnchorTag(key);
    }

    public boolean addConfigurationTemplate(String name, String desc) {
        if (name == null || desc == null) {
            return false;
        }
        if (!this.containsDuplicateTemplate(name)) {
            Configuration config = this.getConfigurationTemplate(desc);
            config.setConfigurationName(name);
            return this.addConfigurationTemplate(config);
        }
        return false;
    }

    public boolean addConfigurationTemplate(Configuration config) {
        if (config == null) {
            return false;
        }
        String mid = this.id + ".addConfigurationTemplate: ";
        if (!this.containsDuplicateTemplate(config.getConfigurationName())) {
            try {
                ServiceSchemaManager svcSchemaMgr = this.getServiceSchemaManager(SERVICE_NAME);
                ServiceSchema schema = svcSchemaMgr.getSchema(SchemaType.GLOBAL);
                Map attrValues = schema.getAttributeDefaults();
                Set templateAttr = (Set)attrValues.get(ATTR_TEMPLATES_NAME);
                templateAttr.add(config.toString());
                schema.setAttributeDefaults(ATTR_TEMPLATES_NAME, templateAttr);
                debug.message(mid + " added configuration " + config.toString());
            }
            catch (SMSException smse) {
                debug.error(mid + " add configuration failed: ", (Throwable)smse);
            }
            catch (SSOException ssoe) {
                debug.error(mid + " add configuration failed: ", (Throwable)ssoe);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean addConfigurationTemplate(String name) {
        String defaultString = "";
        if (name == null) {
            return false;
        }
        Configuration config = null;
        String mid = this.id + ".addConfigurationTemplate: ";
        if (!this.containsDuplicateTemplate(name)) {
            config = this.getGenericConfiguration(name);
            return this.addConfigurationTemplate(config);
        }
        return false;
    }

    public boolean addConfigTemplateProperty(String templ, String name, String value, int type) {
        debug.message("Entering SSOA.addConfigTemplateProperty():\ntype=" + type + "\ntempl=" + templ + "\nname=" + name + "\nvalue=" + value);
        if (type != 0 && type != 1) {
            debug.message("SSOA.addConfigTemplateProperty():  Not default or merge type.  Returning false");
            return false;
        }
        Configuration config = this.getConfigurationTemplate(templ);
        String mid = this.id + ".addConfigTemplateProperty: ";
        String[] props = null;
        String propType = null;
        if (type == 0) {
            props = config.getPropertyArray("default");
            propType = "default";
        } else if (type == 1) {
            props = config.getPropertyArray(MERGE);
            propType = MERGE;
        }
        debug.message(this.id + "attempting to add property=" + name + ", value=" + value + ", type=" + type + " to sso adapter template=" + config.getConfigurationName());
        List<String> olist = Arrays.asList(props);
        ArrayList<String> plist = new ArrayList<String>(olist);
        if (this.containsDuplicateProperties(plist, name)) {
            debug.message("SSOAModelImpl.addConfigTemplateProperty(): containsDuplicateProperties() returned true");
            return false;
        }
        plist.add(name);
        debug.message("SSOAModelImpl.addConfigTemplateProperty(): containsDuplicateProperties() returned false");
        String[] newProps = plist.toArray(new String[0]);
        config.setPropertyArray(propType, newProps);
        if (value != null) {
            config.setProperty(name, value);
        } else {
            debug.warning("SSOAModelImpl.addConfigTemplateProperty(): value is null");
        }
        if (!this.modifyConfigurationTemplate(config)) {
            debug.warning("SSOAModelImpl.addConfigTemplateProperty(): modifyConfigurationTemplate returned false");
            return false;
        }
        return true;
    }

    public boolean addConfigTemplateEncodedProperty(String templ, String[] vals) {
        ArrayList<String> newList;
        if (vals == null) {
            return false;
        }
        Configuration config = this.getConfigurationTemplate(templ);
        String mid = this.id + ".addConfigTemplateEncodedProperty: ";
        String[] props = config.getPropertyArray(ENCODED);
        ArrayList<String> propList = new ArrayList<String>(Arrays.asList(props));
        if (!this.containsDuplicateProperties(propList, newList = new ArrayList<String>(Arrays.asList(vals)))) {
            propList.addAll(newList);
            String[] newProps = propList.toArray(new String[0]);
            config.setPropertyArray(ENCODED, newProps);
            return this.modifyConfigurationTemplate(config);
        }
        return false;
    }

    public boolean containsDuplicateProperties(ArrayList currentVals, String name) {
        String[] val = new String[]{name};
        ArrayList<String> newVal = new ArrayList<String>(Arrays.asList(val));
        return this.containsDuplicateProperties(currentVals, newVal);
    }

    public boolean containsDuplicateProperties(ArrayList currentVals, ArrayList newVals) {
        if (newVals.contains(ENCODED) || newVals.contains("default") || newVals.contains(MERGE)) {
            debug.warning("Property name is reserved.");
            return false;
        }
        for (int i = 0; i < newVals.size(); ++i) {
            if (!currentVals.contains(newVals.get(i))) continue;
            debug.warning((String)newVals.get(i) + " property already exists.");
            return true;
        }
        return false;
    }

    public boolean removeConfigurationTemplates(List toDelete) {
        if (toDelete == null || toDelete.isEmpty()) {
            return false;
        }
        Map attrMap = this.getAttributeMap(SchemaType.GLOBAL);
        Set attrSet = (Set)attrMap.get(ATTR_TEMPLATES_NAME);
        String mid = this.id + ".removeConfigurationTemplates: ";
        if (attrSet != null) {
            try {
                Iterator iter = attrSet.iterator();
                while (iter.hasNext()) {
                    String configName;
                    Configuration config = new Configuration((String)iter.next());
                    if (config == null || !toDelete.contains(configName = config.getConfigurationName())) continue;
                    iter.remove();
                    debug.message(mid + "removing configuration " + configName);
                }
                ServiceSchemaManager svcSchemaMgr = this.getServiceSchemaManager(SERVICE_NAME);
                ServiceSchema schema = svcSchemaMgr.getSchema(SchemaType.GLOBAL);
                schema.setAttributeDefaults(ATTR_TEMPLATES_NAME, attrSet);
            }
            catch (SMSException smse) {
                debug.error(mid + "failed to remove sso adapter template : ", (Throwable)smse);
            }
            catch (SSOException ssoe) {
                debug.error(mid + "failed to remove sso adapter template : ", (Throwable)ssoe);
            }
            catch (Exception e) {
                debug.error(mid + "failed to remove sso adapter template : ", (Throwable)e);
            }
        } else {
            debug.warning(mid + "sso adapter attribute list is empty, nothing to remove");
        }
        return true;
    }

    public boolean modifyConfigurationTemplate(Configuration config) {
        if (config == null) {
            return false;
        }
        ArrayList<String> rlist = new ArrayList<String>();
        rlist.add(config.getConfigurationName());
        if (!this.removeConfigurationTemplates(rlist)) {
            return false;
        }
        return this.addConfigurationTemplate(config);
    }

    public Configuration getConfiguration(String cname) {
        Map attrMap = this.getAttributeMap(SchemaType.DYNAMIC);
        Set attrSet = (Set)attrMap.get(ATTR_CONFIGURATIONS_NAME);
        String mid = this.id + ".getConfiguration: ";
        Configuration config = null;
        if (attrSet != null) {
            Iterator iter = attrSet.iterator();
            while (iter.hasNext() && ((config = new Configuration((String)iter.next())) == null || !config.getConfigurationName().equals(cname))) {
            }
        }
        debug.message(mid + "returning " + config.toString());
        return config;
    }

    public List getConfigurations() {
        Map attrMap = this.getAttributeMap(SchemaType.DYNAMIC);
        Set configAttr = (Set)attrMap.get(ATTR_CONFIGURATIONS_NAME);
        ArrayList<Configuration> configList = new ArrayList<Configuration>();
        String mid = this.id + ".getConfigurations: ";
        if (configAttr != null) {
            Iterator iter = configAttr.iterator();
            while (iter.hasNext()) {
                Configuration config = new Configuration((String)iter.next());
                if (config == null) continue;
                configList.add(config);
            }
            Collections.sort(configList, ConfigComparator);
        } else {
            debug.message(mid + "no attribute values found");
        }
        debug.message(mid + "returning: " + configList);
        return configList;
    }

    public boolean addConfiguration(String name, String desc) {
        if (name == null && desc == null) {
            return false;
        }
        if (!this.containsDuplicateConfiguration(name)) {
            String configURL;
            Configuration config = new Configuration();
            config.setConfigurationName(name);
            if (desc != null) {
                config.setConfigurationDescription(desc);
            }
            return this.setDynamicAttribute(configURL = "default|" + config.toString());
        }
        return false;
    }

    public boolean containsDuplicateConfiguration(String name) {
        List configs = this.getConfigurations();
        Iterator iter = configs.iterator();
        debug.message("SSOAdapterModelImpl.containsDuplicateConfiguration() name=" + name);
        while (iter.hasNext()) {
            Configuration config = (Configuration)iter.next();
            String configName = config.getConfigurationName();
            debug.message("SSOAdapterModelImpl.containsDuplicateConfiguration() configName=" + configName);
            if (!configName.equals(name)) continue;
            debug.message("Configuration " + name + " alreadys exists.");
            return true;
        }
        return false;
    }

    public boolean containsDuplicateTemplate(String name) {
        List templateList = this.getConfigurationTemplateNames(true);
        String[] finalProps = templateList.toArray(new String[0]);
        debug.message("SSOAdapterModelImpl.containsDuplicateTemplate() name=" + name);
        for (int i = 0; i < finalProps.length; ++i) {
            debug.message("SSOAdapterModelImpl.containsDuplicateTemplate() configName=" + finalProps[i]);
            if (!finalProps[i].equals(name)) continue;
            debug.message("Configuration " + name + " alreadys exists.");
            return true;
        }
        return false;
    }

    public boolean addConfiguration(Configuration config) {
        if (config == null) {
            return false;
        }
        if (!this.containsDuplicateConfiguration(config.getConfigurationName())) {
            return this.setDynamicAttribute(config.toString());
        }
        return false;
    }

    public boolean removeConfigurations(List toDelete) {
        block10: {
            if (toDelete == null || toDelete.isEmpty()) {
                return false;
            }
            Map attrMap = this.getAttributeMap(SchemaType.DYNAMIC);
            Set attrSet = (Set)attrMap.get(ATTR_CONFIGURATIONS_NAME);
            String mid = this.id + ".removeConfigurations: ";
            if (attrSet != null) {
                try {
                    Iterator iter = attrSet.iterator();
                    while (iter.hasNext()) {
                        String configName;
                        Configuration config = new Configuration((String)iter.next());
                        if (config == null || !toDelete.contains(configName = config.getConfigurationName())) continue;
                        iter.remove();
                        debug.message(mid + "removing configuration " + configName);
                    }
                    if (this.isTemplateLevel()) {
                        AMTemplate template = this.getServiceTemplate(SERVICE_NAME, SchemaType.DYNAMIC);
                        HashMap<String, Set> newMap = new HashMap<String, Set>();
                        newMap.put(ATTR_CONFIGURATIONS_NAME, attrSet);
                        template.setAttributes(newMap);
                        template.store();
                        break block10;
                    }
                    ServiceSchemaManager svcSchemaMgr = this.getServiceSchemaManager(SERVICE_NAME);
                    ServiceSchema schema = svcSchemaMgr.getSchema(SchemaType.DYNAMIC);
                    schema.setAttributeDefaults(ATTR_CONFIGURATIONS_NAME, attrSet);
                }
                catch (SMSException smse) {
                    debug.error(mid + "failed to remove sso adapter configuration: ", (Throwable)smse);
                }
                catch (SSOException ssoe) {
                    debug.error(mid + "failed to remove sso adapter configuration: ", (Throwable)ssoe);
                }
                catch (AMException ame) {
                    debug.error(mid + "failed to remove sso adapter configuration: ", (Throwable)ame);
                }
                catch (Exception e) {
                    debug.error(mid + "failed to remove sso adapter configuration: ", (Throwable)e);
                }
            } else {
                debug.message(mid + "sso adapter configuration attribute list is empty, nothing to remove");
            }
        }
        return true;
    }

    public boolean modifyConfiguration(Configuration config) {
        if (config == null) {
            return false;
        }
        ArrayList<String> rlist = new ArrayList<String>();
        rlist.add(config.getConfigurationName());
        if (!this.removeConfigurations(rlist)) {
            return false;
        }
        return this.addConfiguration(config);
    }

    public Configuration getUserConfiguration(String cname) {
        Set attrSet = null;
        Configuration config = null;
        String mid = this.id + ".getUserConfiguration: ";
        try {
            attrSet = this.user.getAttribute(ATTR_CONFIGURATIONS_NAME);
        }
        catch (SSOException ssoe) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)ssoe);
        }
        catch (AMException ame) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)ame);
        }
        catch (Exception e) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)e);
        }
        if (attrSet != null) {
            Iterator iter = attrSet.iterator();
            while (iter.hasNext() && ((config = new Configuration((String)iter.next())) == null || !config.getConfigurationName().equals(cname))) {
            }
        }
        debug.message(mid + "returning " + config.toString());
        return config;
    }

    public List getUserConfigurations() {
        HashSet attrSet = null;
        String mid = this.id + ".getUserConfigurations: ";
        try {
            attrSet = this.user.getAttribute(ATTR_CONFIGURATIONS_NAME);
        }
        catch (SSOException ssoe) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)ssoe);
        }
        catch (AMException ame) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)ame);
        }
        catch (Exception e) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)e);
        }
        if (attrSet == null) {
            attrSet = new HashSet();
        }
        ArrayList<Configuration> configList = new ArrayList<Configuration>();
        if (attrSet != null) {
            Iterator iter = attrSet.iterator();
            while (iter.hasNext()) {
                Configuration config = new Configuration((String)iter.next());
                if (config == null) continue;
                configList.add(config);
            }
            Collections.sort(configList, ConfigComparator);
        } else {
            debug.warning(mid + "no attribute values found");
        }
        debug.message(mid + "returning " + configList);
        return configList;
    }

    public boolean addUserConfiguration(String name, String desc) {
        if (name == null) {
            return false;
        }
        if (!this.containsDuplicateConfiguration(name)) {
            Set attrSet = null;
            Configuration config = new Configuration();
            String mid = this.id + ".addUserConfiguration: ";
            config.setConfigurationName(name);
            if (desc != null) {
                config.setConfigurationDescription(desc);
            }
            String configURL = "default|" + config.toString();
            try {
                attrSet = this.user.getAttribute(ATTR_CONFIGURATIONS_NAME);
                if (attrSet != null) {
                    attrSet.add(configURL);
                    HashMap<String, Set> attrMap = new HashMap<String, Set>();
                    attrMap.put(ATTR_CONFIGURATIONS_NAME, attrSet);
                    this.user.setAttributes(attrMap);
                    this.user.store();
                }
            }
            catch (SSOException ssoe) {
                debug.error(mid + "failed to add configuration ", (Throwable)ssoe);
            }
            catch (AMException ame) {
                debug.error(mid + "failed to add configuration ", (Throwable)ame);
            }
            catch (Exception e) {
                debug.error(mid + "failed to add configuration ", (Throwable)e);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean removeUserConfigurations(List toDelete) {
        if (toDelete == null || toDelete.isEmpty()) {
            return false;
        }
        Set attrSet = null;
        String mid = this.id + ".removeUserConfigurations: ";
        try {
            attrSet = this.user.getAttribute(ATTR_CONFIGURATIONS_NAME);
        }
        catch (SSOException ssoe) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)ssoe);
        }
        catch (AMException ame) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)ame);
        }
        catch (Exception e) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)e);
        }
        if (attrSet != null) {
            try {
                Iterator iter = attrSet.iterator();
                while (iter.hasNext()) {
                    Configuration config = new Configuration((String)iter.next());
                    if (config == null || !toDelete.contains(config.getConfigurationName())) continue;
                    iter.remove();
                }
                HashMap<String, Set> attrMap = new HashMap<String, Set>();
                attrMap.put(ATTR_CONFIGURATIONS_NAME, attrSet);
                this.user.setAttributes(attrMap);
                this.user.store();
            }
            catch (SSOException ssoe) {
                debug.error(mid + "failed to remove user level configuration ", (Throwable)ssoe);
            }
            catch (AMException ame) {
                debug.error(mid + "failed to remove user level configuration ", (Throwable)ame);
            }
            catch (Exception e) {
                debug.error(mid + "failed to remove user level configuration ", (Throwable)e);
            }
        } else {
            debug.message(mid + "no attribute value found");
        }
        return true;
    }

    public boolean modifyUserConfiguration(Configuration newConfig) {
        if (newConfig == null) {
            return false;
        }
        Set attrSet = null;
        String cname = newConfig.getConfigurationName();
        String mid = this.id + ".modifyUserConfiguration: ";
        Configuration config = null;
        try {
            attrSet = this.user.getAttribute(ATTR_CONFIGURATIONS_NAME);
        }
        catch (SSOException ssoe) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)ssoe);
        }
        catch (AMException ame) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)ame);
        }
        catch (Exception e) {
            debug.error(mid + "failed to retrieve user attribute ", (Throwable)e);
        }
        if (attrSet != null) {
            Iterator iter = attrSet.iterator();
            while (iter.hasNext()) {
                config = new Configuration((String)iter.next());
                if (config == null || !config.getConfigurationName().equals(cname)) continue;
                iter.remove();
                break;
            }
        }
        attrSet.add(newConfig.toString());
        HashMap<String, Set> attrMap = new HashMap<String, Set>();
        attrMap.put(ATTR_CONFIGURATIONS_NAME, attrSet);
        try {
            this.user.setAttributes(attrMap);
            this.user.store();
        }
        catch (SSOException se) {
            debug.error(mid + "failed to modify user attribute ", (Throwable)se);
        }
        catch (AMException ae) {
            debug.error(mid + "failed to modify user attribute ", (Throwable)ae);
        }
        catch (Exception e) {
            debug.error(mid + "failed to modify user attribute ", (Throwable)e);
        }
        return true;
    }

    public void setCurrentConfiguration(Configuration config) {
        this.currentConfig = config;
    }

    public Configuration getCurrentConfiguration() {
        return this.currentConfig;
    }

    private Map getAttributeMap(SchemaType type) {
        return this.getAttributeMap(type, false);
    }

    private Map getAttributeMap(SchemaType type, boolean schemaOverride) {
        Map attrMap = new HashMap();
        try {
            if (this.isTemplateLevel() && !schemaOverride) {
                AMTemplate template = this.getServiceTemplate(SERVICE_NAME, SchemaType.DYNAMIC);
                attrMap = template.getAttributes();
            } else {
                ServiceSchemaManager svcSchemaMgr = this.getServiceSchemaManager(SERVICE_NAME);
                ServiceSchema schema = svcSchemaMgr.getSchema(type);
                attrMap = schema.getAttributeDefaults();
            }
        }
        catch (SMSException smse) {
            debug.error(this.id + "getAttributeMap(): ", (Throwable)smse);
        }
        catch (SSOException ssoe) {
            debug.error(this.id + "getAttributeMap(): ", (Throwable)ssoe);
        }
        catch (AMException ame) {
            debug.error(this.id + "getAttributeMap(): ", (Throwable)ame);
        }
        catch (Exception e) {
            debug.error(this.id + "getAttributeMap(): general exception ", (Throwable)e);
        }
        if (attrMap == null) {
            attrMap = new HashMap();
        }
        return attrMap;
    }

    private boolean setDynamicAttribute(String attribute) {
        Map attrMap = new HashMap();
        Set attrSet = null;
        try {
            if (this.isTemplateLevel()) {
                AMTemplate template = this.getServiceTemplate(SERVICE_NAME, SchemaType.DYNAMIC);
                attrMap = template.getAttributes();
                attrSet = (Set)attrMap.get(ATTR_CONFIGURATIONS_NAME);
                attrSet.add(attribute);
                HashMap<String, Set> newMap = new HashMap<String, Set>();
                newMap.put(ATTR_CONFIGURATIONS_NAME, attrSet);
                template.setAttributes(newMap);
                template.store();
            } else {
                ServiceSchemaManager svcSchemaMgr = this.getServiceSchemaManager(SERVICE_NAME);
                ServiceSchema schema = svcSchemaMgr.getSchema(SchemaType.DYNAMIC);
                attrMap = schema.getAttributeDefaults();
                attrSet = (Set)attrMap.get(ATTR_CONFIGURATIONS_NAME);
                attrSet.add(attribute);
                schema.setAttributeDefaults(ATTR_CONFIGURATIONS_NAME, attrSet);
            }
            return true;
        }
        catch (SMSException smse) {
            debug.error(this.id + "setDynamicAttribute(): ", (Throwable)smse);
        }
        catch (SSOException ssoe) {
            debug.error(this.id + "setDynamicAttribute(): ", (Throwable)ssoe);
        }
        catch (AMException ame) {
            debug.error(this.id + "setDynamicAttribute(): ", (Throwable)ame);
        }
        catch (Exception e) {
            debug.error(this.id + "setDynamicAttribute(): general exception ", (Throwable)e);
        }
        return false;
    }

    protected void setCurrentUser(String dn) {
        this.userDN = dn;
        String mid = this.id + ".setCurrentUser: ";
        try {
            if (this.userDN != null && this.userDN.length() > 0) {
                this.user = this.dpStoreConn.getUser(this.userDN);
                if (this.user != null && !this.user.isExists()) {
                    this.user = null;
                    debug.message(mid + "setting current user=" + this.user.getDN());
                }
            }
        }
        catch (SSOException ssoe) {
            debug.error(mid + "failed to set current user ", (Throwable)ssoe);
        }
    }

    private Configuration getGenericConfiguration(String name) {
        String defaultString = null;
        Configuration config = null;
        config = this.getConfigurationTemplate(ATTR_GENERIC_TEMPLATE);
        if (config == null) {
            debug.message("SSOAdapterModelImpl.getGenericConfiguration(): Cannot retrieve GENERIC_TEMPLATESSOAdapter template.  Using built-in default");
            defaultString = "default|" + config.toString() + "&encoded=password" + "&default=protocol" + "&default=clientProtocol" + "&default=enableProxyAuth" + "&default=proxyAdminUid" + "&default=proxyAdminPassword" + "&default=ssoClassName" + "&default=enablePerRequestConnection" + "&merge=host" + "&merge=port" + "&merge=clientPort" + "&merge=uid" + "&merge=password" + "&clientProtocol=http" + "&enableProxyAuth=false" + "&enablePerRequestConnection=true" + "&default=userAttribute" + "&userAttribute=uid";
            config = this.getConfigurationTemplate(defaultString);
            return config;
        }
        config.setConfigurationName(name);
        return config;
    }
}

