/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.ab.pim;

import com.aligo.pim.PimFieldType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressBook;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.sun.addressbook.ABFilter;
import com.sun.addressbook.ABSearchTerm;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.ABStoreException;
import com.sun.addressbook.AddressBook;
import com.sun.addressbook.Element;
import com.sun.addressbook.Entry;
import com.sun.addressbook.Group;
import com.sun.addressbook.OperationNotSupportedException;
import com.sun.ssoadapter.ab.pim.JPimABConstants;
import com.sun.ssoadapter.ab.pim.JPimABSearchTerm;
import com.sun.ssoadapter.ab.pim.JPimABStore;
import com.sun.ssoadapter.ab.pim.SchemaElements;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class JPimAddressBook
extends AddressBook
implements JPimABConstants {
    private PimAddressBook pimAB = null;
    private SchemaElements schemaElements = null;
    protected JPimABStore jPimStore = null;
    private String addressBookID = null;

    public JPimAddressBook(ABStore store, PimAddressBook pBook, String abID) {
        super(store, abID);
        JPimABStore jPimStore = (JPimABStore)store;
        this.schemaElements = jPimStore.getSchemaElements();
        this.pimAB = pBook;
    }

    public Element[] fetch(ABFilter abFilter) throws ABStoreException, OperationNotSupportedException {
        try {
            return this.pimFetch(abFilter);
        }
        catch (PimException pe) {
            pe.printStackTrace();
            throw new ABStoreException("Fetch failed: " + (Object)((Object)pe));
        }
    }

    private Element[] pimFetch(ABFilter abFilter) throws PimException, ABStoreException {
        int count;
        System.out.println("======================================================");
        PimAddressEntryItems pimAEItems = this.pimAB.getAddressEntryItems();
        if (abFilter.getGroup() != null) {
            Group g = abFilter.getGroup();
            PimAddressEntryItem pimGroup = pimAEItems.getAddressEntryItem(g.getUn());
            pimAEItems = pimGroup.getMembers();
        }
        PimAddressEntryItemFilter filter = pimAEItems.getAddressEntryItemFilter();
        JPimABSearchTerm searchTerm = (JPimABSearchTerm)abFilter.getSearchTerm();
        searchTerm.setAddressEntryItemFilter(filter);
        abFilter.getSearchFilter();
        switch (abFilter.getSortOrder()) {
            case 1: {
                pimAEItems.sort(PimSortType.ASCENDING);
                break;
            }
            case 2: {
                pimAEItems.sort(PimSortType.DESCENDING);
                break;
            }
        }
        String sortBy = abFilter.getSortBy();
        if (sortBy != null) {
            int size;
            sortBy = sortBy.trim();
            ArrayList<PimFieldType> list = new ArrayList<PimFieldType>(1);
            if (sortBy.equalsIgnoreCase("fn")) {
                list.add(PimFieldType.FIRST_NAME);
            }
            if (sortBy.equalsIgnoreCase("ln")) {
                list.add(PimFieldType.LAST_NAME);
            }
            if ((size = list.size()) > 0) {
                PimFieldType[] pimFieldTypes = new PimFieldType[size];
                list.toArray(pimFieldTypes);
                pimAEItems.setOrderBy(pimFieldTypes);
            }
        }
        if ((count = pimAEItems.getCount()) <= 0) {
            return null;
        }
        ArrayList<Object> elements = new ArrayList<Object>(count);
        if (abFilter.getElementType() == 1) {
            for (int i = 0; i < count; ++i) {
                PimAddressEntryItem pimAEItem = pimAEItems.getAddressEntryItem(i);
                if (pimAEItem.getMembers() != null) continue;
                elements.add(this.toEntry(pimAEItem, i));
            }
        } else if (abFilter.getElementType() == 2) {
            for (int i = 0; i < count; ++i) {
                PimAddressEntryItem pimAEItem = pimAEItems.getAddressEntryItem(i);
                if (pimAEItem.getMembers() == null) continue;
                elements.add(this.toGroup(pimAEItem, i));
            }
        } else {
            for (int i = 0; i < count; ++i) {
                PimAddressEntryItem pimAEItem = pimAEItems.getAddressEntryItem(i);
                if (pimAEItem.getMembers() == null) {
                    Entry entry = this.toEntry(pimAEItem, i);
                    elements.add(entry);
                    continue;
                }
                Group group = this.toGroup(pimAEItem, i);
                elements.add(group);
            }
        }
        System.out.println("JPimAddressBook.pimFetch : returning elements, count = " + elements.size());
        System.out.println("======================================================");
        return elements.toArray(new Element[elements.size()]);
    }

    public void add(Element element) throws ABStoreException, OperationNotSupportedException {
        int status = -1;
        String msg = null;
        try {
            PimAddressEntryItems pimAEItems = this.pimAB.getAddressEntryItems();
            PimAddressEntryItem newAEItem = pimAEItems.addAddressEntryItem();
            if (element.getElementType() == 2) {
                status = this.copyGroupToAddressEntryItem((Group)element, newAEItem);
                newAEItem.addMembers();
            } else {
                status = this.copyToAddressEntryItem((Entry)element, newAEItem);
            }
            if (status == 0) {
                newAEItem.update();
            }
        }
        catch (PimException pe) {
            msg = pe.toString();
            pe.printStackTrace();
        }
        if (status != 0) {
            throw new ABStoreException("Add element failed: " + msg);
        }
    }

    public void modify(Element oldElement, Element newElement) throws ABStoreException, OperationNotSupportedException {
        int status = -1;
        String msg = null;
        try {
            PimAddressEntryItems pimAEItems = this.pimAB.getAddressEntryItems();
            String un = oldElement.getUn();
            PimAddressEntryItem modAEItem = pimAEItems.getAddressEntryItem(un);
            status = newElement.getElementType() == 2 ? this.copyGroupToAddressEntryItem((Group)newElement, modAEItem) : this.copyToAddressEntryItem((Entry)newElement, modAEItem);
            if (status == 0) {
                modAEItem.update();
            }
        }
        catch (PimException pe) {
            msg = pe.toString();
            status = -1;
            pe.printStackTrace();
        }
        if (status != 0) {
            throw new ABStoreException("Modify contact failed: " + msg);
        }
    }

    public void delete(Element element) throws ABStoreException, OperationNotSupportedException {
        try {
            String un = element.getUn();
            PimAddressEntryItems pimAEItems = this.pimAB.getAddressEntryItems();
            PimAddressEntryItem delAEItem = pimAEItems.getAddressEntryItem(un);
            delAEItem.delete();
        }
        catch (PimException pe) {
            pe.printStackTrace();
            throw new ABStoreException("Delete contact failed: " + (Object)((Object)pe));
        }
    }

    public ABSearchTerm newABSearchTerm(String name, String value, boolean exact) {
        return new JPimABSearchTerm(name, value, exact);
    }

    public ABSearchTerm newABSearchTerm(ABSearchTerm term, int op) throws ABStoreException {
        return new JPimABSearchTerm(term, op);
    }

    public ABSearchTerm newABSearchTerm(ABSearchTerm[] terms, int op) throws ABStoreException {
        return new JPimABSearchTerm(terms, op);
    }

    public Element[] fetchGroupMembers(ABFilter filter, Group group) throws ABStoreException, OperationNotSupportedException {
        filter.setGroup(group);
        Element[] elements = this.fetch(filter);
        filter.setGroup(null);
        return elements;
    }

    public void addGroupMember(Element element, Group group) throws ABStoreException, OperationNotSupportedException {
        int status = -1;
        String msg = null;
        try {
            PimAddressEntryItems pimAEItems = this.pimAB.getAddressEntryItems();
            PimAddressEntryItem pimGroup = pimAEItems.getAddressEntryItem(group.getUn());
            System.out.println("JPimAddressBook.addGroupMember :  Add element " + element.getCn() + " to group " + pimGroup + "[" + group.getUn() + "]");
            PimAddressEntryItems memberItems = pimGroup.addMembers();
            PimAddressEntryItem memberItem = memberItems.addAddressEntryItem();
            status = element.getElementType() == 2 ? this.copyGroupToAddressEntryItem((Group)element, memberItem) : this.copyToAddressEntryItem((Entry)element, memberItem);
            if (status == 0) {
                memberItem.update();
                pimGroup.update();
            }
        }
        catch (PimException pe) {
            msg = pe.toString();
            pe.printStackTrace();
        }
        if (status != 0) {
            throw new ABStoreException("Add element to Group failed: " + msg);
        }
    }

    public void deleteGroupMember(Element element, Group group) throws ABStoreException, OperationNotSupportedException {
        try {
            String un = element.getUn();
            PimAddressEntryItems pimAEItems = this.pimAB.getAddressEntryItems();
            PimAddressEntryItem pimGroup = pimAEItems.getAddressEntryItem(group.getUn());
            PimAddressEntryItems memberItems = pimGroup.getMembers();
            PimAddressEntryItem delMemberItem = memberItems.getAddressEntryItem(un);
            delMemberItem.delete();
            pimGroup.update();
        }
        catch (PimException pe) {
            pe.printStackTrace();
            throw new ABStoreException("Delete element from group failed: " + (Object)((Object)pe));
        }
    }

    private Entry toEntry(PimAddressEntryItem pimAEItem, int index) throws PimException {
        Object[] commonPropNames = this.schemaElements.getAllCommonPropertyNames();
        if (commonPropNames == null) {
            return null;
        }
        Entry entry = new Entry();
        String entryId = Integer.toString(index);
        entry.setEntryid(entryId);
        String un = pimAEItem.getID();
        entry.setUn(un);
        Class<?> pimAEItemClass = pimAEItem.getClass();
        Class<?> entryClass = entry.getClass();
        for (int i = 0; i < commonPropNames.length; ++i) {
            String entryPropertyName = (String)commonPropNames[i];
            String pimPropertyName = this.schemaElements.getPimElementName(entryPropertyName);
            String getterMethodName = "get" + pimPropertyName;
            String setterMethodName = "set" + entryPropertyName;
            try {
                Method getterMethod = pimAEItemClass.getMethod(getterMethodName, null);
                String value = (String)getterMethod.invoke((Object)pimAEItem, null);
                if (value == null || value.trim().equals("")) continue;
                Object[] values = new String[]{value};
                Method setterMethod = entryClass.getMethod(setterMethodName, JPimABConstants.beanParams);
                setterMethod.invoke((Object)entry, values);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return entry;
    }

    private Group toGroup(PimAddressEntryItem pimAEItem, int index) throws PimException {
        Object[] commonPropNames = this.schemaElements.getAllCommonPropertyNamesForGroup();
        if (commonPropNames == null) {
            return null;
        }
        Group group = new Group();
        String entryId = Integer.toString(index);
        group.setEntryid(entryId);
        String un = pimAEItem.getID();
        group.setUn(un);
        Class<?> pimAEItemClass = pimAEItem.getClass();
        Class<?> groupClass = group.getClass();
        for (int i = 0; i < commonPropNames.length; ++i) {
            String groupPropertyName = (String)commonPropNames[i];
            String pimPropertyName = this.schemaElements.getPimElementNameForGroup(groupPropertyName);
            String getterMethodName = "get" + pimPropertyName;
            String setterMethodName = "set" + groupPropertyName;
            try {
                Method getterMethod = pimAEItemClass.getMethod(getterMethodName, null);
                String value = (String)getterMethod.invoke((Object)pimAEItem, null);
                if (value == null || value.trim().equals("")) continue;
                Object[] values = new String[]{value};
                Method setterMethod = groupClass.getMethod(setterMethodName, JPimABConstants.beanParams);
                setterMethod.invoke((Object)group, values);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return group;
    }

    private int copyToAddressEntryItem(Entry entry, PimAddressEntryItem pimAEItem) throws PimException {
        Object[] commonPropNames = this.schemaElements.getAllCommonPropertyNames();
        if (commonPropNames == null) {
            return -1;
        }
        Class<?> pimAEItemClass = pimAEItem.getClass();
        Class<?> entryClass = entry.getClass();
        for (int i = 0; i < commonPropNames.length; ++i) {
            String entryPropertyName = (String)commonPropNames[i];
            String pimPropertyName = this.schemaElements.getPimElementName(entryPropertyName);
            String getterMethodName = "get" + entryPropertyName;
            String setterMethodName = "set" + pimPropertyName;
            try {
                Method getterMethod = entryClass.getMethod(getterMethodName, null);
                String value = (String)getterMethod.invoke((Object)entry, null);
                if (value == null) continue;
                Object[] values = new String[]{value};
                Method setterMethod = pimAEItemClass.getMethod(setterMethodName, JPimABConstants.beanParams);
                setterMethod.invoke((Object)pimAEItem, values);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 0;
    }

    private int copyGroupToAddressEntryItem(Group group, PimAddressEntryItem pimAEItem) throws PimException {
        Object[] commonPropNames = this.schemaElements.getAllCommonPropertyNamesForGroup();
        if (commonPropNames == null) {
            return -1;
        }
        Class<?> pimAEItemClass = pimAEItem.getClass();
        Class<?> groupClass = group.getClass();
        for (int i = 0; i < commonPropNames.length; ++i) {
            String groupPropertyName = (String)commonPropNames[i];
            String pimPropertyName = this.schemaElements.getPimElementNameForGroup(groupPropertyName);
            String getterMethodName = "get" + groupPropertyName;
            String setterMethodName = "set" + pimPropertyName;
            try {
                Method getterMethod = groupClass.getMethod(getterMethodName, null);
                String value = (String)getterMethod.invoke((Object)group, null);
                if (value == null) continue;
                Object[] values = new String[]{value};
                Method setterMethod = pimAEItemClass.getMethod(setterMethodName, JPimABConstants.beanParams);
                setterMethod.invoke((Object)pimAEItem, values);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }
}

