/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.xml.serialize.ObjectFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactoryImpl;

public abstract class SerializerFactory {
    public static final String FactoriesProperty = "org.apache.xml.serialize.factories";
    private static Hashtable _factories = new Hashtable();

    static {
        SerializerFactory factory = new SerializerFactoryImpl("xml");
        SerializerFactory.registerSerializerFactory(factory);
        factory = new SerializerFactoryImpl("html");
        SerializerFactory.registerSerializerFactory(factory);
        factory = new SerializerFactoryImpl("xhtml");
        SerializerFactory.registerSerializerFactory(factory);
        factory = new SerializerFactoryImpl("text");
        SerializerFactory.registerSerializerFactory(factory);
        String list = System.getProperty(FactoriesProperty);
        if (list != null) {
            StringTokenizer token = new StringTokenizer(list, " ;,:");
            while (token.hasMoreTokens()) {
                String className = token.nextToken();
                try {
                    factory = (SerializerFactory)ObjectFactory.newInstance(className, ObjectFactory.findClassLoader(), true);
                    if (!_factories.containsKey(factory.getSupportedMethod())) continue;
                    _factories.put(factory.getSupportedMethod(), factory);
                }
                catch (Exception except) {
                    // empty catch block
                }
            }
        }
    }

    protected abstract String getSupportedMethod();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSerializerFactory(SerializerFactory factory) {
        Hashtable hashtable = _factories;
        synchronized (hashtable) {
            String method = factory.getSupportedMethod();
            _factories.put(method, factory);
        }
    }

    public abstract Serializer makeSerializer(OutputFormat var1);

    public static SerializerFactory getSerializerFactory(String method) {
        return (SerializerFactory)_factories.get(method);
    }

    public abstract Serializer makeSerializer(OutputStream var1, OutputFormat var2) throws UnsupportedEncodingException;

    public abstract Serializer makeSerializer(Writer var1, OutputFormat var2);
}

