/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.EOFException;
import java.io.IOException;
import org.apache.xerces.impl.XMLEntityHandler;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLScanner;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentScanner;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLDocumentFragmentScannerImpl
extends XMLScanner
implements XMLDocumentScanner,
XMLComponent,
XMLEntityHandler {
    protected static final int SCANNER_STATE_START_OF_MARKUP = 1;
    protected static final int SCANNER_STATE_COMMENT = 2;
    protected static final int SCANNER_STATE_PI = 3;
    protected static final int SCANNER_STATE_DOCTYPE = 4;
    protected static final int SCANNER_STATE_ROOT_ELEMENT = 6;
    protected static final int SCANNER_STATE_CONTENT = 7;
    protected static final int SCANNER_STATE_REFERENCE = 8;
    protected static final int SCANNER_STATE_END_OF_INPUT = 13;
    protected static final int SCANNER_STATE_TERMINATED = 14;
    protected static final int SCANNER_STATE_CDATA = 15;
    protected static final int SCANNER_STATE_TEXT_DECL = 16;
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String NOTIFY_BUILTIN_REFS = "http://apache.org/xml/features/scanner/notify-builtin-refs";
    protected static final String SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT = "elementAttributeLimit";
    protected static final int DEFAULT_ELEMENT_ATTRIBUTE_LIMIT = 10000;
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://xml.org/sax/features/validation", "http://apache.org/xml/features/scanner/notify-builtin-refs", "http://apache.org/xml/features/scanner/notify-char-refs"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, null, Boolean.FALSE, Boolean.FALSE};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-manager"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null};
    private static final boolean DEBUG_SCANNER_STATE = false;
    private static final boolean DEBUG_DISPATCHER = false;
    protected static final boolean DEBUG_CONTENT_SCANNING = false;
    protected XMLDocumentHandler fDocumentHandler;
    protected int[] fEntityStack = new int[4];
    protected int fMarkupDepth;
    protected int fScannerState;
    protected boolean fInScanContent = false;
    protected boolean fHasExternalDTD;
    protected boolean fStandalone;
    protected int fElementAttributeLimit;
    protected QName fCurrentElement;
    protected ElementStack fElementStack = new ElementStack();
    protected boolean fNamespaces;
    protected boolean fNotifyBuiltInRefs = false;
    protected Dispatcher fDispatcher;
    protected Dispatcher fContentDispatcher = this.createContentDispatcher();
    protected QName fElementQName = new QName();
    protected QName fAttributeQName = new QName();
    protected XMLAttributesImpl fAttributes = new XMLAttributesImpl();
    protected XMLString fTempString = new XMLString();
    protected XMLString fTempString2 = new XMLString();
    private String[] fStrings = new String[3];
    private XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private QName fQName = new QName();
    private final char[] fSingleChar = new char[1];
    private XMLEntityManager.ExternalEntity fExternalEntity = new XMLEntityManager.ExternalEntity();

    protected int scanContent() throws IOException, XNIException {
        XMLString content = this.fTempString;
        int c = this.fEntityScanner.scanContent(content);
        if (c == 13) {
            this.fEntityScanner.scanChar();
            this.fStringBuffer.clear();
            this.fStringBuffer.append(this.fTempString);
            this.fStringBuffer.append((char)c);
            content = this.fStringBuffer;
            c = -1;
        }
        if (this.fDocumentHandler != null && content.length > 0) {
            this.fDocumentHandler.characters(content, null);
        }
        if (c == 93 && this.fTempString.length == 0) {
            this.fStringBuffer.clear();
            this.fStringBuffer.append((char)this.fEntityScanner.scanChar());
            this.fInScanContent = true;
            if (this.fEntityScanner.skipChar(93)) {
                this.fStringBuffer.append(']');
                while (this.fEntityScanner.skipChar(93)) {
                    this.fStringBuffer.append(']');
                }
                if (this.fEntityScanner.skipChar(62)) {
                    this.reportFatalError("CDEndInContent", null);
                }
            }
            if (this.fDocumentHandler != null && this.fStringBuffer.length != 0) {
                this.fDocumentHandler.characters(this.fStringBuffer, null);
            }
            this.fInScanContent = false;
            c = -1;
        }
        return c;
    }

    protected int scanEndElement() throws IOException, XNIException {
        this.fElementStack.popElement(this.fElementQName);
        if (!this.fEntityScanner.skipString(this.fElementQName.rawname)) {
            this.reportFatalError("ETagRequired", new Object[]{this.fElementQName.rawname});
        }
        this.fEntityScanner.skipSpaces();
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("ETagUnterminated", new Object[]{this.fElementQName.rawname});
        }
        --this.fMarkupDepth;
        --this.fMarkupDepth;
        if (this.fMarkupDepth < this.fEntityStack[this.fEntityDepth - 1]) {
            this.reportFatalError("ElementEntityMismatch", new Object[]{this.fCurrentElement.rawname});
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endElement(this.fElementQName, null);
        }
        return this.fMarkupDepth;
    }

    protected void scanCharReference() throws IOException, XNIException {
        this.fStringBuffer2.clear();
        int ch = this.scanCharReferenceValue(this.fStringBuffer2, null);
        --this.fMarkupDepth;
        if (ch != -1 && this.fDocumentHandler != null) {
            if (this.fNotifyCharRefs) {
                this.fDocumentHandler.startGeneralEntity(this.fCharRefLiteral, null, null, null);
            }
            this.fDocumentHandler.characters(this.fStringBuffer2, null);
            if (this.fNotifyCharRefs) {
                this.fDocumentHandler.endGeneralEntity(this.fCharRefLiteral, null);
            }
        }
    }

    protected void scanComment() throws IOException, XNIException {
        this.scanComment(this.fStringBuffer);
        --this.fMarkupDepth;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(this.fStringBuffer, null);
        }
    }

    protected void scanEntityReference() throws IOException, XNIException {
        String name = this.fEntityScanner.scanName();
        if (name == null) {
            this.reportFatalError("NameRequiredInReference", null);
            return;
        }
        if (!this.fEntityScanner.skipChar(59)) {
            this.reportFatalError("SemicolonRequiredInReference", new Object[]{name});
        }
        --this.fMarkupDepth;
        if (name == XMLScanner.fAmpSymbol) {
            this.handleCharacter('&', XMLScanner.fAmpSymbol);
        } else if (name == XMLScanner.fLtSymbol) {
            this.handleCharacter('<', XMLScanner.fLtSymbol);
        } else if (name == XMLScanner.fGtSymbol) {
            this.handleCharacter('>', XMLScanner.fGtSymbol);
        } else if (name == XMLScanner.fQuotSymbol) {
            this.handleCharacter('\"', XMLScanner.fQuotSymbol);
        } else if (name == XMLScanner.fAposSymbol) {
            this.handleCharacter('\'', XMLScanner.fAposSymbol);
        } else if (this.fEntityManager.isUnparsedEntity(name)) {
            this.reportFatalError("ReferenceToUnparsedEntity", new Object[]{name});
        } else {
            if (!this.fEntityManager.isDeclaredEntity(name)) {
                if (this.fHasExternalDTD && !this.fStandalone) {
                    if (this.fValidation) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{name}, (short)1);
                    }
                } else {
                    this.reportFatalError("EntityNotDeclared", new Object[]{name});
                }
            }
            this.fEntityManager.startEntity(name, false);
        }
    }

    protected boolean scanStartElement() throws IOException, XNIException {
        if (this.fNamespaces) {
            this.fEntityScanner.scanQName(this.fElementQName);
        } else {
            String name = this.fEntityScanner.scanName();
            this.fElementQName.setValues(null, name, name, null);
        }
        String rawname = this.fElementQName.rawname;
        this.fCurrentElement = this.fElementStack.pushElement(this.fElementQName);
        boolean empty = false;
        this.fAttributes.removeAllAttributes();
        while (true) {
            boolean sawSpace = this.fEntityScanner.skipSpaces();
            int c = this.fEntityScanner.peekChar();
            if (c == 62) {
                this.fEntityScanner.scanChar();
                break;
            }
            if (c == 47) {
                this.fEntityScanner.scanChar();
                if (!this.fEntityScanner.skipChar(62)) {
                    this.reportFatalError("ElementUnterminated", new Object[]{rawname});
                }
                empty = true;
                break;
            }
            if (!this.isValidNameStartChar(c) || !sawSpace) {
                this.reportFatalError("ElementUnterminated", new Object[]{rawname});
            }
            this.scanAttribute(this.fAttributes);
            if (this.fAttributes.getLength() <= this.fElementAttributeLimit) continue;
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "ElementAttributeLimit", new Object[]{rawname, new Integer(this.fElementAttributeLimit)}, (short)2);
        }
        if (this.fDocumentHandler != null) {
            if (empty) {
                --this.fMarkupDepth;
                if (this.fMarkupDepth < this.fEntityStack[this.fEntityDepth - 1]) {
                    this.reportFatalError("ElementEntityMismatch", new Object[]{this.fCurrentElement.rawname});
                }
                this.fDocumentHandler.emptyElement(this.fElementQName, this.fAttributes, null);
                this.fElementStack.popElement(this.fElementQName);
            } else {
                this.fDocumentHandler.startElement(this.fElementQName, this.fAttributes, null);
            }
        }
        return empty;
    }

    protected final void setScannerState(int state) {
        this.fScannerState = state;
    }

    protected void scanXMLDeclOrTextDecl(boolean scanningTextDecl) throws IOException, XNIException {
        super.scanXMLDeclOrTextDecl(scanningTextDecl, this.fStrings);
        --this.fMarkupDepth;
        String version = this.fStrings[0];
        String encoding = this.fStrings[1];
        String standalone = this.fStrings[2];
        this.fStandalone = standalone != null && standalone.equals("yes");
        this.fEntityManager.setStandalone(this.fStandalone);
        if (this.fDocumentHandler != null) {
            if (scanningTextDecl) {
                this.fDocumentHandler.textDecl(version, encoding, null);
            } else {
                this.fDocumentHandler.xmlDecl(version, encoding, standalone, null);
            }
        }
        if (encoding != null) {
            this.fEntityScanner.setEncoding(encoding);
        }
    }

    protected boolean scanCDATASection(boolean complete) throws IOException, XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA(null);
        }
        while (true) {
            int c;
            this.fStringBuffer.clear();
            if (!this.fEntityScanner.scanData("]]", this.fStringBuffer)) {
                if (this.fDocumentHandler != null && this.fStringBuffer.length > 0) {
                    this.fDocumentHandler.characters(this.fStringBuffer, null);
                }
                int brackets = 2;
                while (this.fEntityScanner.skipChar(93)) {
                    ++brackets;
                }
                if (this.fDocumentHandler != null && brackets > 2) {
                    this.fStringBuffer.clear();
                    int i = 2;
                    while (i < brackets) {
                        this.fStringBuffer.append(']');
                        ++i;
                    }
                    this.fDocumentHandler.characters(this.fStringBuffer, null);
                }
                if (this.fEntityScanner.skipChar(62)) break;
                if (this.fDocumentHandler == null) continue;
                this.fStringBuffer.clear();
                this.fStringBuffer.append("]]");
                this.fDocumentHandler.characters(this.fStringBuffer, null);
                continue;
            }
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.characters(this.fStringBuffer, null);
            }
            if ((c = this.fEntityScanner.peekChar()) == -1 || !this.isInvalidLiteral(c)) continue;
            if (XMLChar.isHighSurrogate(c)) {
                this.fStringBuffer.clear();
                this.scanSurrogates(this.fStringBuffer);
                if (this.fDocumentHandler == null) continue;
                this.fDocumentHandler.characters(this.fStringBuffer, null);
                continue;
            }
            this.reportFatalError("InvalidCharInCDSect", new Object[]{Integer.toString(c, 16)});
            this.fEntityScanner.scanChar();
        }
        --this.fMarkupDepth;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA(null);
        }
        return true;
    }

    public boolean scanDocument(boolean complete) throws IOException, XNIException {
        this.fEntityManager.setEntityHandler(this);
        do {
            if (this.fDispatcher.dispatch(complete)) continue;
            return false;
        } while (complete);
        return true;
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    private void handleCharacter(char c, String entity) throws XNIException {
        if (this.fDocumentHandler != null) {
            if (this.fNotifyBuiltInRefs) {
                this.fDocumentHandler.startGeneralEntity(entity, null, null, null);
            }
            this.fSingleChar[0] = c;
            this.fTempString.setValues(this.fSingleChar, 0, 1);
            this.fDocumentHandler.characters(this.fTempString, null);
            if (this.fNotifyBuiltInRefs) {
                this.fDocumentHandler.endGeneralEntity(entity, null);
            }
        }
    }

    protected String getScannerStateName(int state) {
        switch (state) {
            case 4: {
                return "SCANNER_STATE_DOCTYPE";
            }
            case 6: {
                return "SCANNER_STATE_ROOT_ELEMENT";
            }
            case 1: {
                return "SCANNER_STATE_START_OF_MARKUP";
            }
            case 2: {
                return "SCANNER_STATE_COMMENT";
            }
            case 3: {
                return "SCANNER_STATE_PI";
            }
            case 7: {
                return "SCANNER_STATE_CONTENT";
            }
            case 8: {
                return "SCANNER_STATE_REFERENCE";
            }
            case 13: {
                return "SCANNER_STATE_END_OF_INPUT";
            }
            case 14: {
                return "SCANNER_STATE_TERMINATED";
            }
            case 15: {
                return "SCANNER_STATE_CDATA";
            }
            case 16: {
                return "SCANNER_STATE_TEXT_DECL";
            }
        }
        return "??? (" + state + ')';
    }

    public void endEntity(String name) throws XNIException {
        if (this.fInScanContent && this.fStringBuffer.length != 0 && this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(this.fStringBuffer, null);
            this.fStringBuffer.length = 0;
        }
        super.endEntity(name);
        if (this.fMarkupDepth != this.fEntityStack[this.fEntityDepth]) {
            this.reportFatalError("MarkupEntityMismatch", null);
        }
        if (this.fDocumentHandler != null && !this.fScanningAttribute && !name.equals("[xml]")) {
            this.fDocumentHandler.endGeneralEntity(name, null);
        }
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        String feature;
        super.setFeature(featureId, state);
        if (featureId.startsWith("http://apache.org/xml/features/") && (feature = featureId.substring("http://apache.org/xml/features/".length())).equals("scanner/notify-builtin-refs")) {
            this.fNotifyBuiltInRefs = state;
        }
    }

    protected Dispatcher createContentDispatcher() {
        return new FragmentContentDispatcher();
    }

    protected final void setDispatcher(Dispatcher dispatcher) {
        this.fDispatcher = dispatcher;
    }

    protected int handleEndElement(QName element, boolean isEmpty) throws XNIException {
        --this.fMarkupDepth;
        if (this.fMarkupDepth < this.fEntityStack[this.fEntityDepth - 1]) {
            this.reportFatalError("ElementEntityMismatch", new Object[]{this.fCurrentElement.rawname});
        }
        QName startElement = this.fQName;
        this.fElementStack.popElement(startElement);
        if (element.rawname != startElement.rawname) {
            this.reportFatalError("ETagRequired", new Object[]{startElement.rawname});
        }
        if (this.fNamespaces) {
            element.uri = startElement.uri;
        }
        if (this.fDocumentHandler != null && !isEmpty) {
            this.fDocumentHandler.endElement(element, null);
        }
        return this.fMarkupDepth;
    }

    protected void scanAttribute(XMLAttributes attributes) throws IOException, XNIException {
        if (this.fNamespaces) {
            this.fEntityScanner.scanQName(this.fAttributeQName);
        } else {
            String name = this.fEntityScanner.scanName();
            this.fAttributeQName.setValues(null, name, name, null);
        }
        this.fEntityScanner.skipSpaces();
        if (!this.fEntityScanner.skipChar(61)) {
            this.reportFatalError("EqRequiredInAttribute", new Object[]{this.fAttributeQName.rawname});
        }
        this.fEntityScanner.skipSpaces();
        int oldLen = attributes.getLength();
        attributes.addAttribute(this.fAttributeQName, XMLSymbols.fCDATASymbol, null);
        if (oldLen == attributes.getLength()) {
            this.reportFatalError("AttributeNotUnique", new Object[]{this.fCurrentElement.rawname, this.fAttributeQName.rawname});
        }
        boolean isVC = this.fHasExternalDTD && !this.fStandalone;
        this.scanAttributeValue(this.fTempString, this.fTempString2, this.fAttributeQName.rawname, attributes, oldLen, isVC);
        attributes.setValue(oldLen, this.fTempString.toString());
        attributes.setNonNormalizedValue(oldLen, this.fTempString2.toString());
        attributes.setSpecified(oldLen, true);
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDocumentHandler(XMLDocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        super.reset(componentManager);
        try {
            this.fNamespaces = componentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException e) {
            this.fNamespaces = true;
        }
        this.fAttributes.setNamespaces(this.fNamespaces);
        try {
            this.fNotifyBuiltInRefs = componentManager.getFeature(NOTIFY_BUILTIN_REFS);
        }
        catch (XMLConfigurationException e) {
            this.fNotifyBuiltInRefs = false;
        }
        this.fMarkupDepth = 0;
        this.fCurrentElement = null;
        this.fElementStack.clear();
        this.fHasExternalDTD = false;
        this.fStandalone = false;
        try {
            String value = System.getProperty(SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT);
            this.fElementAttributeLimit = value != null && !value.equals("") ? Integer.parseInt(value) : 10000;
        }
        catch (Exception ex) {
            this.fElementAttributeLimit = 10000;
        }
        this.setScannerState(7);
        this.setDispatcher(this.fContentDispatcher);
    }

    public void setInputSource(XMLInputSource inputSource) throws IOException {
        this.fEntityManager.setEntityHandler(this);
        this.fEntityManager.startEntity("$fragment$", inputSource, false, true);
    }

    public Boolean getFeatureDefault(String featureId) {
        int i = 0;
        while (i < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[i].equals(featureId)) {
                return FEATURE_DEFAULTS[i];
            }
            ++i;
        }
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        int i = 0;
        while (i < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[i].equals(propertyId)) {
                return PROPERTY_DEFAULTS[i];
            }
            ++i;
        }
        return null;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        super.setProperty(propertyId, value);
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            String property = propertyId.substring("http://apache.org/xml/properties/".length());
            if (property.equals("internal/entity-manager")) {
                this.fEntityManager = (XMLEntityManager)value;
            }
            return;
        }
    }

    public String getDispatcherName(Dispatcher dispatcher) {
        return "null";
    }

    protected void scanPIData(String target, XMLString data) throws IOException, XNIException {
        super.scanPIData(target, data);
        --this.fMarkupDepth;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(target, data, null);
        }
    }

    public void startEntity(String name, XMLResourceIdentifier identifier, String encoding) throws XNIException {
        if (this.fEntityDepth == this.fEntityStack.length) {
            int[] entityarray = new int[this.fEntityStack.length * 2];
            System.arraycopy(this.fEntityStack, 0, entityarray, 0, this.fEntityStack.length);
            this.fEntityStack = entityarray;
        }
        this.fEntityStack[this.fEntityDepth] = this.fMarkupDepth;
        super.startEntity(name, identifier, encoding);
        if (this.fStandalone && this.fEntityManager.isEntityDeclInExternalSubset(name)) {
            this.reportFatalError("MSG_REFERENCE_TO_EXTERNALLY_DECLARED_ENTITY_WHEN_STANDALONE", new Object[]{name});
        }
        if (this.fDocumentHandler != null && !this.fScanningAttribute && !name.equals("[xml]")) {
            this.fDocumentHandler.startGeneralEntity(name, identifier, encoding, null);
        }
    }

    protected static interface Dispatcher {
        public boolean dispatch(boolean var1) throws IOException, XNIException;
    }

    protected static class ElementStack {
        protected QName[] fElements = new QName[10];
        protected int fSize;

        public ElementStack() {
            int i = 0;
            while (i < this.fElements.length) {
                this.fElements[i] = new QName();
                ++i;
            }
        }

        public void clear() {
            this.fSize = 0;
        }

        public void popElement(QName element) {
            element.setValues(this.fElements[--this.fSize]);
        }

        public QName pushElement(QName element) {
            if (this.fSize == this.fElements.length) {
                QName[] array = new QName[this.fElements.length * 2];
                System.arraycopy(this.fElements, 0, array, 0, this.fSize);
                this.fElements = array;
                int i = this.fSize;
                while (i < this.fElements.length) {
                    this.fElements[i] = new QName();
                    ++i;
                }
            }
            this.fElements[this.fSize].setValues(element);
            return this.fElements[this.fSize++];
        }
    }

    protected class FragmentContentDispatcher
    implements Dispatcher {
        protected boolean elementDepthIsZeroHook() throws IOException, XNIException {
            return false;
        }

        protected boolean scanForDoctypeHook() throws IOException, XNIException {
            return false;
        }

        protected boolean scanRootElementHook() throws IOException, XNIException {
            return false;
        }

        public boolean dispatch(boolean complete) throws IOException, XNIException {
            try {
                boolean again;
                do {
                    again = false;
                    block1 : switch (XMLDocumentFragmentScannerImpl.this.fScannerState) {
                        case 7: {
                            if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(60)) {
                                XMLDocumentFragmentScannerImpl.this.setScannerState(1);
                                again = true;
                                break;
                            }
                            if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(38)) {
                                XMLDocumentFragmentScannerImpl.this.setScannerState(8);
                                again = true;
                                break;
                            }
                            do {
                                int c;
                                if ((c = XMLDocumentFragmentScannerImpl.this.scanContent()) == 60) {
                                    XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar();
                                    XMLDocumentFragmentScannerImpl.this.setScannerState(1);
                                    break block1;
                                }
                                if (c == 38) {
                                    XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar();
                                    XMLDocumentFragmentScannerImpl.this.setScannerState(8);
                                    break block1;
                                }
                                if (c == -1 || !XMLDocumentFragmentScannerImpl.this.isInvalidLiteral(c)) continue;
                                if (XMLChar.isHighSurrogate(c)) {
                                    XMLDocumentFragmentScannerImpl.this.fStringBuffer.clear();
                                    if (!XMLDocumentFragmentScannerImpl.this.scanSurrogates(XMLDocumentFragmentScannerImpl.this.fStringBuffer) || XMLDocumentFragmentScannerImpl.this.fDocumentHandler == null) continue;
                                    XMLDocumentFragmentScannerImpl.this.fDocumentHandler.characters(XMLDocumentFragmentScannerImpl.this.fStringBuffer, null);
                                    continue;
                                }
                                XMLDocumentFragmentScannerImpl.this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(c, 16)});
                                XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar();
                            } while (complete);
                            break;
                        }
                        case 1: {
                            ++XMLDocumentFragmentScannerImpl.this.fMarkupDepth;
                            if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(63)) {
                                XMLDocumentFragmentScannerImpl.this.setScannerState(3);
                                again = true;
                                break;
                            }
                            if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(33)) {
                                if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(45)) {
                                    if (!XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(45)) {
                                        XMLDocumentFragmentScannerImpl.this.reportFatalError("InvalidCommentStart", null);
                                    }
                                    XMLDocumentFragmentScannerImpl.this.setScannerState(2);
                                    again = true;
                                    break;
                                }
                                if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipString("[CDATA[")) {
                                    XMLDocumentFragmentScannerImpl.this.setScannerState(15);
                                    again = true;
                                    break;
                                }
                                if (this.scanForDoctypeHook()) break;
                                XMLDocumentFragmentScannerImpl.this.reportFatalError("MarkupNotRecognizedInContent", null);
                                break;
                            }
                            if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(47)) {
                                if (XMLDocumentFragmentScannerImpl.this.scanEndElement() == 0 && this.elementDepthIsZeroHook()) {
                                    return true;
                                }
                                XMLDocumentFragmentScannerImpl.this.setScannerState(7);
                                break;
                            }
                            if (XMLDocumentFragmentScannerImpl.this.isValidNameStartChar(XMLDocumentFragmentScannerImpl.this.fEntityScanner.peekChar())) {
                                XMLDocumentFragmentScannerImpl.this.scanStartElement();
                                XMLDocumentFragmentScannerImpl.this.setScannerState(7);
                                break;
                            }
                            XMLDocumentFragmentScannerImpl.this.reportFatalError("MarkupNotRecognizedInContent", null);
                            break;
                        }
                        case 2: {
                            XMLDocumentFragmentScannerImpl.this.scanComment();
                            XMLDocumentFragmentScannerImpl.this.setScannerState(7);
                            break;
                        }
                        case 3: {
                            XMLDocumentFragmentScannerImpl.this.scanPI();
                            XMLDocumentFragmentScannerImpl.this.setScannerState(7);
                            break;
                        }
                        case 15: {
                            XMLDocumentFragmentScannerImpl.this.scanCDATASection(complete);
                            XMLDocumentFragmentScannerImpl.this.setScannerState(7);
                            break;
                        }
                        case 8: {
                            ++XMLDocumentFragmentScannerImpl.this.fMarkupDepth;
                            XMLDocumentFragmentScannerImpl.this.setScannerState(7);
                            if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(35)) {
                                XMLDocumentFragmentScannerImpl.this.scanCharReference();
                                break;
                            }
                            XMLDocumentFragmentScannerImpl.this.scanEntityReference();
                            break;
                        }
                        case 16: {
                            if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipString("<?xml")) {
                                ++XMLDocumentFragmentScannerImpl.this.fMarkupDepth;
                                if (XMLDocumentFragmentScannerImpl.this.isValidNameChar(XMLDocumentFragmentScannerImpl.this.fEntityScanner.peekChar())) {
                                    XMLDocumentFragmentScannerImpl.this.fStringBuffer.clear();
                                    XMLDocumentFragmentScannerImpl.this.fStringBuffer.append("xml");
                                    while (XMLDocumentFragmentScannerImpl.this.isValidNameChar(XMLDocumentFragmentScannerImpl.this.fEntityScanner.peekChar())) {
                                        XMLDocumentFragmentScannerImpl.this.fStringBuffer.append((char)XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar());
                                    }
                                    String target = XMLDocumentFragmentScannerImpl.this.fSymbolTable.addSymbol(((XMLDocumentFragmentScannerImpl)XMLDocumentFragmentScannerImpl.this).fStringBuffer.ch, ((XMLDocumentFragmentScannerImpl)XMLDocumentFragmentScannerImpl.this).fStringBuffer.offset, ((XMLDocumentFragmentScannerImpl)XMLDocumentFragmentScannerImpl.this).fStringBuffer.length);
                                    XMLDocumentFragmentScannerImpl.this.scanPIData(target, XMLDocumentFragmentScannerImpl.this.fTempString);
                                } else {
                                    XMLDocumentFragmentScannerImpl.this.scanXMLDeclOrTextDecl(true);
                                }
                            }
                            XMLDocumentFragmentScannerImpl.this.fEntityManager.fCurrentEntity.mayReadChunks = true;
                            XMLDocumentFragmentScannerImpl.this.setScannerState(7);
                            break;
                        }
                        case 6: {
                            if (this.scanRootElementHook()) {
                                return true;
                            }
                            XMLDocumentFragmentScannerImpl.this.setScannerState(7);
                            break;
                        }
                        case 4: {
                            XMLDocumentFragmentScannerImpl.this.reportFatalError("DoctypeIllegalInContent", null);
                        }
                    }
                } while (complete || again);
            }
            catch (EOFException e) {
                this.endOfFileHook(e);
                return false;
            }
            return true;
        }

        protected void endOfFileHook(EOFException e) throws IOException, XNIException {
            if (XMLDocumentFragmentScannerImpl.this.fMarkupDepth != 0) {
                XMLDocumentFragmentScannerImpl.this.reportFatalError("PrematureEOF", null);
            }
        }

        protected FragmentContentDispatcher() {
        }
    }
}

