/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CharacterDataImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements CharacterData,
Text {
    static final long serialVersionUID = -5294980852957403469L;

    public short getNodeType() {
        return 3;
    }

    public TextImpl() {
    }

    public boolean getIsWhitespaceInElementContent() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.internalIsIgnorableWhitespace();
    }

    public boolean isIgnorableWhitespace() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.internalIsIgnorableWhitespace();
    }

    public void setIgnorableWhitespace(boolean ignore) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isIgnorableWhitespace(ignore);
    }

    public String getNodeName() {
        return "#text";
    }

    public String getWholeText() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.nextSibling == null) {
            return this.data;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.data != null && this.data.length() != 0) {
            buffer.append(this.data);
        }
        this.getWholeText(this.nextSibling, buffer);
        return buffer.toString();
    }

    public String removeData() {
        String olddata = this.data;
        this.data = "";
        return olddata;
    }

    public void replaceData(String value) {
        this.data = value;
    }

    private boolean canModify(Node node) {
        while (node != null) {
            short type = node.getNodeType();
            if (type == 5 ? !this.canModify(node.getFirstChild()) : type != 3 && type != 4) {
                return false;
            }
            node = node.getNextSibling();
        }
        return true;
    }

    public Text splitText(int offset) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (offset < 0 || offset > this.data.length()) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        Text newText = this.getOwnerDocument().createTextNode(this.data.substring(offset));
        this.setNodeValue(this.data.substring(0, offset));
        Node parentNode = this.getParentNode();
        if (parentNode != null) {
            parentNode.insertBefore(newText, this.nextSibling);
        }
        return newText;
    }

    public TextImpl(CoreDocumentImpl ownerDoc, String data) {
        super(ownerDoc, data);
    }

    public void setValues(CoreDocumentImpl ownerDoc, String data) {
        this.flags = 0;
        this.nextSibling = null;
        this.previousSibling = null;
        this.setOwnerDocument(ownerDoc);
        this.data = data;
    }

    private boolean getWholeText(Node node, StringBuffer buffer) {
        while (node != null) {
            short type = node.getNodeType();
            if (type == 5) {
                if (this.getWholeText(node.getFirstChild(), buffer)) {
                    return true;
                }
            } else if (type == 3 || type == 4) {
                ((NodeImpl)node).getTextContent(buffer);
            } else {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Text replaceWholeText(String content) throws DOMException {
        void var3_6;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (!this.canModify(this.nextSibling)) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        Node parent = this.getParentNode();
        if ((content == null || content.length() == 0) && parent != null) {
            parent.removeChild(this);
            return null;
        }
        Object var3_3 = null;
        if (this.isReadOnly()) {
            Text newNode = this.ownerDocument().createTextNode(content);
            if (parent == null) return newNode;
            parent.insertBefore(newNode, this);
            parent.removeChild(this);
            Text text = newNode;
        } else {
            this.setData(content);
            TextImpl textImpl = this;
        }
        Node sibling = var3_6.getNextSibling();
        while (sibling != null) {
            parent.removeChild(sibling);
            sibling = var3_6.getNextSibling();
        }
        return var3_6;
    }
}

