/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimReminderItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimTaskReminderItem;
import com.aligo.pim.lotus.recycle.Recycle;
import lotus.domino.Document;

public class LotusPimExistingApptExistingReminderItem
extends LotusPimItem
implements PimReminderItem,
LotusPimTaskReminderItem {
    Document _oDocument;
    long lNoOfMinutesBeforeStart = -1L;

    public LotusPimExistingApptExistingReminderItem(Document document, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        super(lotusPimSession, recycle);
        try {
            this._oDocument = document;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setNoOfMinutesBeforeStart(long l) throws LotusPimException {
        try {
            this.lNoOfMinutesBeforeStart = l;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public long getNoOfMinutesBeforeStart() throws LotusPimException {
        try {
            int n = this.getLotusDocument().getItemValueInteger("$AlarmOffset");
            if (n > 0) {
                return 0L;
            }
            return -1 * n;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private Document getLotusDocument() throws LotusPimException {
        try {
            return this._oDocument;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private String getAlarmUnit() {
        if (this.lNoOfMinutesBeforeStart >= 1440L) {
            return "D";
        }
        if (this.lNoOfMinutesBeforeStart >= 60L) {
            return "H";
        }
        return "M";
    }

    public void update() throws LotusPimException {
        try {
            if (this.lNoOfMinutesBeforeStart >= 0L) {
                this.getLotusDocument().replaceItemValue("$AlarmUnit", (Object)this.getAlarmUnit());
                this.getLotusDocument().replaceItemValue("$AlarmOffset", (Object)new Integer(-1L * this.lNoOfMinutesBeforeStart + ""));
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        try {
            this.lNoOfMinutesBeforeStart = -1L;
            Document document = this.getLotusDocument();
            document.removeItem("$Alarm");
            document.removeItem("$AlarmDescription");
            document.removeItem("$AlarmMemoOptions");
            document.removeItem("Alarms");
            document.removeItem("$AlarmUnit");
            document.removeItem("$AlarmOffset");
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete(boolean bl) throws PimException {
        try {
            this.lNoOfMinutesBeforeStart = -1L;
            Document document = this.getLotusDocument();
            document.removeItem("$Alarm");
            document.removeItem("$AlarmDescription");
            document.removeItem("$AlarmMemoOptions");
            document.removeItem("Alarms");
            document.removeItem("$AlarmUnit");
            document.removeItem("$AlarmOffset");
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getID() throws LotusPimException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFieldItems getFieldItems() throws LotusPimException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getName() throws LotusPimException {
        try {
            return "Reminder Item";
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

