/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.subscriptions.providers;

import com.sun.portal.search.providers.SearchContext;
import com.sun.portal.search.util.Decoder;
import com.sun.portal.subscriptions.providers.Subscription;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class SearchSubscription
extends Subscription {
    private String server = null;
    private String defaultServer = null;
    private ArrayList critera = null;
    private String database = null;
    private String viewAttributes = null;
    private HashMap elements = null;

    public SearchSubscription(String server, String str, String va) {
        super(str);
        this.defaultServer = server;
        this.viewAttributes = va;
        this.elements = new HashMap();
        this.subType = "sunPortalSavedSearch";
    }

    public SearchSubscription(String server, String type, String str, String va) {
        super(str);
        this.defaultServer = server;
        this.subType = type;
        this.viewAttributes = va;
        this.elements = new HashMap();
    }

    public SearchSubscription(String server, String type, String str, String va, ArrayList critera) {
        super(str);
        this.defaultServer = server;
        this.subType = type;
        this.viewAttributes = va;
        this.critera = critera;
        this.elements = new HashMap();
    }

    public Object execute() {
        try {
            SearchContext srchCtx = (SearchContext)this.parse();
            srchCtx.setRDMServer(this.server);
            srchCtx.execute();
            return srchCtx.getResultStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object execute(String srv) {
        try {
            this.server = srv;
            return this.execute();
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object parse() {
        SearchContext srchCtx = null;
        srchCtx = this.subType.equalsIgnoreCase("sunPortalCategorySubscriptions") ? (SearchContext)this.parseCategorySrchSub() : (this.subType.equalsIgnoreCase("sunPortalDiscussionSubscriptions") ? (SearchContext)this.parseDiscussionSrchSub() : (this.subType.equalsIgnoreCase("sunPortalSavedSearch") ? (SearchContext)this.parseSavedSrchSub() : (SearchContext)null));
        return srchCtx;
    }

    public Object parseCategorySrchSub() {
        SearchContext srchCtx = new SearchContext();
        srchCtx.setRDMType("rd-request");
        srchCtx.setQueryLanguage("search");
        srchCtx.setViewAttributes(this.viewAttributes);
        srchCtx.setViewHits(-1);
        String catName = null;
        String catTarget = null;
        String catScope = null;
        String catSince = "0";
        String catRating = "-1";
        try {
            int delimNdx = this.subStr.indexOf("|");
            int prevNdx = 0;
            if (delimNdx != -1) {
                catName = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            }
            if (delimNdx != -1) {
                catTarget = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                catTarget = "ROOT";
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                catScope = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                catScope = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                catSince = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                catSince = "0";
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                catRating = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                catRating = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                this.server = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                this.server = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                this.database = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                this.database = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (catTarget == null) {
                catTarget = "*";
            }
            if (catScope == null) {
                catScope = "*";
            }
            if (this.server == null || this.server.trim().length() == 0) {
                this.server = this.defaultServer;
            }
            if (this.database == null || this.database.trim().length() == 0) {
                this.database = "default";
            }
            this.elements.put("name", catName);
            this.elements.put("target", catTarget);
            this.elements.put("scope", catScope);
            this.elements.put("since", catSince);
            this.elements.put("rating", catRating);
            this.elements.put("server", this.server);
            this.elements.put("database", this.database);
            ArrayList aL = new ArrayList();
            HashMap<String, String> hM = new HashMap<String, String>();
            hM.put("1", "");
            hM.put("2", "<AND>");
            hM.put("3", catScope);
            aL.add(hM);
            srchCtx.setScope(aL);
            srchCtx.setCategory(catTarget);
            srchCtx.setSearchAllCategories(false);
            srchCtx.setDatabase(this.database);
        }
        catch (Exception e) {
            srchCtx = null;
            e.printStackTrace();
        }
        return srchCtx;
    }

    public Object parseDiscussionSrchSub() {
        SearchContext srchCtx = new SearchContext();
        srchCtx.setRDMType("rd-request");
        srchCtx.setQueryLanguage("search");
        srchCtx.setViewAttributes(this.viewAttributes);
        srchCtx.setViewHits(-1);
        String discName = null;
        String discScope = null;
        String discTarget = null;
        String discRating = "-1";
        String discSince = "0";
        try {
            int delimNdx = this.subStr.indexOf("|");
            int prevNdx = 0;
            if (delimNdx != -1) {
                discName = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            }
            if (delimNdx != -1) {
                discTarget = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                discTarget = "";
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                discScope = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                discScope = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                discSince = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                discSince = "0";
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                discRating = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                discRating = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                this.server = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                this.server = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                this.database = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                this.database = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (discName == null) {
                discName = "";
            }
            if (discTarget == null) {
                discTarget = "ROOT";
            }
            if (discScope == null) {
                discScope = "*";
            }
            if (discRating == null) {
                discRating = "-1";
            }
            if (this.server == null || this.server.trim().length() == 0) {
                this.server = this.defaultServer;
            }
            if (this.database == null || this.database.trim().length() == 0) {
                this.database = "discussion";
            }
            this.elements.put("name", discName);
            this.elements.put("target", discTarget);
            this.elements.put("scope", discScope);
            this.elements.put("since", discSince);
            this.elements.put("rating", discRating);
            this.elements.put("server", this.server);
            this.elements.put("database", this.database);
            ArrayList aL = new ArrayList();
            HashMap<String, String> hM = null;
            if (!discSince.equals("0")) {
                hM = new HashMap<String, String>();
                hM.put("1", "RD-Last-Changed");
                hM.put("2", "greater");
                GregorianCalendar c1 = new GregorianCalendar();
                if (discSince.equals("7")) {
                    ((Calendar)c1).add(5, -7);
                }
                if (discSince.equals("30")) {
                    ((Calendar)c1).roll(2, false);
                }
                if (discSince.equals("180")) {
                    ((Calendar)c1).add(2, -6);
                }
                if (discSince.equals("365")) {
                    ((Calendar)c1).roll(1, false);
                }
                SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
                String d1 = df.format(c1.getTime());
                hM.put("3", d1);
                aL.add(hM);
            }
            hM = new HashMap();
            hM.put("1", "");
            hM.put("2", "<AND>");
            hM.put("3", discScope);
            aL.add(hM);
            hM = new HashMap();
            hM.put("1", "RD-Reference-id");
            hM.put("2", "contain");
            hM.put("3", discTarget);
            aL.add(hM);
            int rtg = -1;
            try {
                rtg = new Integer(discRating);
            }
            catch (NumberFormatException e) {
                rtg = -1;
            }
            if (rtg > -1) {
                hM = new HashMap();
                hM.put("1", "RD-Rating");
                hM.put("2", "greater");
                hM.put("3", Integer.toString(rtg - 1));
                aL.add(hM);
            }
            srchCtx.setScope(aL);
            srchCtx.setDatabase(this.database);
        }
        catch (Exception e) {
            srchCtx = null;
            e.printStackTrace();
        }
        return srchCtx;
    }

    public Object parseSavedSrchSub() {
        SearchContext srchCtx = new SearchContext();
        srchCtx.setRDMType("rd-request");
        srchCtx.setQueryLanguage("search");
        srchCtx.setViewAttributes(this.viewAttributes);
        srchCtx.setViewHits(-1);
        String savedSearchName = null;
        String savedSearchScope = null;
        String savedSearchSince = "0";
        String savedSearchRating = "-1";
        try {
            int delimNdx = this.subStr.indexOf("|");
            int prevNdx = 0;
            if (delimNdx != -1) {
                savedSearchName = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            }
            if (delimNdx != -1) {
                savedSearchScope = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                savedSearchScope = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                savedSearchSince = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                savedSearchSince = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                savedSearchRating = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                savedSearchRating = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                this.server = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                this.server = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (delimNdx != -1) {
                this.database = Decoder.urlDecode((String)this.subStr.substring(prevNdx, delimNdx), (String)"UTF-8");
                prevNdx = delimNdx + 1;
                delimNdx = this.subStr.indexOf("|", prevNdx);
            } else if (prevNdx != 0) {
                this.database = Decoder.urlDecode((String)this.subStr.substring(prevNdx), (String)"UTF-8");
                prevNdx = 0;
            }
            if (savedSearchName == null) {
                savedSearchName = "";
            }
            if (savedSearchScope == null) {
                savedSearchScope = "*";
            }
            if (this.server == null || this.server.trim().length() == 0) {
                this.server = this.defaultServer;
            }
            if (this.database == null || this.database.trim().length() == 0) {
                this.database = "default";
            }
            this.elements.put("name", savedSearchName);
            this.elements.put("scope", savedSearchScope);
            this.elements.put("since", savedSearchSince);
            this.elements.put("rating", savedSearchRating);
            this.elements.put("server", this.server);
            this.elements.put("database", this.database);
            ArrayList aL = new ArrayList();
            HashMap<String, String> hM = new HashMap<String, String>();
            hM.put("1", "");
            hM.put("2", "<AND>");
            hM.put("3", savedSearchScope);
            aL.add(hM);
            srchCtx.setScope(aL);
            srchCtx.setDatabase(this.database);
        }
        catch (Exception e) {
            srchCtx = null;
            e.printStackTrace();
        }
        return srchCtx;
    }

    public HashMap getElements() {
        return this.elements;
    }
}

