/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.subscriptions.profiler.cli;

import com.iplanet.am.util.Debug;
import com.sun.portal.desktop.dp.cli.CLIPParser;
import com.sun.portal.subscriptions.profiler.ProfilerException;
import com.sun.portal.subscriptions.profiler.cli.ProfilerCmd;

class Profiler {
    public static final String COMMANDNAME = "Profiler";
    public static final String COMMANDVERSION = "1.0";
    public static final String LOG_FILENAME = "profiler.debug";
    public static final String DSAME_CACHEON = "com.iplanet.am.sdk.caching.enabled";
    private static Debug debug = null;

    Profiler(String[] args) {
        debug = Debug.getInstance((String)LOG_FILENAME);
        if (debug == null) {
            Object[] objectArray = new Object[]{LOG_FILENAME};
        } else {
            debug.setDebug(1);
        }
    }

    public static void main(String[] args) {
        Profiler profiler = new Profiler(args);
        CLIPParser clipp = null;
        try {
            clipp = ProfilerCmd.getCLIPParser();
            ProfilerCmd cmd = new ProfilerCmd(clipp, args);
            cmd.run();
            System.exit(0);
        }
        catch (ProfilerException pex) {
            String wrappedMsg = pex.getWrappedMessage();
            if (wrappedMsg != null && wrappedMsg.length() > 0) {
                Object[] tokens = new Object[]{pex.getLocalizedMessage(), wrappedMsg};
            } else {
                Object[] tokens = new Object[]{pex.getLocalizedMessage()};
            }
            debug.setDebug(1);
            debug.error("Profiler: Failed executing Profiler command ", (Throwable)pex);
            System.exit(1);
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{ex.getLocalizedMessage()};
            debug.setDebug(1);
            debug.error("Profiler: Failed executing Profiler command: ", (Throwable)ex);
            System.exit(1);
        }
    }
}

