/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.subscriptions.profiler;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.EncryptAction;
import com.sun.portal.subscriptions.profiler.Notification;
import com.sun.portal.subscriptions.profiler.NotificationQueue;
import com.sun.portal.subscriptions.profiler.UserQueue;
import com.sun.portal.subscriptions.profiler.cli.ProfilerCmd;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Properties;

public class ProfilerWorker
implements Runnable {
    private AMStoreConnection dsameCon;
    private UserQueue users;
    private NotificationQueue nq;
    private Properties profilerProps;
    private Properties notifierProps;
    private SSOToken ssoToken;
    private String uid;
    private String pwd;

    public ProfilerWorker(AMStoreConnection c, SSOToken sso, String uid, String pwd, UserQueue uq, NotificationQueue nq, Properties p, Properties n) {
        this.dsameCon = c;
        this.ssoToken = sso;
        this.uid = uid;
        this.pwd = pwd;
        this.users = uq;
        this.nq = nq;
        this.profilerProps = p;
        this.notifierProps = n;
    }

    public void run() {
        long startTime;
        long interTime = startTime = System.currentTimeMillis();
        String dnStr = null;
        while ((dnStr = (String)this.users.get()) != null) {
            this.profile(dnStr);
        }
    }

    private void profile(String dnStr) {
        Notification n = null;
        AMUser user = null;
        boolean hasSubs = false;
        String uEmail = null;
        try {
            user = this.dsameCon.getUser(dnStr);
            hasSubs = user.getAssignedServices().contains("SunPortalSubscriptionsService");
            try {
                uEmail = user.getStringAttribute("mail");
            }
            catch (AMException ame) {
            }
            catch (SSOException ssoe) {
                // empty catch block
            }
            if (uEmail == null) {
                ProfilerCmd.debug.error("user DN=" + dnStr + " doesn't have Subscription service");
            } else if (hasSubs) {
                n = new Notification(user, null, null, 0);
                try {
                    int i;
                    URL u = new URL(this.profilerProps.getProperty("profilerProvider") + "&proxyDN=" + URLEncoder.encode(dnStr) + "&proxyAuth=" + URLEncoder.encode((String)AccessController.doPrivileged(new EncryptAction(new String(AdminUtils.getAdminPassword())))));
                    URLConnection connection = u.openConnection();
                    InputStream stream = connection.getInputStream();
                    BufferedInputStream in = new BufferedInputStream(stream);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((i = in.read()) != -1) {
                        out.write(i);
                    }
                    out.flush();
                    this.format(0, n, out.toString(), null);
                    out.close();
                    in.close();
                    stream.close();
                    this.nq.put(n);
                }
                catch (Exception e) {
                    ProfilerCmd.debug.error("Failed to push notification in queue", (Throwable)e);
                }
            } else {
                ProfilerCmd.debug.error("user DN=" + dnStr + " doesn't have Subscription service");
            }
        }
        catch (SSOException se) {
            ProfilerCmd.debug.error("ProfilerWorker : failed on SSO for : " + dnStr);
        }
        catch (AMException ame) {
            ProfilerCmd.debug.error("ProfilerWorker : failed on DSAME action for : " + dnStr);
        }
    }

    private void format(int type, Notification n, String inObj, String prop) {
        if (inObj != null) {
            try {
                if (n.getContent() == null) {
                    n.setContent(new StringBuffer());
                }
                switch (type) {
                    case 0: {
                        this.htmlFormat(inObj, (StringBuffer)n.getContent(), prop);
                        break;
                    }
                    default: {
                        this.textFormat(inObj, (StringBuffer)n.getContent(), prop);
                        break;
                    }
                }
            }
            catch (Exception e) {
                ProfilerCmd.debug.error("ProfilerWorker: failed formating profile output", (Throwable)e);
            }
        }
    }

    private void htmlFormat(String in, StringBuffer out, String prop) {
        try {
            String pattern = "{0}";
            Object[] iA = new String[]{in};
            out.append(MessageFormat.format(pattern, iA));
        }
        catch (Exception e) {
            ProfilerCmd.debug.error("Failed HTML formatting ", (Throwable)e);
        }
    }

    private void textFormat(String in, StringBuffer out, String prop) {
    }
}

