/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.subscriptions.admin.util;

import com.sun.portal.subscriptions.admin.util.Task;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SunOSTask
implements Task {
    public static final String CRON_BEGIN = "# Subscriptions cron entries start here. Don't modify this section";
    public static final String CRON_END = "# Subscriptions cron entries end here.";
    HashMap valuesMap = new HashMap();
    String name = null;
    String organization = null;

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Usage:CronController action org serverroot hours minutes days_of_week");
            return;
        }
        SunOSTask cron = new SunOSTask();
        cron.init(args[0], args[1], args[2]);
        cron.setValue("Hours", args[3]);
        cron.setValue("Mins", args[4]);
        cron.setValue("DaysOfWeek", args[5]);
        cron.Update();
    }

    public void init(String name, String organization, String serverRoot) {
        this.name = name;
        this.organization = organization;
        String headerName = " " + name + ":" + organization;
        if (name.indexOf("Start") != -1) {
            this.setValue("Command", serverRoot + File.separator + "run-cs-cli profiler run -o \"" + organization + "\"");
        } else {
            this.setValue("Command", serverRoot + File.separator + "run-cs-cli profiler stop -o \"" + organization + "\"");
        }
        try {
            Process process = Runtime.getRuntime().exec("/bin/crontab -l");
            InputStream instream = process.getInputStream();
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(instream));
            String temp = null;
            boolean inSection = false;
            boolean gotIt = false;
            String theName = null;
            while ((temp = buffReader.readLine()) != null) {
                if (inSection) {
                    if (!temp.startsWith(CRON_END)) {
                        if (temp.startsWith("#")) {
                            theName = temp.substring(1);
                            continue;
                        }
                        if (theName == null || !theName.equals(headerName)) continue;
                        int i = 0;
                        String[] f = new String[6];
                        StringTokenizer st = new StringTokenizer(temp, " ");
                        while (st.hasMoreTokens()) {
                            f[i] = st.nextToken();
                            if (i == 5) {
                                this.setValue("Hours", f[1]);
                                this.setValue("Mins", f[0]);
                                this.setValue("DaysOfWeek", f[4]);
                                gotIt = true;
                                break;
                            }
                            ++i;
                        }
                        theName = null;
                        if (!gotIt) continue;
                    }
                    break;
                }
                if (!temp.startsWith(CRON_BEGIN)) continue;
                inSection = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void Remove() {
        this.Update(true);
    }

    public void Update() {
        this.Update(false);
    }

    private void Update(boolean isDelete) {
        try {
            String headerName = " " + this.name + ":" + this.organization;
            Process process = Runtime.getRuntime().exec("/bin/crontab -l");
            InputStream instream = process.getInputStream();
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(instream));
            String tmpFileName = "/tmp/ipscron.txt." + Long.toString(System.currentTimeMillis());
            FileWriter outf = new FileWriter(tmpFileName);
            String temp = null;
            boolean inSection = false;
            boolean gotIt = false;
            String theName = null;
            while ((temp = buffReader.readLine()) != null) {
                if (gotIt) {
                    outf.write(temp + "\n");
                    continue;
                }
                if (inSection) {
                    if (temp.startsWith(CRON_END)) {
                        if (!isDelete) {
                            outf.write("#" + headerName + "\n");
                            outf.write(this.getValue("Mins") + " " + this.getValue("Hours") + " * * " + this.getValue("DaysOfWeek") + " " + this.getValue("Command") + "\n");
                        }
                        outf.write("# Subscriptions cron entries end here.\n");
                        gotIt = true;
                        continue;
                    }
                    if (temp.startsWith("#")) {
                        theName = temp.substring(1);
                        if (isDelete && theName.equals(headerName)) continue;
                        outf.write(temp + "\n");
                        continue;
                    }
                    if (theName != null && theName.equals(headerName)) {
                        if (!isDelete) {
                            outf.write(this.getValue("Mins") + " " + this.getValue("Hours") + " * * " + this.getValue("DaysOfWeek") + " " + this.getValue("Command") + "\n");
                        }
                        gotIt = true;
                        continue;
                    }
                } else if (temp.startsWith(CRON_BEGIN)) {
                    System.out.println("CRON_BEGIN reached");
                    inSection = true;
                }
                outf.write(temp + "\n");
            }
            if (!inSection) {
                outf.write("# Subscriptions cron entries start here. Don't modify this section\n");
                outf.write("#" + headerName + "\n");
                outf.write(this.getValue("Mins") + " " + this.getValue("Hours") + " * * " + this.getValue("DaysOfWeek") + " " + this.getValue("Command") + "\n");
                outf.write("# Subscriptions cron entries end here.\n");
            }
            outf.close();
            process = Runtime.getRuntime().exec("/bin/crontab " + tmpFileName);
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            File f = new File(tmpFileName);
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getValue(String param) {
        return (String)this.valuesMap.get(param);
    }

    public void setValue(String key, String value) {
        if (this.valuesMap != null) {
            if (this.valuesMap.containsKey(key)) {
                this.valuesMap.remove(key);
            }
            this.valuesMap.put(key, value);
        }
    }
}

