/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.subscriptions.admin.model;

import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.subscriptions.admin.util.ScheduleFactory;
import com.sun.portal.subscriptions.admin.util.Task;
import java.util.StringTokenizer;

public class ScheduleModel
extends DefaultModel
implements RetrievingModel,
UpdatingModel {
    public static final String FIELD_NAME = "FieldName";
    public static final String FIELD_HOUR = "FieldHour";
    public static final String FIELD_MIN = "FieldMin";
    public static final String FIELD_COMMAND = "Command";
    public static final String FIELD_DIR = "Dir";
    public static final String FIELD_SUN = "Sun";
    public static final String FIELD_MON = "Mon";
    public static final String FIELD_TUE = "Tue";
    public static final String FIELD_WED = "Wed";
    public static final String FIELD_THU = "Thu";
    public static final String FIELD_FRI = "Fri";
    public static final String FIELD_SAT = "Sat";
    private static final String[] WEEKDAYS_ARRAY = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    public static final String[] hourLabel = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    public static final String[] hourValues = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    public static final String[] minValues = new String[]{"00", "10", "20", "30", "40", "50"};
    protected String name = null;
    protected String organization = null;
    protected String serverRoot = null;

    public ScheduleModel() {
    }

    public ScheduleModel(String name, String organization, String serverRoot) {
        super(name);
        this.setName(name);
        this.setOrganization(organization);
        this.setServerRoot(serverRoot);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrganization(String org) {
        this.organization = org;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        }
        return result;
    }

    public Object update(ModelExecutionContext context) throws ModelControlException {
        Task task = this.newTaskObject();
        task.init(this.name, this.organization, this.serverRoot);
        task.setValue("Mins", (String)this.getValue(FIELD_MIN));
        task.setValue("Hours", (String)this.getValue(FIELD_HOUR));
        String dir = (String)this.getValue(FIELD_DIR);
        String d = "";
        if (((String)this.getValue(FIELD_SUN)).compareTo("true") == 0) {
            d = d + "0,";
        }
        if (((String)this.getValue(FIELD_MON)).compareTo("true") == 0) {
            d = d + "1,";
        }
        if (((String)this.getValue(FIELD_TUE)).compareTo("true") == 0) {
            d = d + "2,";
        }
        if (((String)this.getValue(FIELD_WED)).compareTo("true") == 0) {
            d = d + "3,";
        }
        if (((String)this.getValue(FIELD_THU)).compareTo("true") == 0) {
            d = d + "4,";
        }
        if (((String)this.getValue(FIELD_FRI)).compareTo("true") == 0) {
            d = d + "5,";
        }
        if (((String)this.getValue(FIELD_SAT)).compareTo("true") == 0) {
            d = d + "6,";
        }
        if (d.trim().length() > 0) {
            task.setValue("DaysOfWeek", d.substring(0, d.length() - 1));
            task.Update();
        } else {
            task.Remove();
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        this.clear();
        if (this.name != null) {
            String v;
            Task task = this.newTaskObject();
            task.init(this.name, this.organization, this.serverRoot);
            this.setValue(FIELD_NAME, this.name);
            String hrs = task.getValue("Hours");
            String mins = task.getValue("Mins");
            if (hrs != null && mins != null) {
                this.setValue(FIELD_HOUR, hrs);
                this.setValue(FIELD_MIN, mins);
            }
            if ((v = task.getValue("DaysOfWeek")) != null) {
                StringTokenizer st = new StringTokenizer(v, ",");
                while (st.hasMoreTokens()) {
                    String d = st.nextToken();
                    int ndx = Integer.parseInt(d);
                    try {
                        this.setValue(WEEKDAYS_ARRAY[ndx], "true");
                    }
                    catch (Exception e) {}
                }
            }
        }
        return null;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        if (this.name != null) {
            Task task = this.newTaskObject();
            task.init(this.name, this.organization, this.serverRoot);
            task.Remove();
        }
        return null;
    }

    private Task newTaskObject() {
        try {
            return ScheduleFactory.getNewTask();
        }
        catch (Exception e) {
            return null;
        }
    }
}

