/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.PSDefaultFolder;
import com.sun.mail.imap.PSIMAPFolder;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.protocol.Namespaces;
import com.sun.mail.imap.protocol.PSIMAPProtocol;
import java.io.IOException;
import java.util.Vector;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.URLName;

public class PSIMAPStore
extends Store
implements ResponseHandler {
    private String name = "psimap";
    private int blksize = 16384;
    private int port = 143;
    private int statusCacheTimeout = 1000;
    private int appendBufferSize = -1;
    private String host;
    private String user;
    private String password;
    private Namespaces namespaces;
    private boolean debug;
    private ConnectionPool pool = new ConnectionPool();

    public PSIMAPStore(Session session, URLName url) {
        super(session, url);
        this.pool.lastTimePruned = System.currentTimeMillis();
        this.debug = session.getDebug();
        String s = session.getProperty("mail." + this.name + ".connectionpool.debug");
        if (s != null && s.equalsIgnoreCase("true")) {
            this.pool.debug = true;
        }
        if (url != null) {
            this.name = url.getProtocol();
        }
        if ((s = session.getProperty("mail." + this.name + ".partialfetch")) != null && s.equalsIgnoreCase("false")) {
            this.blksize = -1;
        } else {
            s = session.getProperty("mail." + this.name + ".fetchsize");
            if (s != null) {
                this.blksize = Integer.parseInt(s);
            }
        }
        s = session.getProperty("mail." + this.name + ".statuscachetimeout");
        if (s != null) {
            this.statusCacheTimeout = Integer.parseInt(s);
        }
        if ((s = session.getProperty("mail." + this.name + ".appendbuffersize")) != null) {
            this.appendBufferSize = Integer.parseInt(s);
        }
        if ((s = session.getProperty("mail." + this.name + ".connectionpoolsize")) != null) {
            try {
                int size = Integer.parseInt(s);
                if (size > 0) {
                    this.pool.poolSize = size;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (this.pool.debug) {
                System.out.println("DEBUG: found a pool size property: " + this.pool.poolSize);
            }
        }
        if ((s = session.getProperty("mail." + this.name + ".connectionpooltimeout")) != null) {
            try {
                int connectionPoolTimeout = Integer.parseInt(s);
                if (connectionPoolTimeout > 0) {
                    this.pool.clientTimeoutInterval = connectionPoolTimeout;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (this.pool.debug) {
                System.out.println("DEBUG: found a timeout property: " + this.pool.clientTimeoutInterval);
            }
        }
        if ((s = session.getProperty("mail." + this.name + ".separatestoreconnection")) != null && s.equalsIgnoreCase("true")) {
            if (this.pool.debug) {
                System.out.println("DEBUG: dedicate a store connection");
            }
            this.pool.separateStoreConnection = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean protocolConnect(String host, int pport, String user, String password) throws MessagingException {
        block15: {
            PSIMAPProtocol protocol = null;
            if (host == null || password == null || user == null) {
                return false;
            }
            if (pport != -1) {
                this.port = pport;
            } else {
                String portstring = this.session.getProperty("mail." + this.name + ".port");
                if (portstring != null) {
                    this.port = Integer.parseInt(portstring);
                }
            }
            if (this.port == -1) {
                this.port = 143;
            }
            try {
                boolean poolEmpty;
                ConnectionPool connectionPool = this.pool;
                synchronized (connectionPool) {
                    poolEmpty = this.pool.authenticatedConnections.isEmpty();
                }
                if (!poolEmpty) break block15;
                protocol = new PSIMAPProtocol(this.name, host, this.port, this.session.getDebug(), this.session.getProperties());
                this.login(protocol, user, password);
                protocol.addResponseHandler(this);
                this.host = host;
                this.user = user;
                this.password = password;
                connectionPool = this.pool;
                synchronized (connectionPool) {
                    this.pool.authenticatedConnections.addElement(protocol);
                }
            }
            catch (CommandFailedException cex) {
                protocol.disconnect();
                protocol = null;
                throw new AuthenticationFailedException(cex.getResponse().getRest());
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
            catch (IOException ioex) {
                throw new MessagingException(ioex.getMessage(), (Exception)ioex);
            }
        }
        return true;
    }

    private void login(PSIMAPProtocol p, String u, String pw) throws ProtocolException {
        if (p.isAuthenticated()) {
            return;
        }
        if (p.hasCapability("AUTH-LOGIN") || p.hasCapability("AUTH=LOGIN")) {
            p.authlogin(u, pw);
        } else {
            p.login(u, pw);
        }
        String proxyauthUser = this.session.getProperty("mail." + this.name + ".proxyauth.user");
        if (proxyauthUser != null) {
            p.proxyauth(proxyauthUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PSIMAPProtocol getProtocol(PSIMAPFolder folder) throws MessagingException {
        PSIMAPProtocol p = null;
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.authenticatedConnections.isEmpty() || this.pool.separateStoreConnection && this.pool.authenticatedConnections.size() == 1 || this.pool.borrowedStoreConnections > 0L && this.pool.authenticatedConnections.size() == 1) {
                if (this.debug) {
                    System.out.println("DEBUG: no connections in the pool, creating a new one");
                }
                try {
                    p = new PSIMAPProtocol(this.name, this.host, this.port, this.session.getDebug(), this.session.getProperties());
                    this.login(p, this.user, this.password);
                }
                catch (Exception ex1) {
                    if (p != null) {
                        try {
                            p.disconnect();
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                    p = null;
                }
                if (p == null) {
                    throw new MessagingException("connection failure");
                }
            } else {
                if (this.debug) {
                    System.out.println("DEBUG: connection available -- size: " + this.pool.authenticatedConnections.size());
                }
                p = (PSIMAPProtocol)((Object)this.pool.authenticatedConnections.lastElement());
                p.removeResponseHandler(this);
                this.pool.authenticatedConnections.removeElement((Object)p);
            }
            this.timeoutConnections();
            if (folder != null) {
                if (this.pool.folders == null) {
                    this.pool.folders = new Vector();
                }
                this.pool.folders.addElement(folder);
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PSIMAPProtocol getStoreProtocol() throws ProtocolException {
        PSIMAPProtocol p = null;
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.authenticatedConnections.isEmpty()) {
                if (this.pool.debug) {
                    System.out.println("DEBUG: getStoreProtocol() - no connections in the pool, creating a new one");
                }
                try {
                    p = new PSIMAPProtocol(this.name, this.host, this.port, this.session.getDebug(), this.session.getProperties());
                    this.login(p, this.user, this.password);
                }
                catch (Exception ex1) {
                    if (p != null) {
                        try {
                            p.logout();
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                    p = null;
                }
                if (p == null) {
                    throw new ProtocolException("connection failure");
                }
                p.addResponseHandler(this);
                this.pool.authenticatedConnections.addElement(p);
            } else {
                if (this.pool.debug) {
                    System.out.println("DEBUG: getStoreProtocol() - connection available -- size: " + this.pool.authenticatedConnections.size());
                }
                p = (PSIMAPProtocol)((Object)this.pool.authenticatedConnections.firstElement());
            }
            if (!this.pool.separateStoreConnection) {
                this.pool.borrowedStoreConnections++;
                if (this.pool.debug) {
                    System.out.println("DEBUG: getStoreProtocol() -- borrowedStoreConnections: " + this.pool.borrowedStoreConnections);
                }
            }
            this.timeoutConnections();
            return p;
        }
    }

    boolean allowReadOnlySelect() {
        String s = this.session.getProperty("mail." + this.name + ".allowreadonlyselect");
        return s != null && s.equalsIgnoreCase("true");
    }

    boolean hasSeparateStoreConnection() {
        return this.pool.separateStoreConnection;
    }

    boolean getConnectionPoolDebug() {
        return this.pool.debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isConnectionPoolFull() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.pool.debug) {
                System.out.println("DEBUG: current size: " + this.pool.authenticatedConnections.size() + "   pool size: " + this.pool.poolSize);
            }
            return this.pool.authenticatedConnections.size() >= this.pool.poolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseProtocol(PSIMAPFolder folder, PSIMAPProtocol protocol) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (protocol != null) {
                if (!this.isConnectionPoolFull()) {
                    protocol.addResponseHandler(this);
                    this.pool.authenticatedConnections.addElement(protocol);
                    if (this.debug) {
                        System.out.println("DEBUG: added an Authenticated connection -- size: " + this.pool.authenticatedConnections.size());
                    }
                } else {
                    if (this.debug) {
                        System.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                    }
                    try {
                        protocol.logout();
                    }
                    catch (ProtocolException pex) {
                        // empty catch block
                    }
                }
            }
            if (this.pool.folders != null) {
                this.pool.folders.removeElement((Object)folder);
            }
            this.timeoutConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseStoreProtocol(PSIMAPProtocol protocol) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (!this.pool.separateStoreConnection) {
                this.pool.borrowedStoreConnections--;
                if (this.pool.debug) {
                    System.out.println("DEBUG: releaseStoreProtocol() -- borrowedStoreConnections: " + this.pool.borrowedStoreConnections);
                }
            }
            this.timeoutConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyConnectionPool() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            for (int index = this.pool.authenticatedConnections.size() - 1; index >= 0; --index) {
                try {
                    ((PSIMAPProtocol)((Object)this.pool.authenticatedConnections.elementAt(index))).removeResponseHandler(this);
                    ((PSIMAPProtocol)((Object)this.pool.authenticatedConnections.elementAt(index))).logout();
                    continue;
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
            }
            this.pool.authenticatedConnections.removeAllElements();
        }
        if (this.pool.debug) {
            System.out.println("DEBUG: removed all authenticated connections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutConnections() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (System.currentTimeMillis() - this.pool.lastTimePruned > this.pool.pruningInterval && this.pool.authenticatedConnections.size() > 1) {
                if (this.pool.debug) {
                    System.out.println("DEBUG: checking for connections to prune: " + (System.currentTimeMillis() - this.pool.lastTimePruned));
                    System.out.println("DEBUG: clientTimeoutInterval: " + this.pool.clientTimeoutInterval);
                }
                for (int index = this.pool.authenticatedConnections.size() - 1; index > 0; --index) {
                    PSIMAPProtocol p = (PSIMAPProtocol)((Object)this.pool.authenticatedConnections.elementAt(index));
                    if (this.pool.debug) {
                        System.out.println("DEBUG: protocol last used: " + (System.currentTimeMillis() - p.getTimestamp()));
                    }
                    if (System.currentTimeMillis() - p.getTimestamp() <= this.pool.clientTimeoutInterval) continue;
                    if (this.pool.debug) {
                        System.out.println("DEBUG: authenticated connection timed out");
                        System.out.println("DEBUG: logging out the connection");
                    }
                    p.removeResponseHandler(this);
                    this.pool.authenticatedConnections.removeElementAt(index);
                    try {
                        p.logout();
                        continue;
                    }
                    catch (ProtocolException pex) {
                        // empty catch block
                    }
                }
                this.pool.lastTimePruned = System.currentTimeMillis();
            }
        }
    }

    int getFetchBlockSize() {
        return this.blksize;
    }

    Session getSession() {
        return this.session;
    }

    int getStatusCacheTimeout() {
        return this.statusCacheTimeout;
    }

    int getAppendBufferSize() {
        return this.appendBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            p.noop();
        }
        catch (ProtocolException protocolException) {
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        return super.isConnected();
    }

    public void close() throws MessagingException {
        if (!super.isConnected()) {
            return;
        }
        PSIMAPProtocol protocol = null;
        try {
            protocol = this.getStoreProtocol();
            protocol.logout();
        }
        catch (ProtocolException pex) {
            this.cleanup();
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(protocol);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanup() {
        Vector foldersCopy = null;
        boolean done = true;
        block10: while (true) {
            ConnectionPool connectionPool = this.pool;
            synchronized (connectionPool) {
                if (this.pool.folders != null) {
                    done = false;
                    foldersCopy = this.pool.folders;
                    this.pool.folders = null;
                } else {
                    done = true;
                }
            }
            if (done) break;
            int i = 0;
            int fsize = foldersCopy.size();
            while (true) {
                if (i >= fsize) continue block10;
                PSIMAPFolder f = (PSIMAPFolder)((Object)foldersCopy.elementAt(i));
                try {
                    f.close(false);
                }
                catch (MessagingException mex) {
                    // empty catch block
                }
                ++i;
            }
            break;
        }
        ConnectionPool i = this.pool;
        synchronized (i) {
            this.emptyConnectionPool();
        }
        try {
            super.close();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new PSDefaultFolder(this);
    }

    public Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        return new PSIMAPFolder(name, '\uffff', this);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return new PSIMAPFolder(url.getFile(), '\uffff', this);
    }

    public Folder[] getPersonalNamespaces() throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.personal == null) {
            return super.getPersonalNamespaces();
        }
        return this.namespaceToFolders(ns.personal, null);
    }

    public Folder[] getUserNamespaces(String user) throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.otherUsers == null) {
            return super.getUserNamespaces(user);
        }
        return this.namespaceToFolders(ns.otherUsers, user);
    }

    public Folder[] getSharedNamespaces() throws MessagingException {
        Namespaces ns = this.getNamespaces();
        if (ns == null || ns.shared == null) {
            return super.getSharedNamespaces();
        }
        return this.namespaceToFolders(ns.shared, null);
    }

    private synchronized Namespaces getNamespaces() throws MessagingException {
        this.checkConnected();
        PSIMAPProtocol p = null;
        if (this.namespaces == null) {
            try {
                p = this.getStoreProtocol();
                this.namespaces = p.namespace();
            }
            catch (BadCommandException bex) {
            }
            catch (ProtocolException pex) {
                throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
            }
            finally {
                this.releaseStoreProtocol(p);
            }
        }
        return this.namespaces;
    }

    private Folder[] namespaceToFolders(Namespaces.Namespace[] ns, String user) {
        Folder[] fa = new Folder[ns.length];
        for (int i = 0; i < fa.length; ++i) {
            String name = ns[i].prefix;
            if (user == null) {
                int len = name.length();
                if (len > 0 && name.charAt(len - 1) == ns[i].delimiter) {
                    name = name.substring(0, len - 1);
                }
            } else {
                name = name + user;
            }
            fa[i] = new PSIMAPFolder(name, ns[i].delimiter, this);
        }
        return fa;
    }

    public Quota[] getQuota(String root) throws MessagingException {
        Quota[] qa = null;
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            qa = p.getQuotaRoot(root);
        }
        catch (BadCommandException bex) {
            throw new MessagingException("QUOTA not supported", (Exception)((Object)bex));
        }
        catch (ConnectionException cex) {
            throw new StoreClosedException((Store)this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
        return qa;
    }

    public void setQuota(Quota quota) throws MessagingException {
        PSIMAPProtocol p = null;
        try {
            p = this.getStoreProtocol();
            p.setQuota(quota);
        }
        catch (BadCommandException bex) {
            throw new MessagingException("QUOTA not supported", (Exception)((Object)bex));
        }
        catch (ConnectionException cex) {
            throw new StoreClosedException((Store)this, cex.getMessage());
        }
        catch (ProtocolException pex) {
            throw new MessagingException(pex.getMessage(), (Exception)((Object)pex));
        }
        finally {
            this.releaseStoreProtocol(p);
        }
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    public void handleResponse(Response r) {
        if (r.isBYE()) {
            if (super.isConnected()) {
                this.cleanup();
            }
            return;
        }
        if (r.isOK()) {
            String s = r.toString();
            if (s.indexOf("ALERT") != -1) {
                this.notifyStoreListeners(1, s);
            } else {
                this.notifyStoreListeners(2, s);
            }
        }
    }

    void handleResponseCode(Response r) {
        String s = r.getRest();
        boolean isAlert = false;
        if (s.startsWith("[")) {
            int i = s.indexOf(93);
            if (i > 0 && s.substring(0, i + 1).equalsIgnoreCase("[ALERT]")) {
                isAlert = true;
            }
            s = s.substring(i + 1).trim();
        }
        if (isAlert) {
            this.notifyStoreListeners(1, s);
        } else if (r.isUnTagged() && s.length() > 0) {
            this.notifyStoreListeners(2, s);
        }
    }

    static class ConnectionPool {
        private Vector authenticatedConnections = new Vector();
        private Vector folders;
        private boolean separateStoreConnection = false;
        private long borrowedStoreConnections = 0L;
        private long clientTimeoutInterval = 45000L;
        private long lastTimePruned;
        private int poolSize = 1;
        private long pruningInterval = 60000L;
        private boolean debug = false;

        ConnectionPool() {
        }
    }
}

