/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.name;

import com.sun.xml.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.messaging.saaj.soap.name.Body1_1Name;
import com.sun.xml.messaging.saaj.soap.name.Body1_2Name;
import com.sun.xml.messaging.saaj.soap.name.CodeSubcode1_2Name;
import com.sun.xml.messaging.saaj.soap.name.Detail1_1Name;
import com.sun.xml.messaging.saaj.soap.name.Envelope1_1Name;
import com.sun.xml.messaging.saaj.soap.name.Envelope1_2Name;
import com.sun.xml.messaging.saaj.soap.name.Fault1_1Name;
import com.sun.xml.messaging.saaj.soap.name.Fault1_2Name;
import com.sun.xml.messaging.saaj.soap.name.Header1_1Name;
import com.sun.xml.messaging.saaj.soap.name.Header1_2Name;
import com.sun.xml.messaging.saaj.soap.name.NotUnderstood1_2Name;
import com.sun.xml.messaging.saaj.soap.name.SOAP1_1Name;
import com.sun.xml.messaging.saaj.soap.name.SOAP1_2Name;
import com.sun.xml.messaging.saaj.soap.name.SupportedEnvelope1_2Name;
import com.sun.xml.messaging.saaj.soap.name.Upgrade1_2Name;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.Name;
import org.apache.xerces.xni.NamespaceContext;
import org.w3c.dom.Element;

public class NameImpl
implements Name {
    public static final String XML_NAMESPACE_PREFIX = "xml";
    public static final String XML_SCHEMA_NAMESPACE_PREFIX = "xs";
    public static final String SOAP_ENVELOPE_PREFIX = "SOAP-ENV";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String SOAP11_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP12_NAMESPACE = "http://www.w3.org/2002/06/soap-envelope";
    public static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    protected String uri = "";
    protected String localName = "";
    protected transient String prefix = "";
    private transient String qualifiedName = null;
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap.name", "com.sun.xml.messaging.saaj.soap.name.LocalStrings");

    public static NameImpl createDetail1_1Name() {
        return new Detail1_1Name();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Name)) {
            return false;
        }
        Name otherName = (Name)obj;
        if (!this.uri.equals(otherName.getURI())) {
            return false;
        }
        return this.localName.equals(otherName.getLocalName());
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.prefix != null && this.prefix.length() > 0 ? this.prefix + ":" + this.localName : this.localName;
        }
        return this.qualifiedName;
    }

    public String getURI() {
        return this.uri;
    }

    protected static int getPrefixSeparatorIndex(String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        if (index < 0) {
            log.log(Level.SEVERE, "SAAJ0202.name.invalid.arg.format", new String[]{qualifiedName});
            throw new IllegalArgumentException("Argument \"" + qualifiedName + "\" must be of the form: \"prefix:localName\"");
        }
        return index;
    }

    protected NameImpl(String name) {
        this.localName = name;
    }

    public static boolean isQualified(String tagName) {
        return tagName.indexOf(58) >= 0;
    }

    public static NameImpl createBody1_1Name(String prefix) {
        return new Body1_1Name(prefix);
    }

    public static NameImpl createBody1_2Name(String prefix) {
        return new Body1_2Name(prefix);
    }

    public static NameImpl createDetail1_1Name(String prefix) {
        return new Detail1_1Name(prefix);
    }

    public static NameImpl createEnvelope1_1Name(String prefix) {
        return new Envelope1_1Name(prefix);
    }

    public static NameImpl createEnvelope1_2Name(String prefix) {
        return new Envelope1_2Name(prefix);
    }

    public static NameImpl createFault1_1Name(String prefix) {
        return new Fault1_1Name(prefix);
    }

    public static NameImpl createFromUnqualifiedName(String name) {
        return new NameImpl(name);
    }

    public static NameImpl createHeader1_1Name(String prefix) {
        return new Header1_1Name(prefix);
    }

    public static NameImpl createHeader1_2Name(String prefix) {
        return new Header1_2Name(prefix);
    }

    public static NameImpl createNotUnderstood1_2Name(String prefix) {
        return new NotUnderstood1_2Name(prefix);
    }

    public static NameImpl createSOAP11Name(String string) {
        return new SOAP1_1Name(string, null);
    }

    public static NameImpl createSOAP12Name(String string) {
        return new SOAP1_2Name(string, null);
    }

    public static NameImpl createSupportedEnvelope1_2Name(String prefix) {
        return new SupportedEnvelope1_2Name(prefix);
    }

    public static NameImpl createUpgrade1_2Name(String prefix) {
        return new Upgrade1_2Name(prefix);
    }

    public static NameImpl createXmlName(String localName) {
        return new NameImpl(localName, XML_NAMESPACE_PREFIX, XML_NAMESPACE);
    }

    public static String getLocalNameFromQualifiedName(String qualifiedName) {
        return qualifiedName.substring(NameImpl.getPrefixSeparatorIndex(qualifiedName) + 1);
    }

    public static String getLocalNameFromTagName(String tagName) {
        if (NameImpl.isQualified(tagName)) {
            return NameImpl.getLocalNameFromQualifiedName(tagName);
        }
        return tagName;
    }

    public static String getPrefixFromQualifiedName(String qualifiedName) {
        return qualifiedName.substring(0, NameImpl.getPrefixSeparatorIndex(qualifiedName));
    }

    public static String getPrefixFromTagName(String tagName) {
        if (NameImpl.isQualified(tagName)) {
            return NameImpl.getPrefixFromQualifiedName(tagName);
        }
        return "";
    }

    public static Name createFromTagName(String tagName) {
        return NameImpl.createFromTagAndUri(tagName, "");
    }

    public static Name copyElementName(Element element) {
        String uri;
        String prefix;
        String localName = element.getLocalName();
        String tagName = null;
        if (localName == null) {
            tagName = element.getTagName();
            localName = NameImpl.getLocalNameFromTagName(tagName);
        }
        if ((prefix = element.getPrefix()) == null) {
            if (tagName == null) {
                tagName = element.getTagName();
            }
            prefix = NameImpl.getPrefixFromTagName(tagName);
        }
        if ((uri = element.getNamespaceURI()) == null) {
            uri = ElementImpl.getNamespaceURIFrom(element, prefix);
        }
        return NameImpl.create(localName, prefix, uri);
    }

    public static NameImpl createCodeSubcode1_2Name(String prefix, String localName) {
        return new CodeSubcode1_2Name(localName, prefix);
    }

    public static NameImpl createFault1_2Name(String localName, String prefix) {
        return new Fault1_2Name(localName, prefix);
    }

    public static NameImpl createSOAP12Name(String localName, String prefix) {
        return new SOAP1_2Name(localName, prefix);
    }

    public static String createQName(String prefix, String localName) {
        if (prefix == null || prefix.equals("")) {
            return localName;
        }
        return prefix + ":" + localName;
    }

    protected NameImpl(String name, String prefix, String uri) {
        this.uri = uri == null ? "" : uri;
        this.localName = name == null ? "" : name;
        String string = this.prefix = prefix == null ? "" : prefix;
        if (this.prefix.equals("xmlns") && this.uri.equals("")) {
            this.uri = NamespaceContext.XMLNS_URI;
        }
        if (this.uri.equals(NamespaceContext.XMLNS_URI) && this.prefix.equals("")) {
            this.prefix = "xmlns";
        }
    }

    public static Name createFromQualifiedName(String qualifiedName, String uri) {
        return NameImpl.createFromTagAndUri(qualifiedName, uri);
    }

    protected static Name createFromTagAndUri(String tagName, String uri) {
        if (tagName == null) {
            log.severe("SAAJ0201.name.not.created.from.null.tag");
            throw new RuntimeException("Cannot create a name from a null tag.");
        }
        int index = tagName.indexOf(58);
        if (index < 0) {
            return new NameImpl(tagName, "", uri);
        }
        return new NameImpl(tagName.substring(index + 1), tagName.substring(0, index), uri);
    }

    public static NameImpl create(String name, String prefix, String uri) {
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        if (name == null) {
            name = "";
        }
        if (!uri.equals("") && !name.equals("")) {
            if (uri.equals(SOAP11_NAMESPACE)) {
                if (name.equalsIgnoreCase("Envelope")) {
                    return NameImpl.createEnvelope1_1Name(prefix);
                }
                if (name.equalsIgnoreCase("Header")) {
                    return NameImpl.createHeader1_1Name(prefix);
                }
                if (name.equalsIgnoreCase("Body")) {
                    return NameImpl.createBody1_1Name(prefix);
                }
                if (name.equalsIgnoreCase("Fault")) {
                    return NameImpl.createFault1_1Name(prefix);
                }
                return new SOAP1_1Name(name, prefix);
            }
            if (uri.equals(SOAP12_NAMESPACE)) {
                if (name.equalsIgnoreCase("Envelope")) {
                    return NameImpl.createEnvelope1_2Name(prefix);
                }
                if (name.equalsIgnoreCase("Header")) {
                    return NameImpl.createHeader1_2Name(prefix);
                }
                if (name.equalsIgnoreCase("Body")) {
                    return NameImpl.createBody1_2Name(prefix);
                }
                if (name.equals("Fault") || name.equals("Reason") || name.equals("Detail")) {
                    return NameImpl.createFault1_2Name(name, prefix);
                }
                if (name.equals("Code") || name.equals("Subcode")) {
                    return NameImpl.createCodeSubcode1_2Name(prefix, name);
                }
                return new SOAP1_2Name(name, prefix);
            }
        }
        return new NameImpl(name, prefix, uri);
    }
}

