/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.calendar;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSCalendarStore;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.calendar.CalendarApplicationHelper;
import com.sun.portal.providers.calendar.CalendarProvider;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CalendarExpressHelper
implements CalendarApplicationHelper {
    public CalendarProvider provider = null;
    public SSOAdapter ssoAdapter = null;
    public Properties adapterProperties = null;
    protected String appName = "";
    protected String containerName = "";
    private CalExpress calendarExpressObj = null;
    private long lastCheckTime = 0L;
    private long checkInterval;

    public void init(CalendarProvider provider, SSOAdapter ssoAdapter) throws Exception {
        this.provider = provider;
        this.ssoAdapter = ssoAdapter;
        if (ssoAdapter != null) {
            this.adapterProperties = ssoAdapter.getProperties();
        }
        this.checkInterval = Integer.parseInt(this.adapterProperties.getProperty("checkInterval", "5000"));
    }

    public String getStartURL(CalendarProvider provider, HttpServletRequest request) {
        String url = null;
        try {
            url = this.getApplicationURL(provider, request);
            ProviderContext pc = provider.getProviderContext();
            url = pc.escape(url);
        }
        catch (Exception e) {
            SSOAdapterDebug.logWarning((String)(this.getClass().getName() + ".getStartURL(): could not determine start url "), (Throwable)e);
        }
        return url;
    }

    public String getApplicationURL(CalendarProvider provider, HttpServletRequest request) throws Exception {
        String clientURL = null;
        String clientProtocol = this.adapterProperties.getProperty("clientProtocol", "http");
        String host = this.adapterProperties.getProperty("host");
        String clientPort = this.adapterProperties.getProperty("clientPort", this.adapterProperties.getProperty("port", "80"));
        String baseURL = clientProtocol + "://" + host + ":" + clientPort;
        String domain = this.adapterProperties.getProperty("domain");
        SSOToken tok = this.ssoAdapter.getSSOToken();
        if (tok != null) {
            String calid = null;
            String puid = null;
            try {
                calid = provider.getStringProperty("calendar");
            }
            catch (ProviderException pe) {
                calid = null;
            }
            if (calid == null || calid.length() <= 0) {
                String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false");
                if (enableProxyAuth.equals("true")) {
                    AMStoreConnection amsc = null;
                    AMUser auser = null;
                    String usrAttr = this.adapterProperties.getProperty("userAttribute", "uid");
                    try {
                        amsc = new AMStoreConnection(tok);
                        auser = amsc.getUser(tok.getPrincipal().getName());
                        puid = auser.getStringAttribute(usrAttr);
                    }
                    catch (SSOException ssoe) {
                        SSOAdapterDebug.logError((String)(this.getClass().getName() + "getApplicationURL(): proxy uid retrieval " + "failed "), (Throwable)ssoe);
                    }
                    catch (AMException ame) {
                        SSOAdapterDebug.logError((String)(this.getClass().getName() + "getApplicationURL(): proxy uid retrieval " + "failed "), (Throwable)ame);
                    }
                    calid = puid;
                    if (domain != null) {
                        puid = puid + "@" + domain;
                    }
                } else {
                    calid = this.adapterProperties.getProperty("uid");
                }
            }
            if (domain != null) {
                calid = calid + "@" + domain;
            }
            calid = URLEncoder.encode(calid);
            if (this.adapterProperties.getProperty("serverSSOEnabled", "").equals("true")) {
                clientURL = baseURL;
            } else {
                String eprc = this.adapterProperties.getProperty("enablePerRequestConnection", "false");
                String sessionID = null;
                if (eprc.equals("true")) {
                    sessionID = this.getCESessionId(baseURL, tok, puid);
                } else {
                    SOCSCalendarStore socsStore = (SOCSCalendarStore)this.ssoAdapter.getConnection();
                    sessionID = socsStore.getSOCSSession().getID();
                }
                String command = "/command.shtml?view=overview&id=" + sessionID + "&calid=" + calid;
                clientURL = baseURL + command;
            }
        } else {
            clientURL = baseURL;
        }
        return clientURL;
    }

    public String getEventURL(CalendarProvider provider, HttpServletRequest request, VEvent event) throws Exception {
        return null;
    }

    public String getTaskURL(CalendarProvider provider, HttpServletRequest request, VTodo task) throws Exception {
        return null;
    }

    public void error(ProviderContext pc, String msg) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg);
        }
    }

    public void warning(ProviderContext pc, String msg) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg);
        }
    }

    public void message(ProviderContext pc, String msg) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg);
        }
    }

    public void error(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugErrorEnabled()) {
            pc.debugError((Object)msg, t);
        }
    }

    public void warning(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugWarningEnabled()) {
            pc.debugWarning((Object)msg, t);
        }
    }

    public void message(ProviderContext pc, String msg, Throwable t) {
        if (pc.isDebugMessageEnabled()) {
            pc.debugMessage((Object)msg, t);
        }
    }

    public StringBuffer getAppPrefsEdit(CalendarProvider cprov, HttpServletRequest req, HttpServletResponse res) {
        StringBuffer content = new StringBuffer();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        ProviderContext pc = cprov.getProviderContext();
        Map dpEditMap = null;
        String fontTag = "";
        try {
            List pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(cprov.getName(), "dpEditAttributes", pflist);
            fontTag = pc.getStringProperty(cprov.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            tagTable.put("isAppHandler", this.getName());
            ProviderEditUtility.setDefaultPresentation((String)cprov.getName(), (ProviderContext)cprov.getProviderContext(), tagTable);
        }
        catch (ProviderContextException pce) {
            pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            try {
                content.append(pc.getTemplate(this.provider.getName(), "edit-start.template", tagTable));
            }
            catch (ProviderContextException pce) {
                pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
            }
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                while (tok.hasMoreElements()) {
                    String type = tok.nextToken();
                    String header = tok.nextToken();
                    content.append(ProviderEditUtility.createEditContent((String)type, (String)header, (String)key, (String)cprov.getName(), (ProviderContext)pc, (boolean)true));
                }
            }
            try {
                content.append(pc.getTemplate(this.provider.getName(), "edit-end.template", tagTable));
            }
            catch (ProviderContextException pce) {
                pc.debugError((Object)"Exception thrown retrieving values from the display profile\n", (Throwable)pce);
            }
        }
        return content;
    }

    public String getSSOProperty(String key) {
        String tmp = this.adapterProperties.getProperty(key);
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public String getRequestParameter(String key, HttpServletRequest req) {
        String tmp = req.getParameter(key);
        if (tmp == null) {
            tmp = "";
        }
        return tmp;
    }

    public URL processAppPrefsEdit(CalendarProvider cprov, HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        URL url = null;
        Object props = null;
        Map dpEditMap = null;
        ProviderContext pc = cprov.getProviderContext();
        StringBuffer returnURL = new StringBuffer();
        List pflist = null;
        try {
            url = this.getAppHelperProcessURL(request, cprov);
            pflist = pc.getClientAndLocalePropertiesFilters();
            dpEditMap = pc.getCollectionProperty(cprov.getName(), "dpEditAttributes", pflist);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("CalendarExpressHelper.processAppPrefsEdit():\n", (Throwable)pce);
        }
        if (dpEditMap != null) {
            Set entries = dpEditMap.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringTokenizer tok = new StringTokenizer(value, "|");
                String type = tok.nextToken();
                try {
                    pc.debugMessage((Object)("CalendarExpressHelper.processAppPrefsEdit(): key=" + key));
                    if (type.equals("string") || type.equals("select") || type.equals("password")) {
                        String reqString = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        if (reqString.equals("")) continue;
                        if (pc.existsStringProperty(cprov.getName(), key, pflist)) {
                            pc.setStringProperty(cprov.getName(), key, reqString, pflist);
                            pc.debugMessage((Object)("CalendarExpressHelper.processAppPrefsEdit(): reqString(filtered)=" + reqString));
                            continue;
                        }
                        if (pc.existsStringProperty(cprov.getName(), key)) {
                            pc.setStringProperty(cprov.getName(), key, reqString);
                            pc.debugMessage((Object)("CalendarExpressHelper.processAppPrefsEdit(): reqString=" + reqString));
                            continue;
                        }
                        pc.debugWarning((Object)("CalendarExpressHelper.processAppPrefsEdit(): Unable to save key=" + key));
                        continue;
                    }
                    if (type.equals("int")) {
                        String reqNumber = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                        if (reqNumber.equals("")) continue;
                        if (pc.existsIntegerProperty(cprov.getName(), key, pflist)) {
                            pc.setIntegerProperty(cprov.getName(), key, Integer.parseInt(reqNumber), pflist);
                            continue;
                        }
                        if (pc.existsIntegerProperty(cprov.getName(), key)) {
                            pc.setIntegerProperty(cprov.getName(), key, Integer.parseInt(reqNumber));
                            continue;
                        }
                        pc.debugWarning((Object)("CalendarExpressHelper.processAppPrefsEdit(): Unable to save key=" + key));
                        continue;
                    }
                    if (!type.equals("check")) continue;
                    String reqBool = ProviderEditUtility.getRequestParameter((String)key, (HttpServletRequest)request);
                    Boolean bool = null;
                    bool = reqBool.equals("") ? new Boolean("false") : new Boolean("true");
                    if (pc.existsBooleanProperty(cprov.getName(), key, pflist)) {
                        pc.setBooleanProperty(cprov.getName(), key, bool.booleanValue(), pflist);
                        continue;
                    }
                    if (pc.existsBooleanProperty(cprov.getName(), key)) {
                        pc.setBooleanProperty(cprov.getName(), key, bool.booleanValue());
                        continue;
                    }
                    pc.debugWarning((Object)("CalendarExpressHelper.processAppPrefsEdit(): Unable to save key=" + key));
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("CalendarExpressHelper.processAppPrefsEdit():\n", (Throwable)pce);
                }
            }
        }
        pc.debugMessage((Object)("CalendarExpressHelper::processAppPrefsEdit:  Return url = " + url.toString()));
        return url;
    }

    protected boolean isEmpty(String line) {
        return line == null || line.length() > 0;
    }

    protected URL getAppHelperProcessURL(HttpServletRequest req, CalendarProvider prov) {
        ProviderContext pc = prov.getProviderContext();
        StringBuffer link = new StringBuffer();
        URL returnURL = null;
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return null;
        }
        String provider = prov.editContainer;
        String targetProvider = prov.targetProvider;
        String containerName = prov.containerName;
        pc.debugMessage((Object)("CalendarExpressHelper.getAppHelperProcessURL():     provider=" + provider + "\n                                                    targetProvider=" + targetProvider + "\n                                                    containerName=" + containerName));
        if (this.isEmpty(provider) || this.isEmpty(targetProvider) || this.isEmpty(containerName)) {
            pc.debugWarning((Object)"getAppHelperProcessURL():  Missing returnURL parameter and attempting to generate default desktop URL\n");
            try {
                returnURL = new URL(link.toString());
            }
            catch (Exception e) {
                pc.debugWarning((Object)"getAppHelperProcessURL():  Unable to generate default desktop URL\n", (Throwable)e);
                return null;
            }
        }
        link.append("?action=edit&provider=" + provider);
        link.append("&targetprovider=" + targetProvider);
        link.append("&containerName=" + containerName);
        try {
            returnURL = new URL(link.toString());
            pc.debugMessage((Object)("CalendarExpressHelper:getAppHelperProcessURL():  returnURL =" + returnURL));
        }
        catch (Exception e) {
            pc.debugError((Object)"Unable to create returnURL", (Throwable)e);
            return null;
        }
        return returnURL;
    }

    public String getAppHelperEditLink(HttpServletRequest req, ProviderContext pc) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer link = new StringBuffer();
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return "";
        }
        link.append("?action=edit&provider=");
        link.append(ProviderEditUtility.getRequestParameter((String)"provider", (HttpServletRequest)req));
        link.append("&targetprovider=" + this.provider.getName());
        link.append("&containerName=");
        link.append(ProviderEditUtility.getRequestParameter((String)"containerName", (HttpServletRequest)req));
        link.append("&appPref=" + this.getName());
        tagTable.put("editLink", link.toString());
        String content = null;
        try {
            String fontTag = pc.getStringProperty(this.provider.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            content = pc.getTemplate(this.provider.getName(), "edit-link.template", tagTable).toString();
            pc.debugMessage((Object)("content = \n" + content.toString()));
        }
        catch (Exception e) {
            pc.debugError((Object)"unable to create hyperlink\n", (Throwable)e);
            content = "";
        }
        pc.debugMessage((Object)("CalendarExpressHelper: returned value is" + content.toString()));
        return content;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getName() {
        return this.appName;
    }

    private String getCESessionId(String baseUrl, SSOToken token, String puid) {
        String sid = null;
        String user = this.adapterProperties.getProperty("uid");
        String password = this.adapterProperties.getProperty("password");
        boolean urlValid = false;
        String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false");
        if (enableProxyAuth.equals("true")) {
            user = this.adapterProperties.getProperty("proxyAdminUid");
            password = this.adapterProperties.getProperty("proxyAdminPassword");
        }
        CalExpress newCalExpressObj = new CalExpress(user, password, baseUrl);
        if (this.calendarExpressObj != null && this.calendarExpressObj.equals(newCalExpressObj) && this.isValidSession(this.calendarExpressObj)) {
            urlValid = true;
            newCalExpressObj = this.calendarExpressObj;
        }
        if (!urlValid) {
            String resource = baseUrl + "/login.wcap?" + "user=" + URLEncoder.encode(user) + "&password=" + URLEncoder.encode(password) + "&fmt-out=text/xml";
            if (puid != null) {
                resource = resource + "&proxyauth=" + URLEncoder.encode(puid);
            }
            String startDelim = "<X-NSCP-WCAP-SESSION-ID>";
            String endDelim = "</X-NSCP-WCAP-SESSION-ID>";
            String line = null;
            BufferedReader in = null;
            URLConnection urlconn = null;
            URL url = null;
            try {
                url = new URL(resource);
                urlconn = url.openConnection();
                urlconn.setDoInput(true);
                urlconn.setDoOutput(true);
                urlconn.setUseCaches(false);
                in = new BufferedReader(new InputStreamReader(urlconn.getInputStream()));
                while ((line = in.readLine()) != null) {
                    if (line.indexOf(startDelim) == -1) continue;
                    int start = line.indexOf(startDelim) + 24;
                    int end = line.indexOf(endDelim);
                    sid = line.substring(start, end);
                    break;
                }
                in.close();
            }
            catch (Exception e) {
                SSOAdapterDebug.logError((String)(this.getClass().getName() + ".getCESessionId(): Error returning null session id."), (Throwable)e);
                return null;
            }
            if (sid != null) {
                newCalExpressObj.setSessionId(sid);
            }
        }
        this.calendarExpressObj = newCalExpressObj;
        return this.calendarExpressObj.getSessionId();
    }

    private boolean isValidSession(CalExpress calexp) {
        Date newCheckDate = new Date();
        long newCheckTime = newCheckDate.getTime();
        long timeSinceLastCheck = newCheckTime - this.lastCheckTime;
        if (timeSinceLastCheck < this.checkInterval) {
            return true;
        }
        this.lastCheckTime = newCheckTime;
        String cesid = calexp.getSessionId();
        if (cesid == null) {
            return false;
        }
        String startDelim = "<X-NSCP-WCAP-CHECK-ID>";
        String endDelim = "</X-NSCP-WCAP-CHECK-ID>";
        String line = null;
        String vid = null;
        BufferedReader in = null;
        URLConnection urlconn = null;
        URL url = null;
        String resource = calexp.getBaseUri() + "/check_id.wcap?" + "id=" + calexp.getSessionId() + "&fmt-out=text/xml";
        try {
            url = new URL(resource);
            urlconn = url.openConnection();
            urlconn.setDoInput(true);
            urlconn.setDoOutput(true);
            urlconn.setUseCaches(false);
            in = new BufferedReader(new InputStreamReader(urlconn.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (line.indexOf(startDelim) == -1) continue;
                int start = line.indexOf(startDelim) + 22;
                int end = line.indexOf(endDelim);
                vid = line.substring(start, end);
                break;
            }
            in.close();
        }
        catch (Exception e) {
            SSOAdapterDebug.logWarning((String)(this.getClass().getName() + ".isValidSession(): Error validating session id."), (Throwable)e);
            return false;
        }
        return vid != null && vid.equals("1");
    }

    private class CalExpress {
        private String user = null;
        private String pass = null;
        private String baseUri = null;
        private String sid = null;

        CalExpress(String user, String pass, String baseUri) {
            this.user = user;
            this.pass = pass;
            if (baseUri != null && !baseUri.equals("") && baseUri.charAt(baseUri.length() - 1) == '/') {
                baseUri = baseUri.substring(0, baseUri.length() - 1);
            }
            this.baseUri = baseUri;
        }

        boolean equals(CalExpress ceUrl2Comp) {
            return ceUrl2Comp.baseUri.equals(this.baseUri) && ceUrl2Comp.user.equals(this.user) && ceUrl2Comp.pass.equals(this.pass);
        }

        String getBaseUri() {
            return this.baseUri;
        }

        String getSessionId() {
            return this.sid;
        }

        void setSessionId(String sid) {
            this.sid = sid;
        }
    }
}

