/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.spel.test;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.jsptl.lang.spel.Evaluator;
import org.apache.taglibs.jsptl.lang.spel.test.Bean1;
import org.apache.taglibs.jsptl.lang.spel.test.PageContextImpl;

public class PerformanceTest {
    boolean mStartRunning;
    int mRunningThreadCount;
    static /* synthetic */ Class class$java$lang$Boolean;

    public void runTests(int n, int n2) {
        this.runTests(n, n2, true);
        this.runTests(n, n2, false);
    }

    public void runTests(int n, int n2, boolean bl) {
        Evaluator evaluator = new Evaluator();
        PageContext pageContext = PerformanceTest.createTestContext();
        for (int i = 0; i < n; ++i) {
            Runner runner = new Runner(n2, evaluator, pageContext, this, bl);
            new Thread(runner).start();
        }
        this.waitForThreadCount(n);
        long l = System.currentTimeMillis();
        this.startRunning();
        this.waitForThreadCount(0);
        this.mStartRunning = false;
        int n3 = n * n2;
        long l2 = System.currentTimeMillis() - l;
        double d = (double)n3 / (double)l2 * 1000.0;
        System.out.println("Running " + (bl ? "with" : "without") + " the evaluator yields " + n3 + " iterations in " + (double)l2 / 1000.0 + " seconds (" + d + " iters/second)");
    }

    public synchronized void waitForStartRunning() {
        while (!this.mStartRunning) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void startRunning() {
        this.mStartRunning = true;
        this.notifyAll();
    }

    public synchronized void incrementRunningThreadCount() {
        ++this.mRunningThreadCount;
        this.notifyAll();
    }

    public synchronized void decrementRunningThreadCount() {
        --this.mRunningThreadCount;
        this.notifyAll();
    }

    public synchronized void waitForThreadCount(int n) {
        while (this.mRunningThreadCount != n) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static PageContext createTestContext() {
        PageContextImpl pageContextImpl = new PageContextImpl();
        Bean1 bean1 = new Bean1();
        Bean1 bean12 = new Bean1();
        bean1.setBean1(bean12);
        bean12.setInt1(14);
        pageContextImpl.setAttribute("bean1a", bean1, 3);
        return pageContextImpl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            PerformanceTest.usage();
            System.exit(1);
        }
        int n = Integer.valueOf(stringArray[0]);
        int n2 = Integer.valueOf(stringArray[1]);
        PerformanceTest performanceTest = new PerformanceTest();
        performanceTest.runTests(n, n2);
    }

    static void usage() {
        System.err.println("usage: java org.apache.taglibs.jsptl.lang.spel.test.PerformanceTest {thread count} {#iterations}");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Runner
    implements Runnable {
        int mIterations;
        Evaluator mEvaluator;
        PageContext mPageContext;
        PerformanceTest mTest;
        boolean mUseEvaluator;

        public Runner(int n, Evaluator evaluator, PageContext pageContext, PerformanceTest performanceTest, boolean bl) {
            this.mIterations = n;
            this.mEvaluator = evaluator;
            this.mPageContext = pageContext;
            this.mTest = performanceTest;
            this.mUseEvaluator = bl;
        }

        public void run() {
            this.mTest.incrementRunningThreadCount();
            this.mTest.waitForStartRunning();
            if (this.mUseEvaluator) {
                for (int i = 0; i < this.mIterations; ++i) {
                    try {
                        Object object = this.mEvaluator.evaluate("session:bean1a.bean1.int1 < 24", this.mPageContext, class$java$lang$Boolean == null ? PerformanceTest.class$("java.lang.Boolean") : class$java$lang$Boolean);
                        continue;
                    }
                    catch (JspException jspException) {
                        jspException.printStackTrace();
                    }
                }
            } else {
                for (int i = 0; i < this.mIterations; ++i) {
                    Bean1 bean1 = (Bean1)this.mPageContext.getAttribute("bean1a", 3);
                    Bean1 bean12 = bean1.getBean1();
                    int n = bean12.getInt1();
                    boolean bl = n < 24;
                    Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            this.mTest.decrementRunningThreadCount();
        }
    }
}

