/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.spel;

public class RelationalOperator {
    static final int EQ_VALUE = 1;
    static final int NE_VALUE = 2;
    static final int GT_VALUE = 3;
    static final int LT_VALUE = 4;
    static final int GE_VALUE = 5;
    static final int LE_VALUE = 6;
    public static final RelationalOperator EQ = new RelationalOperator(1);
    public static final RelationalOperator NE = new RelationalOperator(2);
    public static final RelationalOperator GT = new RelationalOperator(3);
    public static final RelationalOperator LT = new RelationalOperator(4);
    public static final RelationalOperator GE = new RelationalOperator(5);
    public static final RelationalOperator LE = new RelationalOperator(6);
    int mOp;

    public int getOp() {
        return this.mOp;
    }

    RelationalOperator(int n) {
        this.mOp = n;
    }

    public String toString() {
        switch (this.mOp) {
            case 1: {
                return "==";
            }
            case 2: {
                return "!=";
            }
            case 3: {
                return ">";
            }
            case 4: {
                return "<";
            }
            case 5: {
                return ">=";
            }
            case 6: {
                return "<=";
            }
        }
        return "??";
    }

    public boolean isEqualityOperator() {
        return this.mOp == 1 || this.mOp == 2;
    }

    static Boolean getBooleanValue(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getResult(boolean bl) {
        if (this.mOp == 1) {
            return RelationalOperator.getBooleanValue(bl);
        }
        if (this.mOp == 2) {
            return RelationalOperator.getBooleanValue(!bl);
        }
        return RelationalOperator.getBooleanValue(false);
    }

    public Boolean getResult(int n) {
        switch (this.mOp) {
            case 1: {
                return RelationalOperator.getBooleanValue(n == 0);
            }
            case 2: {
                return RelationalOperator.getBooleanValue(n != 0);
            }
            case 3: {
                return RelationalOperator.getBooleanValue(n > 0);
            }
            case 4: {
                return RelationalOperator.getBooleanValue(n < 0);
            }
            case 5: {
                return RelationalOperator.getBooleanValue(n >= 0);
            }
            case 6: {
                return RelationalOperator.getBooleanValue(n <= 0);
            }
        }
        return RelationalOperator.getBooleanValue(false);
    }
}

