/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.spel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.jsptl.lang.spel.BeanInfoManager;
import org.apache.taglibs.jsptl.lang.spel.BeanInfoProperty;
import org.apache.taglibs.jsptl.lang.spel.Constants;
import org.apache.taglibs.jsptl.lang.spel.Expression;
import org.apache.taglibs.jsptl.lang.spel.SpelExpressionException;
import org.apache.taglibs.jsptl.lang.spel.StringLiteral;

public class PropertyExpression
extends Expression {
    static Object[] sNoArgs = new Object[0];
    Expression mBase;
    String[] mPropertyNames;

    public Expression getBase() {
        return this.mBase;
    }

    public String[] getPropertyNames() {
        return this.mPropertyNames;
    }

    public PropertyExpression(Expression expression, String[] stringArray) {
        this.mBase = expression;
        this.mPropertyNames = stringArray;
    }

    public String getExpressionString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mBase.getExpressionString());
        for (int i = 0; i < this.mPropertyNames.length; ++i) {
            stringBuffer.append('.');
            stringBuffer.append(StringLiteral.toIdentifierToken(this.mPropertyNames[i]));
        }
        return stringBuffer.toString();
    }

    public Object evaluate(PageContext pageContext) throws JspException {
        Object object;
        Object object2 = object = this.mBase.evaluate(pageContext);
        for (int i = 0; i < this.mPropertyNames.length; ++i) {
            String string = this.mPropertyNames[i];
            if (object2 == null) {
                throw new SpelExpressionException(Constants.CANT_GET_PROPERTY_OF_NULL, string);
            }
            BeanInfoProperty beanInfoProperty = BeanInfoManager.getBeanInfoProperty(object2.getClass(), string);
            if (beanInfoProperty == null) {
                throw new SpelExpressionException(Constants.NO_SUCH_PROPERTY, object2.getClass().getName(), (Object)string);
            }
            Method method = beanInfoProperty.getReadMethod();
            if (method == null) {
                throw new SpelExpressionException(Constants.NO_GETTER_METHOD, string, (Object)object2.getClass().getName());
            }
            try {
                object2 = method.invoke(object2, sNoArgs);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SpelExpressionException(Constants.ERROR_GETTING_PROPERTY, string, (Object)object2.getClass().getName(), (Object)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SpelExpressionException(Constants.ERROR_GETTING_PROPERTY, string, (Object)object2.getClass().getName(), (Object)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SpelExpressionException(Constants.ERROR_GETTING_PROPERTY, string, (Object)object2.getClass().getName(), (Object)invocationTargetException.getTargetException());
            }
        }
        return object2;
    }
}

