/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.spel;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.jsptl.lang.spel.Constants;
import org.apache.taglibs.jsptl.lang.spel.Expression;
import org.apache.taglibs.jsptl.lang.spel.ParsedExpression;
import org.apache.taglibs.jsptl.lang.spel.SpelException;
import org.apache.taglibs.jsptl.lang.spel.parser.ParseException;
import org.apache.taglibs.jsptl.lang.spel.parser.SpelParser;
import org.apache.taglibs.jsptl.lang.spel.parser.TokenMgrError;
import org.apache.taglibs.jsptl.lang.support.ExpressionEvaluator;

public class Evaluator
implements ExpressionEvaluator {
    static Map mCachedExpressions = Collections.synchronizedMap(new HashMap());
    static Map mCachedExpectedTypes = new HashMap();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public Object evaluate(String string, PageContext pageContext, Class clazz) throws JspException {
        if (string == null) {
            throw new SpelException(Constants.NULL_EXPRESSION);
        }
        if (string.startsWith("$")) {
            return this.evaluateExpression(string, pageContext, clazz);
        }
        return this.evaluateLiteral(string, pageContext, clazz);
    }

    Object evaluateExpression(String string, PageContext pageContext, Class clazz) throws JspException {
        ParsedExpression parsedExpression = Evaluator.getOrParseExpression(string);
        return parsedExpression.evaluate(pageContext, clazz);
    }

    public static ParsedExpression getOrParseExpression(String string) throws JspException {
        ParsedExpression parsedExpression = (ParsedExpression)mCachedExpressions.get(string);
        if (parsedExpression == null) {
            StringReader stringReader = new StringReader(string);
            try {
                ((Reader)stringReader).read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            SpelParser spelParser = new SpelParser(stringReader);
            try {
                Expression expression = spelParser.Expression();
                parsedExpression = new ParsedExpression(string, expression);
                mCachedExpressions.put(string, parsedExpression);
            }
            catch (ParseException parseException) {
                throw new SpelException(Constants.PARSE_EXCEPTION, parseException);
            }
            catch (TokenMgrError tokenMgrError) {
                throw new SpelException(Constants.PARSE_EXCEPTION, tokenMgrError);
            }
        }
        return parsedExpression;
    }

    Object evaluateLiteral(String string, PageContext pageContext, Class clazz) throws JspException {
        if (clazz == null) {
            return string;
        }
        Map map = Evaluator.getOrCreateExpectedTypeMap(clazz);
        if (map.containsKey(string)) {
            return map.get(string);
        }
        String string2 = string;
        if (string2.startsWith("\\$")) {
            string2 = string2.substring(1);
        }
        Object object = clazz == (class$java$lang$String == null ? (class$java$lang$String = Evaluator.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$Object == null ? (class$java$lang$Object = Evaluator.class$("java.lang.Object")) : class$java$lang$Object) ? string2 : this.parseToExpectedType(string, clazz);
        map.put(string2, object);
        return object;
    }

    Object parseToExpectedType(String string, Class clazz) throws JspException {
        if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Evaluator.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.valueOf(string);
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Evaluator.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.valueOf(string);
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Evaluator.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.valueOf(string);
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Evaluator.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.valueOf(string);
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Evaluator.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.valueOf(string);
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Evaluator.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.valueOf(string);
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Evaluator.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.valueOf(string);
        }
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
        if (propertyEditor == null) {
            throw new SpelException(Constants.NO_PROPERTY_EDITOR, string, (Object)clazz.getName());
        }
        try {
            propertyEditor.setAsText(string);
            return propertyEditor.getValue();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SpelException(Constants.CANT_PARSE_LITERAL, string, (Object)clazz.getName(), (Object)illegalArgumentException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getOrCreateExpectedTypeMap(Class clazz) {
        Map map = mCachedExpectedTypes;
        synchronized (map) {
            Map map2 = (Map)mCachedExpectedTypes.get(clazz);
            if (map2 == null) {
                map2 = Collections.synchronizedMap(new HashMap());
                mCachedExpectedTypes.put(clazz, map2);
            }
            return map2;
        }
    }

    public String validate(String string, String string2) {
        if (string2.startsWith("$")) {
            try {
                Evaluator.getOrParseExpression(string2);
                return null;
            }
            catch (JspException jspException) {
                return jspException.toString();
            }
        }
        return null;
    }

    public Object evaluate(String string, String string2, Class clazz, Tag tag, PageContext pageContext) throws JspException {
        return this.evaluate(string2, pageContext, clazz);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

