/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.spel;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.apache.taglibs.jsptl.lang.spel.BeanInfoProperty;
import org.apache.taglibs.jsptl.lang.spel.Constants;
import org.apache.taglibs.jsptl.lang.spel.SpelException;

public class BeanInfoManager {
    Class mBeanClass;
    BeanInfo mBeanInfo;
    Map mPropertyByName;
    Map mEventSetByName;
    boolean mInitialized;
    static Map mBeanInfoManagerByClass = new HashMap();

    public Class getBeanClass() {
        return this.mBeanClass;
    }

    BeanInfoManager(Class clazz) {
        this.mBeanClass = clazz;
    }

    public static BeanInfoManager getBeanInfoManager(Class clazz) {
        BeanInfoManager beanInfoManager = (BeanInfoManager)mBeanInfoManagerByClass.get(clazz);
        if (beanInfoManager == null) {
            beanInfoManager = BeanInfoManager.createBeanInfoManager(clazz);
        }
        return beanInfoManager;
    }

    static synchronized BeanInfoManager createBeanInfoManager(Class clazz) {
        BeanInfoManager beanInfoManager = (BeanInfoManager)mBeanInfoManagerByClass.get(clazz);
        if (beanInfoManager == null) {
            beanInfoManager = new BeanInfoManager(clazz);
            mBeanInfoManagerByClass.put(clazz, beanInfoManager);
        }
        return beanInfoManager;
    }

    public static BeanInfoProperty getBeanInfoProperty(Class clazz, String string) throws JspException {
        return BeanInfoManager.getBeanInfoManager(clazz).getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInitialized() throws JspException {
        if (!this.mInitialized) {
            BeanInfoManager beanInfoManager = this;
            synchronized (beanInfoManager) {
                if (!this.mInitialized) {
                    this.initialize();
                    this.mInitialized = true;
                }
            }
        }
    }

    void initialize() throws JspException {
        try {
            Object object;
            this.mBeanInfo = Introspector.getBeanInfo(this.mBeanClass);
            this.mPropertyByName = new HashMap();
            PropertyDescriptor[] propertyDescriptorArray = this.mBeanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                object = BeanInfoManager.getPublicMethod(propertyDescriptor.getReadMethod());
                Method method = BeanInfoManager.getPublicMethod(propertyDescriptor.getWriteMethod());
                BeanInfoProperty beanInfoProperty = new BeanInfoProperty((Method)object, method, propertyDescriptor);
                this.mPropertyByName.put(propertyDescriptor.getName(), beanInfoProperty);
            }
            this.mEventSetByName = new HashMap();
            EventSetDescriptor[] eventSetDescriptorArray = this.mBeanInfo.getEventSetDescriptors();
            for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
                object = eventSetDescriptorArray[i];
                this.mEventSetByName.put(((FeatureDescriptor)object).getName(), object);
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new SpelException(Constants.EXCEPTION_GETTING_BEANINFO, this.mBeanClass.getName(), (Object)introspectionException);
        }
    }

    BeanInfo getBeanInfo() throws JspException {
        this.checkInitialized();
        return this.mBeanInfo;
    }

    public BeanInfoProperty getProperty(String string) throws JspException {
        this.checkInitialized();
        return (BeanInfoProperty)this.mPropertyByName.get(string);
    }

    public EventSetDescriptor getEventSet(String string) throws JspException {
        this.checkInitialized();
        return (EventSetDescriptor)this.mEventSetByName.get(string);
    }

    static Method getPublicMethod(Method method) {
        if (method == null) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        Method method2 = BeanInfoManager.getPublicMethod(clazz, method);
        if (method2 != null) {
            return method2;
        }
        return method;
    }

    static Method getPublicMethod(Class clazz, Method method) {
        Method method2;
        Object object;
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                object = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                if (Modifier.isPublic(((Method)object).getModifiers())) {
                    return object;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if ((object = clazz.getInterfaces()) != null) {
            for (int i = 0; i < ((Object)object).length; ++i) {
                Method method3 = BeanInfoManager.getPublicMethod((Class)object[i], method);
                if (method3 == null) continue;
                return method3;
            }
        }
        if ((object = clazz.getSuperclass()) != null && (method2 = BeanInfoManager.getPublicMethod((Class)object, method)) != null) {
            return method2;
        }
        return null;
    }
}

