/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.jpath.expression;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.jsptl.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.jsptl.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.jsptl.lang.jpath.expression.Identifier;
import org.apache.taglibs.jsptl.lang.jpath.expression.Introspectable;
import org.apache.taglibs.jsptl.lang.jpath.expression.Parser;
import org.apache.taglibs.jsptl.lang.jpath.expression.SimpleNode;

public class MethodCall
extends SimpleNode
implements Introspectable {
    public MethodCall(int n) {
        super(n);
    }

    public MethodCall(Parser parser, int n) {
        super(parser, n);
    }

    public Object evaluate(PageContext pageContext, IterationContext iterationContext, int n) throws EvaluationException {
        throw new EvaluationException(this, "A MethodCall must be called on another object");
    }

    public Object evaluate(PageContext pageContext, IterationContext iterationContext, Object object) throws EvaluationException {
        Object object2 = null;
        String string = ((Identifier)this.jjtGetChild((int)0)).val;
        if (object != null) {
            try {
                MethodDescriptor methodDescriptor = this.getFeatureDescriptor(object.getClass(), string);
                Object[] objectArray = new Object[this.jjtGetNumChildren() - 1];
                for (int i = 1; i < this.jjtGetNumChildren(); ++i) {
                    objectArray[i - 1] = this.jjtGetChild(i).evaluate(pageContext, iterationContext);
                }
                if (methodDescriptor != null) {
                    object2 = this.tempGetAttribute(object, string, objectArray);
                }
            }
            catch (IntrospectionException introspectionException) {
                throw new EvaluationException(this, "Introspection Exception:" + introspectionException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new EvaluationException(this, "NoSuchMethodException:" + noSuchMethodException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new EvaluationException(this, "IllegalAccessException:" + illegalAccessException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new EvaluationException(this, "InvocationTargetException:" + invocationTargetException.getMessage());
            }
        }
        return object2;
    }

    private MethodDescriptor getFeatureDescriptor(Class clazz, String string) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        MethodDescriptor[] methodDescriptorArray = beanInfo.getMethodDescriptors();
        for (int i = methodDescriptorArray.length - 1; i >= 0; --i) {
            MethodDescriptor methodDescriptor = methodDescriptorArray[i];
            if (!methodDescriptor.getName().equals(string)) continue;
            return methodDescriptor;
        }
        return null;
    }

    private Object getAttribute(MethodDescriptor methodDescriptor, Object object, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object object2 = null;
        Method method = methodDescriptor.getMethod();
        object2 = method.invoke(object, objectArray);
        return object2;
    }

    private Object tempGetAttribute(Object object, String string, Object[] objectArray) throws IntrospectionException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getMethods();
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            method = methodArray[i];
        }
        method = this.getPublicMethod(clazz, method.getName(), method.getParameterTypes());
        Object object2 = method.invoke(object, objectArray);
        return object2;
    }

    private Method getPublicMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        Method method = null;
        if ((clazz.getModifiers() & 1) == 0) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                try {
                    method = this.getPublicMethod(clazz2, string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (method == null) {
                Class<?>[] classArray2 = clazz.getInterfaces();
                for (int i = 0; i < classArray2.length; ++i) {
                    try {
                        method = this.getPublicMethod(classArray2[i], string, classArray);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
        } else {
            method = clazz.getMethod(string, classArray);
        }
        return method;
    }
}

