/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.jpath.expression;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.jsptl.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.jsptl.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.jsptl.lang.jpath.expression.Introspectable;
import org.apache.taglibs.jsptl.lang.jpath.expression.Parser;
import org.apache.taglibs.jsptl.lang.jpath.expression.SimpleNode;

public class Identifier
extends SimpleNode
implements Introspectable {
    protected String val;

    public Identifier(int n) {
        super(n);
    }

    public Identifier(Parser parser, int n) {
        super(parser, n);
    }

    public String toNormalizedString() {
        return this.val;
    }

    public Object evaluate(PageContext pageContext, IterationContext iterationContext) throws EvaluationException {
        Object object = pageContext.findAttribute(this.val);
        return object;
    }

    public Object evaluate(PageContext pageContext, IterationContext iterationContext, int n) throws EvaluationException {
        Object object = pageContext.getAttribute(this.val, n);
        return object;
    }

    public Object evaluate(PageContext pageContext, IterationContext iterationContext, Object object) throws EvaluationException {
        Object object2 = null;
        if (object != null) {
            try {
                PropertyDescriptor propertyDescriptor = this.getFeatureDescriptor(object.getClass(), this.val);
                if (propertyDescriptor != null) {
                    object2 = this.getAttribute(propertyDescriptor, object);
                }
            }
            catch (IntrospectionException introspectionException) {
                throw new EvaluationException(this, "Introspection Exception:" + introspectionException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new EvaluationException(this, "NoSuchMethodException:" + noSuchMethodException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new EvaluationException(this, "IllegalAccessException:" + illegalAccessException.toString());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new EvaluationException(this, "InvocationTargetException:" + invocationTargetException.getMessage());
            }
        }
        return object2;
    }

    private PropertyDescriptor getFeatureDescriptor(Class clazz, String string) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = propertyDescriptorArray.length - 1; i >= 0; --i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (!propertyDescriptor.getName().equals(string)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    private Object getAttribute(PropertyDescriptor propertyDescriptor, Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object object2 = null;
        Method method = propertyDescriptor.getReadMethod();
        method = this.getPublicMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
        object2 = method.invoke(object, null);
        return object2;
    }

    private Method getPublicMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        Method method = null;
        if ((clazz.getModifiers() & 1) == 0) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                try {
                    method = this.getPublicMethod(clazz2, string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (method == null) {
                Class<?>[] classArray2 = clazz.getInterfaces();
                for (int i = 0; i < classArray2.length; ++i) {
                    try {
                        method = this.getPublicMethod(classArray2[i], string, classArray);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
        } else {
            method = clazz.getMethod(string, classArray);
        }
        return method;
    }
}

