/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.jpath.expression;

import javax.servlet.jsp.PageContext;
import org.apache.taglibs.jsptl.lang.jpath.adapter.ConversionException;
import org.apache.taglibs.jsptl.lang.jpath.adapter.Convert;
import org.apache.taglibs.jsptl.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.jsptl.lang.jpath.adapter.JSPDate;
import org.apache.taglibs.jsptl.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.jsptl.lang.jpath.expression.Parser;
import org.apache.taglibs.jsptl.lang.jpath.expression.SimpleNode;

public class AddDateFunction
extends SimpleNode {
    public AddDateFunction(int n) {
        super(n);
    }

    public AddDateFunction(Parser parser, int n) {
        super(parser, n);
    }

    public String toNormalizedString() {
        boolean bl = true;
        String string = "date-add(";
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!bl) {
                    string = string + ",";
                }
                bl = false;
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                string = string + simpleNode.toNormalizedString();
            }
        }
        string = string + ")";
        return string;
    }

    public Object evaluate(PageContext pageContext, IterationContext iterationContext) throws EvaluationException {
        JSPDate jSPDate;
        try {
            jSPDate = Convert.toJSPDate(this.jjtGetChild(0).evaluate(pageContext, iterationContext));
            String string = Convert.toString(this.jjtGetChild(1).evaluate(pageContext, iterationContext));
            int n = Convert.toDouble(this.jjtGetChild(2).evaluate(pageContext, iterationContext)).intValue();
            int n2 = this.getCalendarConstant(string);
            jSPDate.add(n2, n);
        }
        catch (ConversionException conversionException) {
            throw new EvaluationException(this, conversionException.getMessage());
        }
        return jSPDate;
    }

    private int getCalendarConstant(String string) throws EvaluationException {
        int n;
        if (string.equals("era")) {
            n = 0;
        } else if (string.equals("year")) {
            n = 1;
        } else if (string.equals("month")) {
            n = 2;
        } else if (string.equals("weekOfYear")) {
            n = 3;
        } else if (string.equals("date")) {
            n = 5;
        } else if (string.equals("dayOfMonth")) {
            n = 5;
        } else if (string.equals("dayOfYear")) {
            n = 6;
        } else if (string.equals("dayOfWeek")) {
            n = 7;
        } else if (string.equals("dayOfWeekInMonth")) {
            n = 8;
        } else if (string.equals("amPm")) {
            n = 9;
        } else if (string.equals("hour")) {
            n = 10;
        } else if (string.equals("hourOfDay")) {
            n = 11;
        } else if (string.equals("minute")) {
            n = 12;
        } else if (string.equals("second")) {
            n = 13;
        } else if (string.equals("millisecond")) {
            n = 14;
        } else {
            throw new EvaluationException(this, "An invalid date field was supplied");
        }
        return n;
    }
}

