/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.jsptl.lang.jpath.adapter;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.taglibs.jsptl.lang.jpath.adapter.CollectionAdapter;
import org.apache.taglibs.jsptl.lang.jpath.adapter.ConversionException;
import org.apache.taglibs.jsptl.lang.jpath.adapter.GregorianCalendarAdapter;
import org.apache.taglibs.jsptl.lang.jpath.adapter.JSPDate;
import org.apache.taglibs.jsptl.lang.jpath.adapter.JSPList;

public class Convert {
    public static Double toDouble(Object object) throws ConversionException {
        Double d = (object = Convert.performBasicConversions(object)) == null ? new Double(Double.NaN) : (object instanceof Boolean ? Convert.toDouble((Boolean)object) : (object instanceof Double ? Convert.toDouble((Double)object) : (object instanceof String ? Convert.toDouble((String)object) : (object instanceof JSPDate ? Convert.toDouble((JSPDate)object) : (object instanceof JSPList ? Convert.toDouble((JSPList)object) : Convert.toDouble(Convert.toString(object)))))));
        return d;
    }

    private static Double toDouble(Boolean bl) throws ConversionException {
        Double d = bl == true ? new Double(1.0) : new Double(0.0);
        return d;
    }

    private static Double toDouble(Double d) throws ConversionException {
        return d;
    }

    private static Double toDouble(String string) throws ConversionException {
        Double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = new Double(Double.NaN);
        }
        return d;
    }

    private static Double toDouble(JSPDate jSPDate) throws ConversionException {
        Double d = jSPDate.getTime();
        return d;
    }

    private static Double toDouble(JSPList jSPList) throws ConversionException {
        Double d = Convert.toDouble(Convert.toString(jSPList));
        return d;
    }

    public static Boolean toBoolean(Object object) throws ConversionException {
        Boolean bl = (object = Convert.performBasicConversions(object)) == null ? new Boolean(false) : (object instanceof Boolean ? Convert.toBoolean((Boolean)object) : (object instanceof Double ? Convert.toBoolean((Double)object) : (object instanceof String ? Convert.toBoolean((String)object) : (object instanceof JSPDate ? Convert.toBoolean((JSPDate)object) : (object instanceof JSPList ? Convert.toBoolean((JSPList)object) : Convert.toBoolean(Convert.toString(object)))))));
        return bl;
    }

    private static Boolean toBoolean(Boolean bl) throws ConversionException {
        return bl;
    }

    private static Boolean toBoolean(Double d) throws ConversionException {
        Boolean bl = d == null ? new Boolean(false) : (!d.isNaN() && d != 0.0 && d != 0.0 ? new Boolean(true) : new Boolean(false));
        return bl;
    }

    private static Boolean toBoolean(String string) throws ConversionException {
        Boolean bl = string == null ? new Boolean(false) : (string.length() != 0 ? new Boolean(true) : new Boolean(false));
        return bl;
    }

    private static Boolean toBoolean(JSPDate jSPDate) throws ConversionException {
        Boolean bl = Convert.toBoolean(Convert.toString(jSPDate));
        return bl;
    }

    private static Boolean toBoolean(JSPList jSPList) throws ConversionException {
        Boolean bl;
        if (jSPList == null || !jSPList.hasNext()) {
            bl = new Boolean(false);
        } else {
            if (jSPList.getPosition() != 0) {
                throw new ConversionException("cannot convert a list to a Boolean if the list is not at the starting position");
            }
            bl = new Boolean(true);
        }
        return bl;
    }

    public static String toString(Object object) throws ConversionException {
        String string = (object = Convert.performBasicConversions(object)) == null ? new String("") : (object instanceof Boolean ? Convert.toString((Boolean)object) : (object instanceof Double ? Convert.toString((Double)object) : (object instanceof String ? Convert.toString((String)object) : (object instanceof JSPDate ? Convert.toString((JSPDate)object) : (object instanceof JSPList ? Convert.toString((JSPList)object) : object.toString())))));
        return string;
    }

    private static String toString(Boolean bl) throws ConversionException {
        return bl.toString();
    }

    private static String toString(Double d) throws ConversionException {
        String string;
        if (d == null || d.isNaN()) {
            string = new String("NaN");
        } else if (d == 0.0 || d == 0.0) {
            string = new String("0");
        } else if (d == Double.POSITIVE_INFINITY) {
            string = new String("Infinity");
        } else if (d == Double.NEGATIVE_INFINITY) {
            string = new String("-Infinity");
        } else if (Math.floor(d) == d) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            try {
                ((DecimalFormat)numberFormat).applyPattern("#");
                string = numberFormat.format(d);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = new String("NaN");
            }
        } else {
            string = d.toString();
        }
        return string;
    }

    private static String toString(String string) throws ConversionException {
        return string;
    }

    private static String toString(JSPDate jSPDate) throws ConversionException {
        String string = DateFormat.getDateInstance().format(new Date(jSPDate.getTime().longValue()));
        return string;
    }

    private static String toString(JSPList jSPList) throws ConversionException {
        String string;
        if (jSPList == null || !jSPList.hasNext()) {
            string = "";
        } else {
            if (jSPList.getPosition() != 0) {
                throw new ConversionException("cannot convert a list to a String if the list is not at the starting position");
            }
            string = Convert.toString(jSPList.next());
        }
        return string;
    }

    public static JSPDate toJSPDate(Object object) throws ConversionException {
        if ((object = Convert.performBasicConversions(object)) == null) {
            throw new ConversionException("cannot convert null to a JSPDate");
        }
        if (!(object instanceof JSPDate)) {
            throw new ConversionException("Object [" + object + "] cannot be " + "converted to a JSPList");
        }
        JSPDate jSPDate = Convert.toJSPDate((JSPDate)object);
        return jSPDate;
    }

    private static JSPDate toJSPDate(JSPDate jSPDate) throws ConversionException {
        return jSPDate;
    }

    private static JSPDate toJSPDate(GregorianCalendar gregorianCalendar) throws ConversionException {
        return (JSPDate)GregorianCalendarAdapter.adapt(gregorianCalendar);
    }

    public static JSPList toJSPList(Object object) throws ConversionException {
        if ((object = Convert.performBasicConversions(object)) == null) {
            throw new ConversionException("cannot convert null to a JSPList");
        }
        if (!(object instanceof JSPList)) {
            throw new ConversionException("Object [" + object + "] cannot be " + "converted to a JSPList");
        }
        JSPList jSPList = Convert.toJSPList((JSPList)object);
        return jSPList;
    }

    private static JSPList toJSPList(JSPList jSPList) throws ConversionException {
        return jSPList;
    }

    private static Object performBasicConversions(Object object) {
        Object object2 = object == null ? null : (object instanceof Short ? new Double(((Short)object).toString()) : (object instanceof Integer ? new Double(((Integer)object).toString()) : (object instanceof Float ? new Double(((Float)object).toString()) : (object instanceof Long ? new Double(((Long)object).toString()) : (object instanceof Byte ? new String(((Byte)object).toString()) : (object instanceof Character ? new String(((Character)object).toString()) : object))))));
        object2 = Convert.toJSPType(object2);
        return object2;
    }

    public static Object toJSPType(Object object) {
        Object object2 = object == null ? null : (object instanceof Collection ? CollectionAdapter.adapt(object) : (object instanceof GregorianCalendar ? GregorianCalendarAdapter.adapt(object) : object));
        return object2;
    }
}

