/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.grammar;

import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.BinaryExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.UnaryExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.util.StringPair;
import java.io.Serializable;
import org.relaxng.datatype.Datatype;

public class ExpressionPool
implements Serializable {
    private final ClosedHash expTable;
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$com$sun$msv$grammar$ChoiceExp;
    static /* synthetic */ Class class$com$sun$msv$grammar$SequenceExp;

    public ExpressionPool() {
        this.expTable = new ClosedHash();
    }

    public final Expression createAnyString() {
        return Expression.anyString;
    }

    public final Expression createEpsilon() {
        return Expression.epsilon;
    }

    public final Expression createNullSet() {
        return Expression.nullSet;
    }

    public ExpressionPool(ExpressionPool parent) {
        this.expTable = new ClosedHash(parent.expTable);
    }

    public final Expression createData(XSDatatype dt) {
        String ns = dt.getNamespaceUri();
        if (ns == null) {
            ns = "\u0000";
        }
        return this.createData((Datatype)dt, new StringPair(ns, dt.displayName()));
    }

    public final Expression createList(Expression exp) {
        if (exp == Expression.nullSet) {
            return exp;
        }
        return this.unify(new ListExp(exp));
    }

    public final Expression createMixed(Expression body) {
        if (body == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (body == Expression.epsilon) {
            return Expression.anyString;
        }
        return this.unify(new MixedExp(body));
    }

    public final Expression createOneOrMore(Expression child) {
        if (child == Expression.epsilon || child == Expression.anyString || child == Expression.nullSet || child instanceof OneOrMoreExp) {
            return child;
        }
        return this.unify(new OneOrMoreExp(child));
    }

    public final Expression createOptional(Expression child) {
        return this.createChoice(child, Expression.epsilon);
    }

    public final Expression createZeroOrMore(Expression child) {
        return this.createOptional(this.createOneOrMore(child));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Expression unify(Expression exp) {
        Expression o = this.expTable.get(exp);
        if (o == null) {
            ClosedHash closedHash = this.expTable;
            synchronized (closedHash) {
                o = this.expTable.get(exp);
                if (o == null) {
                    this.expTable.put(exp);
                    return exp;
                }
            }
        }
        return o;
    }

    public final Expression createAttribute(NameClass nameClass) {
        return this.unify(new AttributeExp(nameClass, Expression.anyString));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final Expression createChoice(Expression left, Expression right) {
        if (left == Expression.nullSet) {
            return right;
        }
        if (right == Expression.nullSet) {
            return left;
        }
        if (left == Expression.epsilon && right.isEpsilonReducible()) {
            return right;
        }
        if (right == Expression.epsilon && left.isEpsilonReducible()) {
            return left;
        }
        if (right instanceof ChoiceExp) {
            ChoiceExp c = (ChoiceExp)right;
            return this.createChoice(this.createChoice(left, c.exp1), c.exp2);
        }
        Expression next = left;
        while (true) {
            if (next == right) {
                return left;
            }
            if (!(next instanceof ChoiceExp)) break;
            ChoiceExp cp = (ChoiceExp)next;
            if (cp.exp2 == right) {
                return left;
            }
            next = cp.exp1;
        }
        Expression o = this.expTable.get(Expression.hashCode(left, right, 2), left, right, class$com$sun$msv$grammar$ChoiceExp == null ? (class$com$sun$msv$grammar$ChoiceExp = ExpressionPool.class$("com.sun.msv.grammar.ChoiceExp")) : class$com$sun$msv$grammar$ChoiceExp);
        if (o == null) {
            return this.unify(new ChoiceExp(left, right));
        }
        return o;
    }

    public final Expression createConcur(Expression left, Expression right) {
        if (left == Expression.nullSet || right == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (left == Expression.epsilon) {
            if (right.isEpsilonReducible()) {
                return Expression.epsilon;
            }
            return Expression.nullSet;
        }
        if (right == Expression.epsilon) {
            if (left.isEpsilonReducible()) {
                return Expression.epsilon;
            }
            return Expression.nullSet;
        }
        if (right instanceof ConcurExp) {
            ConcurExp c = (ConcurExp)right;
            return this.createConcur(this.createConcur(left, c.exp1), c.exp2);
        }
        return this.unify(new ConcurExp(left, right));
    }

    public final Expression createInterleave(Expression left, Expression right) {
        if (left == Expression.epsilon) {
            return right;
        }
        if (right == Expression.epsilon) {
            return left;
        }
        if (left == Expression.nullSet || right == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (right instanceof InterleaveExp) {
            InterleaveExp i = (InterleaveExp)right;
            return this.createInterleave(this.createInterleave(left, i.exp1), i.exp2);
        }
        return this.unify(new InterleaveExp(left, right));
    }

    public final Expression createSequence(Expression left, Expression right) {
        if (left == Expression.nullSet || right == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (left == Expression.epsilon) {
            return right;
        }
        if (right == Expression.epsilon) {
            return left;
        }
        if (right instanceof SequenceExp) {
            SequenceExp s = (SequenceExp)right;
            return this.createSequence(this.createSequence(left, s.exp1), s.exp2);
        }
        Expression o = this.expTable.get(Expression.hashCode(left, right, 5), left, right, class$com$sun$msv$grammar$SequenceExp == null ? (class$com$sun$msv$grammar$SequenceExp = ExpressionPool.class$("com.sun.msv.grammar.SequenceExp")) : class$com$sun$msv$grammar$SequenceExp);
        if (o == null) {
            return this.unify(new SequenceExp(left, right));
        }
        return o;
    }

    public final Expression createAttribute(NameClass nameClass, Expression content) {
        if (content == Expression.nullSet) {
            return content;
        }
        return this.unify(new AttributeExp(nameClass, content));
    }

    public final Expression createData(Datatype dt, StringPair typeName) {
        return this.createData(dt, typeName, Expression.nullSet);
    }

    public final Expression createValue(XSDatatype dt, Object value) {
        return this.createValue((Datatype)dt, new StringPair("", dt.displayName()), value);
    }

    public final Expression createData(Datatype dt, StringPair typeName, Expression except) {
        return this.unify(new DataExp(dt, typeName, except));
    }

    public final Expression createValue(Datatype dt, StringPair typeName, Object value) {
        return this.unify(new ValueExp(dt, typeName, value));
    }

    public static final class ClosedHash
    implements Serializable {
        private Expression[] table = new Expression[191];
        private int count;
        private int threshold = 57;
        private static final float loadFactor = 0.3f;
        private static final int initialCapacity = 191;
        private final ClosedHash parent;
        private static final long serialVersionUID = -2924295970572669668L;

        public ClosedHash() {
            this(null);
        }

        private void rehash() {
            int oldCapacity = this.table.length;
            Expression[] oldMap = this.table;
            int newCapacity = oldCapacity * 2 + 1;
            Expression[] newMap = new Expression[newCapacity];
            int i = oldCapacity;
            while (i-- > 0) {
                if (oldMap[i] == null) continue;
                int index = (oldMap[i].hashCode() & Integer.MAX_VALUE) % newMap.length;
                while (newMap[index] != null) {
                    index = (index + 1) % newMap.length;
                }
                newMap[index] = oldMap[i];
            }
            this.threshold = (int)((float)newCapacity * 0.3f);
            this.table = newMap;
        }

        public void put(Expression newExp) {
            if (this.count >= this.threshold) {
                this.rehash();
            }
            Expression[] tab = this.table;
            int index = (newExp.hashCode() & Integer.MAX_VALUE) % tab.length;
            while (tab[index] != null) {
                index = (index + 1) % tab.length;
            }
            tab[index] = newExp;
            ++this.count;
        }

        public ClosedHash(ClosedHash parent) {
            this.parent = parent;
        }

        public Expression get(Expression key) {
            Expression e;
            if (this.parent != null && (e = this.parent.get(key)) != null) {
                return e;
            }
            Expression[] tab = this.table;
            int index = (key.hashCode() & Integer.MAX_VALUE) % tab.length;
            Expression e2;
            while ((e2 = tab[index]) != null) {
                if (e2.equals(key)) {
                    return e2;
                }
                index = (index + 1) % tab.length;
            }
            return null;
        }

        public Expression get(int hash, Expression child, Class type) {
            Expression e;
            if (this.parent != null && (e = this.parent.get(hash, child, type)) != null) {
                return e;
            }
            Expression[] tab = this.table;
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Expression e2;
            while ((e2 = tab[index]) != null) {
                if (e2.hashCode() == hash && e2.getClass() == type) {
                    UnaryExp ue = (UnaryExp)e2;
                    if (ue.exp == child) {
                        return ue;
                    }
                }
                index = (index + 1) % tab.length;
            }
            return null;
        }

        public Expression get(int hash, Expression left, Expression right, Class type) {
            Expression e;
            if (this.parent != null && (e = this.parent.get(hash, left, right, type)) != null) {
                return e;
            }
            Expression[] tab = this.table;
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Expression e2;
            while ((e2 = tab[index]) != null) {
                if (e2.hashCode() == hash && e2.getClass() == type) {
                    BinaryExp be = (BinaryExp)e2;
                    if (be.exp1 == left && be.exp2 == right) {
                        return be;
                    }
                }
                index = (index + 1) % tab.length;
            }
            return null;
        }
    }
}

