/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.discussions.providers;

import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Comments {
    private SOIFInputStream commentstream;
    private ArrayList unclusteredComments = new ArrayList();
    private ArrayList comments = new ArrayList();
    private String rooturl;
    private String discussionID;
    private SOIF rootSOIF;
    private boolean sortByDate = true;
    private String server;

    public SOIFInputStream getCommentstream() {
        return this.commentstream;
    }

    public void clusterComments(SOIFInputStream s) {
    }

    public void clusterComments(SOIFInputStream s, String rooturl) throws Exception {
        this.commentstream = s;
        this.rooturl = rooturl;
        ArrayList<SOIF> v = new ArrayList<SOIF>();
        try {
            SOIF soif = this.commentstream.readSOIF();
            while (soif != null) {
                v.add(soif);
                soif = this.commentstream.readSOIF();
            }
        }
        catch (IOException ie) {
            // empty catch block
        }
        this.unclusteredComments = v;
        if (v != null && !v.isEmpty()) {
            int indx = this.findRoot(v, rooturl);
            if (indx < 0) {
                throw new Exception("Cannot find ROOT");
            }
            this.rootSOIF = (SOIF)v.get(indx);
            v.remove(indx);
            this.cluster(v, rooturl);
        }
    }

    public int findRoot(List l, String url) {
        for (int i = 0; i < l.size(); ++i) {
            SOIF comment = (SOIF)l.get(i);
            if (!comment.getURL().equals(url)) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cluster(List v, String parenturl) {
        for (int i = 0; i < v.size(); ++i) {
            List newlist;
            SOIF comment = (SOIF)v.get(i);
            if (!this.getParentID(comment).equals(parenturl)) continue;
            this.comments.add(v.get(i));
            String newurl = comment.getURL();
            if (this.sortByDate) {
                if (i + 1 >= v.size()) return;
                newlist = v.subList(i + 1, v.size());
            } else {
                v.remove(i);
                newlist = v;
            }
            this.cluster(newlist, newurl);
        }
    }

    public List getComments(String url) {
        return this.comments;
    }

    public List getComments() {
        return this.comments;
    }

    public String getDiscussionID() throws Exception {
        StringTokenizer st;
        String ref_id;
        if (this.rootSOIF != null && (ref_id = this.rootSOIF.getValue("rd-reference-id")) != null && (st = new StringTokenizer(ref_id, " ")).countTokens() >= 2) {
            String tok = st.nextToken();
            this.discussionID = tok.equals("ROOT") ? st.nextToken() : tok;
        }
        if (this.discussionID == null) {
            throw new Exception("Cannot get discussionID");
        }
        return this.discussionID;
    }

    public SOIF getRootSOIF() throws Exception {
        if (this.rootSOIF == null) {
            throw new Exception("No Comment Root found");
        }
        return this.rootSOIF;
    }

    public int findRootSOIFDepth() {
        if (this.rootSOIF != null) {
            return this.findDepth(this.rootSOIF);
        }
        return -1;
    }

    public int findDepth(SOIF comment) {
        String ref_id = comment.getValue("rd-reference-id");
        if (ref_id != null) {
            if (ref_id.startsWith("ROOT ")) {
                return 1;
            }
            StringTokenizer st = new StringTokenizer(ref_id, " ");
            int d = st.countTokens();
            return d;
        }
        return 0;
    }

    public String getParentID(SOIF comment) {
        String parentId = "";
        int i = -1;
        int j = -1;
        String url = comment.getURL();
        String reference_id = comment.getValue("rd-reference-id");
        if (reference_id == null) {
            return parentId;
        }
        i = reference_id.indexOf(url);
        if (i >= 0) {
            String t = reference_id;
            if (i - 1 > 0) {
                t = reference_id.substring(0, i - 1);
            }
            parentId = (j = t.lastIndexOf(" ")) >= 0 && j + 1 < t.length() ? t.substring(j + 1) : t;
        }
        return parentId;
    }

    public boolean hasComments() {
        return this.comments.size() > 1;
    }

    public void resetSortByDate() {
        this.sortByDate = false;
    }

    public void setSearchServer(String servername) {
        this.server = servername;
    }

    public String getCommentURL(SOIF comment) {
        return this.server + "/" + comment.getURL();
    }

    public List getUnclusteredComments() {
        return this.unclusteredComments;
    }
}

