/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav;

import HTTPClient.HTTPResponse;
import com.aligo.pim.PimContainerType;
import com.aligo.pim.PimFactory;
import com.aligo.pim.PimFolderType;
import com.aligo.pim.PimTimeZoneType;
import com.aligo.pim.PimUserInfoParameter;
import com.aligo.pim.exchangewebdav.ExWebDavPimCalendar;
import com.aligo.pim.exchangewebdav.ExWebDavPimException;
import com.aligo.pim.exchangewebdav.ExWebDavPimGlobalAddressBook;
import com.aligo.pim.exchangewebdav.ExWebDavPimInbox;
import com.aligo.pim.exchangewebdav.ExWebDavPimPersonalAddressBook;
import com.aligo.pim.exchangewebdav.ExWebDavPimUserInfo;
import com.aligo.pim.exchangewebdav.util.ExWebDavHttpConnector;
import com.aligo.pim.exchangewebdav.util.ExWebDavPimFolderType;
import com.aligo.pim.exchangewebdav.util.xml.DocumentFactory;
import com.aligo.pim.exchangewebdav.util.xml.XMLUtilities;
import com.aligo.pim.interfaces.PimAddressBook;
import com.aligo.pim.interfaces.PimContainer;
import com.aligo.pim.interfaces.PimSession;
import com.aligo.pim.interfaces.PimUserInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExWebDavPimSession
implements PimSession {
    private ExWebDavPimUserInfo m_oPimUserInfo;
    private ExWebDavHttpConnector m_oHttpConnector;
    private PimTimeZoneType m_oPimTimeZoneType = PimTimeZoneType.GMT;
    private boolean isItLdapConnection = false;

    public ExWebDavPimSession(ExWebDavPimUserInfo pimUserInfo) {
        this.m_oPimUserInfo = pimUserInfo.getClone();
    }

    public void logon() throws ExWebDavPimException {
        this.m_oHttpConnector = new ExWebDavHttpConnector();
        this.m_oHttpConnector.logon(this);
        this.getRootFolder();
        String jndiServer = this.m_oPimUserInfo.getJndiLdapServer();
        if (jndiServer != null) {
            this.isItLdapConnection = true;
            try {
                this.getLdapAddressBook();
            }
            catch (Exception e) {
                this.isItLdapConnection = false;
            }
        }
    }

    public void setTimeZone(PimTimeZoneType pimTimeZone) {
        this.m_oPimTimeZoneType = pimTimeZone;
    }

    public PimTimeZoneType getTimeZone() {
        return this.m_oPimTimeZoneType;
    }

    public ExWebDavHttpConnector getHttpConnector() {
        return this.m_oHttpConnector;
    }

    public void getRootFolder() throws ExWebDavPimException {
        try {
            Document document = DocumentFactory.createDOMDocument();
            Element rootElement = document.createElement("DAV:propfind");
            rootElement.setAttribute("xmlns:rootfolder", "urn:schemas:httpmail:");
            rootElement.setAttribute("xmlns:DAV", "DAV:");
            Element propElement = document.createElement("DAV:prop");
            Element mailboxElement = document.createElement("rootfolder:msgfolderroot");
            propElement.appendChild(mailboxElement);
            rootElement.appendChild(propElement);
            String xmlstring = XMLUtilities.toXMLStringNS(rootElement);
            HTTPResponse response = this.m_oHttpConnector.sendRequest("PROPFIND", "/exchange/" + this.m_oPimUserInfo.getMailbox(), xmlstring);
            if (XMLUtilities.getValue(response.getText(), "urn:schemas:httpmail:", "msgfolderroot") == "") {
                throw new ExWebDavPimException(46L);
            }
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public String getRootFolderName() {
        return ExWebDavPimFolderType.ROOT_FOLDER + "";
    }

    public ExWebDavPimUserInfo getUserInfo() {
        return this.m_oPimUserInfo;
    }

    public ExWebDavPimPersonalAddressBook getContact(String user) throws ExWebDavPimException {
        try {
            return new ExWebDavPimPersonalAddressBook(user, this);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimCalendar getCalendar(String user) throws ExWebDavPimException {
        try {
            return new ExWebDavPimCalendar(user, this);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public ExWebDavPimInbox getInbox(String user) throws ExWebDavPimException {
        try {
            return new ExWebDavPimInbox(user, this);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressBook getLdapAddressBook() throws ExWebDavPimException {
        try {
            PimContainer pimContainer = PimFactory.getContainer((PimContainerType)PimContainerType.JNDI);
            PimUserInfo pimUserInfo = pimContainer.addUserInfo();
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_SERVER, this.m_oPimUserInfo.getJndiLdapServer());
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_USERNAME, this.m_oPimUserInfo.getJndiLdapUserName());
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_PASSWORD, this.m_oPimUserInfo.getJndiLdapPassword());
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_PORT, this.m_oPimUserInfo.getJndiLdapPort());
            pimUserInfo.set(PimUserInfoParameter.JNDI_LDAP_AB_BASE, this.m_oPimUserInfo.getJndiLdapABBaseDn());
            pimContainer.logon();
            return (PimAddressBook)pimContainer.getFolder(PimFolderType.GLOBAL_ADDRESS_BOOK);
        }
        catch (Exception e) {
            throw new ExWebDavPimException(e);
        }
    }

    public PimAddressBook getGlobalAddressBook(String user) throws ExWebDavPimException {
        try {
            if (this.isItLdapConnection) {
                return this.getLdapAddressBook();
            }
            return new ExWebDavPimGlobalAddressBook(user, this);
        }
        catch (Exception e) {
            return null;
        }
    }
}

