/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import com.sun.portal.search.robot.ConverterConfig;
import com.sun.portal.search.robot.FilterRule;
import com.sun.portal.search.robot.FilterRuleset;
import com.sun.portal.search.robot.ProcessConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RobotConfig {
    HashMap rules = null;
    HashMap rulesets = null;
    int lastRulesetID = 0;
    public int lastRuleID = 0;
    public static final int ALLOW = 1;
    public static final int DENY = 2;
    public static final int GO_NEXT = 3;
    public String filterrules_conf = null;
    public String process_conf = null;
    StringBuffer frs_header_comment = null;
    ArrayList pre_comment = null;
    String[] RulesetIDs = null;
    String[] RuleIDs = null;
    String[] RuleNicknames = null;
    public ProcessConfig processConf = null;
    ArrayList filterConf = null;
    int extractSizeNdx = -1;
    int extractSize = -1;
    static final int full_text_size = 32000;
    public ConverterConfig convertConf = null;

    public static void main(String[] stringArray) {
        RobotConfig robotConfig = new RobotConfig(stringArray[0]);
        if (stringArray.length == 3) {
            robotConfig.newRuleset(stringArray[1], Integer.parseInt(stringArray[2]), false, null);
        }
        System.out.println("ROBOT.CONF:\n" + robotConfig.processConf.toString());
    }

    public RobotConfig(String string) {
        this.filterrules_conf = string + File.separator + "filterrules.conf";
        this.process_conf = string + File.separator + "robot.conf";
        this.rules = new HashMap();
        this.rulesets = new HashMap();
        this.parse_filterrules(this.filterrules_conf);
        try {
            this.processConf = ProcessConfig.parseProcessConf(this.process_conf);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parse_filterConf(string + File.separator + "filter.conf");
        this.convertConf = new ConverterConfig(string);
    }

    void parse_filterConf(String string) {
        BufferedReader bufferedReader = null;
        String string2 = null;
        this.filterConf = new ArrayList();
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                this.filterConf.add(string2);
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    int getExtractSize() {
        if (this.filterConf == null) {
            return 32000;
        }
        if (this.extractSize > 0) {
            return this.extractSize;
        }
        for (int i = 0; i < this.filterConf.size(); ++i) {
            int n;
            int n2;
            String string = (String)this.filterConf.get(i);
            if (string == null || !string.startsWith("Generate") || string.indexOf("fn=extract-full-text") <= 0 || (n2 = string.indexOf("truncate=")) <= 0 || (n = string.indexOf(32, n2 + 9)) <= 0) continue;
            String string2 = string.substring(n2 + 9, n);
            this.extractSizeNdx = i;
            return Integer.parseInt(string2);
        }
        return 32000;
    }

    void parse_filterrules(String string) {
        int n = 0;
        FilterRule filterRule = null;
        FilterRuleset filterRuleset = null;
        String string2 = null;
        BufferedReader bufferedReader = null;
        String string3 = "";
        String string4 = "";
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            return;
        }
        boolean bl = false;
        while (string2 != null) {
            String string5 = string2.trim();
            if (string5.length() == 0) {
                try {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            if (string5.startsWith("#")) {
                switch (n) {
                    case 0: {
                        if (string5.startsWith("#FR#")) {
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            this.addComment(string5);
                            break;
                        }
                        this.addPreComment(string5);
                        break;
                    }
                    case 2: {
                        filterRule.addComment(string2.substring(1));
                        break;
                    }
                    case 4: {
                        filterRuleset.addComment(string2.substring(1));
                    }
                }
                try {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            switch (n) {
                case 0: {
                    if (string5.startsWith("<Rule ")) {
                        string3 = string3 + " " + string5;
                        if (string5.endsWith(">")) {
                            filterRule = new FilterRule(string3);
                            filterRule.addPreComment(this.pre_comment);
                            this.pre_comment = null;
                            this.rules.put(filterRule.id, filterRule);
                            if (Integer.parseInt(filterRule.id) > this.lastRuleID) {
                                this.lastRuleID = Integer.parseInt(filterRule.id);
                            }
                            string3 = "";
                            n = 2;
                        } else {
                            n = 1;
                        }
                    } else if (string5.startsWith("<Ruleset ")) {
                        string4 = string4 + " " + string5;
                        if (string5.endsWith(">")) {
                            filterRuleset = new FilterRuleset(string4);
                            filterRuleset.addPreComment(this.pre_comment);
                            this.pre_comment = null;
                            this.rulesets.put(filterRuleset.id, filterRuleset);
                            if (Integer.parseInt(filterRuleset.id) > this.lastRulesetID) {
                                this.lastRulesetID = Integer.parseInt(filterRuleset.id);
                            }
                            string4 = "";
                            n = 4;
                        } else {
                            n = 3;
                        }
                    } else {
                        System.out.println("Invalid statement:" + string5);
                    }
                    bl = true;
                    break;
                }
                case 1: {
                    string3 = string3 + " " + string5;
                    if (!string5.endsWith(">")) break;
                    filterRule = new FilterRule(string3);
                    filterRule.addPreComment(this.pre_comment);
                    this.pre_comment = null;
                    this.rules.put(filterRule.id, filterRule);
                    if (Integer.parseInt(filterRule.id) > this.lastRuleID) {
                        this.lastRuleID = Integer.parseInt(filterRule.id);
                    }
                    string3 = "";
                    n = 2;
                    break;
                }
                case 2: {
                    if (string5.startsWith("</Rule>")) {
                        n = 0;
                        break;
                    }
                    if (!string5.startsWith("Filter")) break;
                    filterRule.addFilter(string5);
                    break;
                }
                case 3: {
                    string4 = string4 + " " + string5;
                    if (!string5.endsWith(">")) break;
                    filterRuleset = new FilterRuleset(string4);
                    filterRuleset.addPreComment(this.pre_comment);
                    this.pre_comment = null;
                    this.rulesets.put(filterRuleset.id, filterRuleset);
                    if (Integer.parseInt(filterRuleset.id) > this.lastRulesetID) {
                        this.lastRulesetID = Integer.parseInt(filterRuleset.id);
                    }
                    string4 = "";
                    n = 4;
                    break;
                }
                case 4: {
                    if (string5.startsWith("</Ruleset>")) {
                        n = 0;
                        break;
                    }
                    if (!string5.startsWith("Rule")) break;
                    filterRuleset.AddFilterbyString(string5);
                }
            }
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
                break;
            }
        }
        this.getRuleIDs();
        this.getRulsetIDs();
    }

    public void updateFile() {
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.filterrules_conf);
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8")), true);
        }
        catch (Exception exception) {
            System.out.println("[updateFile]Exception:" + exception.getMessage());
            return;
        }
        if (this.frs_header_comment != null) {
            printWriter.print(this.frs_header_comment);
        }
        printWriter.print("#FR###########################################################################\n");
        printWriter.print("#FR# Rules\n");
        printWriter.print("#FR###########################################################################\n\n");
        this.printRules(printWriter);
        printWriter.print("#FR###########################################################################\n");
        printWriter.print("#FR# Rulesets\n");
        printWriter.print("#FR###########################################################################\n\n");
        this.printRuleSets(printWriter);
        printWriter.print("#FR######################################################\n");
        printWriter.print("#FR# Nothing after the last </ruleset> is saved.\n");
        printWriter.print("#FR######################################################\n");
        printWriter.close();
    }

    public String newPathFilterRule(String string) {
        String string2 = "pathname " + string;
        for (int i = 0; i < this.RuleNicknames.length; ++i) {
            if (!string2.equals(this.RuleNicknames[i])) continue;
            return this.RuleIDs[i];
        }
        String string3 = Integer.toString(this.lastRuleID + 1);
        FilterRule filterRule = new FilterRule(string3, true, "pathname " + string, true, false);
        if (filterRule != null) {
            filterRule.addFilter(FilterRule.filter_srcs[3], FilterRule.filter_methods[2], string);
            this.AddRule(string3, filterRule);
        }
        return string3;
    }

    public String getIDByNick(String string) {
        for (int i = 0; i < this.RuleNicknames.length; ++i) {
            if (!string.equals(this.RuleNicknames[i])) continue;
            return this.RuleIDs[i];
        }
        return null;
    }

    public FilterRuleset newRuleset(String string, int n, boolean bl, String string2) {
        FilterRuleset filterRuleset = null;
        try {
            URL uRL = new URL(string);
            filterRuleset = this.newRuleset(uRL, n, bl, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filterRuleset;
    }

    public FilterRuleset findFiletrRulesetHasDomain(String string) {
        for (int i = 0; i < this.RulesetIDs.length; ++i) {
            FilterRuleset filterRuleset = (FilterRuleset)this.rulesets.get(this.RulesetIDs[i]);
            if (filterRuleset.getType() != 2) continue;
            for (int j = 0; j < filterRuleset.numOfDomains(); ++j) {
                String string2 = filterRuleset.getDomainByIndex(j);
                if (!string.equals(string2)) continue;
                return filterRuleset;
            }
        }
        return null;
    }

    public FilterRuleset findFiletrRulesetHasStartingPoint(String string) {
        for (int i = 0; i < this.RulesetIDs.length; ++i) {
            FilterRuleset filterRuleset = (FilterRuleset)this.rulesets.get(this.RulesetIDs[i]);
            for (int j = 0; j < filterRuleset.numOfStartingPoints(); ++j) {
                String string2 = filterRuleset.getStartingPointByIndex(j);
                if (!string2.startsWith(string.trim() + " ")) continue;
                return filterRuleset;
            }
        }
        return null;
    }

    FilterRuleset findFiletrRulesetFor(URL uRL) {
        for (int i = 0; i < this.RulesetIDs.length; ++i) {
            FilterRuleset filterRuleset = (FilterRuleset)this.rulesets.get(this.RulesetIDs[i]);
            if (!filterRuleset.isForMe(uRL)) continue;
            return filterRuleset;
        }
        return null;
    }

    public String[] getFiletrRulesetIDsForFilterRule(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.RulesetIDs.length; ++i) {
            FilterRuleset filterRuleset = (FilterRuleset)this.rulesets.get(this.RulesetIDs[i]);
            if (!filterRuleset.isFilterInUsed(string)) continue;
            arrayList.add(filterRuleset.id);
        }
        if (arrayList.size() > 0) {
            String[] stringArray = new String[]{""};
            return arrayList.toArray(stringArray);
        }
        return null;
    }

    public FilterRuleset newRuleset(URL uRL, int n, boolean bl, String string) {
        FilterRule filterRule;
        String string2 = uRL.toString() + " depth=" + n;
        FilterRuleset filterRuleset = null;
        if (!bl && (filterRuleset = this.findFiletrRulesetFor(uRL)) != null) {
            FilterRule filterRule2;
            filterRuleset.addStartingPoint(uRL, n);
            if (string != null && (filterRule2 = (FilterRule)this.rules.get(string)) != null && filterRule2.enable && !filterRuleset.onExit) {
                filterRuleset.AddFilter(filterRule2.id, filterRule2.default_ad);
            }
            return filterRuleset;
        }
        String string3 = uRL.getHost();
        String string4 = uRL.getProtocol();
        int n2 = uRL.getPort();
        String string5 = string4 + "://" + string3 + (n2 > 0 ? ":" + Integer.toString(n2) : "") + "/";
        int n3 = this.lastRulesetID + 1;
        if (bl) {
            String string6 = string3;
            int n4 = string3.indexOf(46);
            if (n4 > 0) {
                string6 = string3.substring(n4 + 1);
            }
            filterRuleset = new FilterRuleset(Integer.toString(n3), true, false, true, string6, string6, "", "http,file,ftp,https", string2);
        } else {
            filterRuleset = new FilterRuleset(Integer.toString(n3), true, false, string == null, string3, string5, string2);
        }
        if (this.RuleIDs == null) {
            this.freshRulesArray();
        }
        for (int i = 0; i < this.RuleIDs.length; ++i) {
            FilterRule filterRule3 = (FilterRule)this.rules.get(this.RuleIDs[i]);
            if (filterRule3 == null || !filterRule3.enable || !filterRule3.quickcf) continue;
            filterRuleset.AddFilter(filterRule3.id, filterRule3.default_ad);
        }
        if (string != null && (filterRule = (FilterRule)this.rules.get(string)) != null && filterRule.enable) {
            filterRuleset.AddFilter(filterRule.id, filterRule.default_ad);
        }
        this.rulesets.put(Integer.toString(n3), filterRuleset);
        this.RulesetIDs = null;
        this.getRulsetIDs();
        this.lastRulesetID = n3;
        return filterRuleset;
    }

    public boolean delRuleset(int n) {
        if (n < 0 || n >= this.RulesetIDs.length) {
            return false;
        }
        return this.delRuleset(this.RulesetIDs[n]);
    }

    void removeAssoicatedPathFilter(String string) {
        int n;
        FilterRuleset filterRuleset = this.GetRuleSet(string);
        if (filterRuleset == null) {
            return;
        }
        int n2 = filterRuleset.numOfFilters();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < n2; ++n) {
            String[] stringArray;
            String string2 = filterRuleset.getFiltersIDByIndex(n);
            FilterRule filterRule = this.GetRule(string2);
            if (!filterRule.nickname.startsWith("pathname ") || (stringArray = this.getFiletrRulesetIDsForFilterRule(string2)) == null || stringArray.length != 1 || !stringArray[0].equals(string)) continue;
            arrayList.add(string2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.delRule((String)arrayList.get(n));
        }
    }

    public boolean delRuleset(String string) {
        if (string == null || this.rulesets == null) {
            return false;
        }
        this.removeAssoicatedPathFilter(string);
        if (this.rulesets.remove(string) != null) {
            this.RulesetIDs = null;
            this.getRulsetIDs();
            return true;
        }
        return false;
    }

    public boolean delRule(int n) {
        if (n < 0 || n >= this.RuleIDs.length) {
            return false;
        }
        return this.delRule(this.RuleIDs[n]);
    }

    public boolean delRule(String string) {
        if (string == null || this.rules == null) {
            return false;
        }
        if (this.rules.remove(string) != null) {
            this.freshRulesArray();
            this.rmRuleFromRuleset(string);
            return true;
        }
        return false;
    }

    void rmRuleFromRuleset(String string) {
        Iterator iterator = this.rulesets.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            FilterRuleset filterRuleset = (FilterRuleset)this.rulesets.get(k);
            if (filterRuleset == null) continue;
            filterRuleset.deleteFilterByID(string);
        }
    }

    public void AddRule(String string, FilterRule filterRule) {
        this.rules.put(string, filterRule);
        this.freshRulesArray();
        if (Integer.parseInt(string) > this.lastRuleID) {
            this.lastRuleID = Integer.parseInt(string);
        }
    }

    public int numOfRules() {
        return this.rules.size();
    }

    public FilterRule GetRule(String string) {
        return (FilterRule)this.rules.get(string);
    }

    public FilterRule GetRuleByIndex(int n) {
        if (this.RuleIDs == null) {
            this.freshRulesArray();
        }
        if (n < 0 || n >= this.RuleIDs.length) {
            return null;
        }
        return (FilterRule)this.rules.get(this.RuleIDs[n]);
    }

    public void AddRuleSet(String string, FilterRuleset filterRuleset) {
        this.rulesets.put(string, filterRuleset);
    }

    public FilterRuleset GetRuleSet(String string) {
        return (FilterRuleset)this.rulesets.get(string);
    }

    public FilterRuleset GetRuleSet(int n) {
        if (n < 0 || n >= this.RulesetIDs.length) {
            return null;
        }
        return (FilterRuleset)this.rulesets.get(this.RulesetIDs[n]);
    }

    public int numRuleset() {
        return this.rulesets.size();
    }

    public int numRule() {
        return this.rules.size();
    }

    public String[] getRulsetIDs() {
        if (this.RulesetIDs != null) {
            return this.RulesetIDs;
        }
        this.RulesetIDs = new String[this.rulesets.size()];
        Iterator iterator = this.rulesets.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.RulesetIDs[n++] = (String)iterator.next();
        }
        return this.RulesetIDs;
    }

    public void freshRulesArray() {
        FilterRule filterRule;
        Object object;
        this.RuleIDs = new String[this.rules.size()];
        this.RuleNicknames = new String[this.rules.size()];
        int[] nArray = new int[this.rules.size()];
        Iterator iterator = this.rules.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            filterRule = (FilterRule)this.rules.get(object);
            nArray[n++] = Integer.parseInt(filterRule.id);
        }
        Arrays.sort(nArray);
        for (n = 0; n < nArray.length; ++n) {
            object = Integer.toString(nArray[n]);
            filterRule = (FilterRule)this.rules.get(object);
            this.RuleIDs[n] = object;
            this.RuleNicknames[n] = filterRule.nickname;
        }
    }

    public String[] getRuleIDs() {
        if (this.RuleIDs == null || this.RuleNicknames == null) {
            this.freshRulesArray();
        }
        return this.RuleIDs;
    }

    public String[] getRuleNicknames() {
        if (this.RuleIDs == null || this.RuleNicknames == null) {
            this.freshRulesArray();
        }
        return this.RuleNicknames;
    }

    public boolean FilterURL(String string) {
        String string2;
        Object object;
        boolean bl = false;
        URL uRL = null;
        try {
            uRL = new URL(string);
            object = uRL.getProtocol();
            String string3 = uRL.getHost();
            String string4 = Integer.toString(uRL.getPort());
            string2 = (String)object + "://" + string3 + ":" + string4 + "/";
            System.out.println("Finding FRS for url:" + string2);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Invalid URL:<" + string + ">");
            return true;
        }
        object = this.GetRuleSet(string2);
        if (object == null) {
            return true;
        }
        return ((FilterRuleset)object).Filter(string);
    }

    public void printRules(PrintWriter printWriter) {
        for (int i = 0; i < this.RuleIDs.length; ++i) {
            FilterRule filterRule = (FilterRule)this.rules.get(this.RuleIDs[i]);
            if (filterRule == null) continue;
            printWriter.println();
            printWriter.print(filterRule.toConfigString());
        }
    }

    public int numOfStartingPoint(boolean bl) {
        Iterator iterator = this.rulesets.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                FilterRuleset filterRuleset = (FilterRuleset)this.rulesets.get(string);
                if (bl && !filterRuleset.enable) continue;
                n += filterRuleset.starting_points.size();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        return n;
    }

    public void printRuleSets(PrintWriter printWriter) {
        Iterator iterator = this.rulesets.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                FilterRuleset filterRuleset = (FilterRuleset)this.rulesets.get(string);
                printWriter.print(filterRuleset.toConfigString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
    }

    public boolean RuleMatch(String string, String string2) {
        FilterRule filterRule = (FilterRule)this.rules.get(string);
        if (filterRule == null) {
            return false;
        }
        return filterRule.Match(string2);
    }

    public static String ADtoString(boolean bl) {
        if (bl) {
            return "allow";
        }
        return "deny";
    }

    public static boolean ADStringtoBoolean(String string) {
        return string.compareToIgnoreCase("allow") == 0;
    }

    public static String BtoString(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public static boolean StringtoBoolean(String string) {
        return string.compareToIgnoreCase("true") == 0;
    }

    public void addComment(String string) {
        if (this.frs_header_comment == null) {
            this.frs_header_comment = new StringBuffer(string + "\n");
        } else {
            this.frs_header_comment.append(string + "\n");
        }
    }

    public void addPreComment(String string) {
        if (this.pre_comment == null) {
            this.pre_comment = new ArrayList();
        }
        this.pre_comment.add(string.substring(1));
    }
}

