/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.robot.FilterRule;
import com.sun.portal.search.robot.StringFilter;
import java.util.ArrayList;

public class StringFilterListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
InsertingModel,
DeletingModel {
    private String ruleID = null;
    private int delIndex = -1;
    public static final String FIELD_FILTERSRC = "FilterSrc";
    public static final String FIELD_FILTERBY = "FilterBy";
    public static final String FIELD_PATTERN = "Pattern";
    public static final String FIELD_DELETE = "Delete";

    public StringFilterListModel() {
        CSDebug.logln("StringFilterListModel()");
    }

    public void setID(String string) {
        this.ruleID = string;
    }

    public void setDelIndex(int n) {
        this.delIndex = n;
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("StringFilterListModel.execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        } else if (string.equals("insert")) {
            object = this.insert(modelExecutionContext);
        } else if (string.equals("update")) {
            object = this.update(modelExecutionContext);
        } else if (string.equals("delete")) {
            object = this.delete(modelExecutionContext);
        }
        return object;
    }

    private void removeNullList() throws ModelControlException {
        if (this.getSize() == 1 && this.getValue(FIELD_PATTERN) == null) {
            this.getCurrentContext().getValueList().clear();
        }
    }

    public Object update(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        CSDebug.logln("StringFilterListModel.update()");
        this.beforeFirst();
        FilterRule filterRule = null;
        if (this.ruleID != null) {
            filterRule = CSConfig.getRobotConfig().GetRule(this.ruleID);
        }
        if (filterRule != null) {
            filterRule.removeAllFilter();
            while (this.next()) {
                String string = (String)this.getValue(FIELD_FILTERSRC);
                String string2 = (String)this.getValue(FIELD_FILTERBY);
                String string3 = (String)this.getValue(FIELD_PATTERN);
                if (string3 == null || string3.trim().length() <= 0) continue;
                filterRule.addFilter(string, string2, string3.trim());
            }
        }
        return null;
    }

    public Object insert(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        CSDebug.logln(((Object)((Object)this)).getClass().getName() + ".insert()");
        this.appendRow();
        this.setValue(FIELD_FILTERSRC, FilterRule.filter_srcs[0]);
        this.setValue(FIELD_FILTERBY, FilterRule.filter_methods[0]);
        this.setValue(FIELD_PATTERN, "");
        return null;
    }

    public Object delete(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        CSDebug.logln(((Object)((Object)this)).getClass().getName() + ".delete()");
        if (this.delIndex != -1) {
            this.getCurrentContext().getValueList().remove(this.delIndex);
            return null;
        }
        ArrayList arrayList = new ArrayList();
        this.beforeFirst();
        while (this.next()) {
            String string = (String)this.getValue(FIELD_DELETE);
            if (string == null || string.compareTo("true") != 0) continue;
            int n = this.getRowIndex();
            arrayList.add(this.getCurrentContext().getValueList().get(n));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.getCurrentContext().getValueList().remove(arrayList.get(i));
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("StringFilterModel.retrieve");
        FilterRule filterRule = null;
        if (this.ruleID != null) {
            if (this.ruleID.compareTo("new") == 0) {
                this.clear();
                this.insert(modelExecutionContext);
            } else {
                filterRule = CSConfig.getRobotConfig().GetRule(this.ruleID);
                if (filterRule != null) {
                    this.clear();
                    int n = filterRule.numberOfStringFilters();
                    for (int i = 0; i < n; ++i) {
                        StringFilter stringFilter = (StringFilter)filterRule.filters.get(i);
                        if (stringFilter == null) continue;
                        this.appendRow();
                        this.setValue(FIELD_FILTERSRC, stringFilter.directive);
                        this.setValue(FIELD_FILTERBY, FilterRule.getMethodText(stringFilter.method));
                        this.setValue(FIELD_PATTERN, stringFilter.filter);
                    }
                }
            }
        } else {
            CSDebug.logln("StringFilterModel.retrieve ruleID=null");
        }
        this.beforeFirst();
        return null;
    }
}

