/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.robot.FilterRuleset;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class ServerGroupListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
InsertingModel,
DeletingModel {
    private String rulesetID = null;
    private int delIndex = -1;
    public static final String FIELD_HOST = "Host";
    public static final String FIELD_VERIFIED_TEXT = "VerifiedText";
    public static final String FIELD_PROTOCOL = "Protocol";
    public static final String FIELD_PORT = "Port";
    public static final String FIELD_DELETE = "Delete";

    public ServerGroupListModel() {
        CSDebug.logln("ServerGroupListModel()");
    }

    public void setID(String string) {
        this.rulesetID = string;
    }

    public void setDelIndex(int n) {
        this.delIndex = n;
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("ServerGroupListModel.execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        } else if (string.equals("insert")) {
            object = this.insert(modelExecutionContext);
        } else if (string.equals("update")) {
            object = this.update(modelExecutionContext);
        } else if (string.equals("delete")) {
            object = this.delete(modelExecutionContext);
        }
        return object;
    }

    public Object update(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        CSDebug.logln("ServerGroupListModel.update()");
        this.beforeFirst();
        FilterRuleset filterRuleset = null;
        if (this.rulesetID != null) {
            filterRuleset = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (filterRuleset != null) {
            filterRuleset.removeServers();
            while (this.next()) {
                String string = (String)this.getValue(FIELD_HOST);
                String string2 = (String)this.getValue(FIELD_PROTOCOL);
                String string3 = (String)this.getValue(FIELD_PORT);
                if (string == null || string2 == null || string3 == null || string.trim().length() <= 0) continue;
                try {
                    int n = -1;
                    try {
                        n = Integer.parseInt(string3);
                    }
                    catch (Exception exception) {
                        n = -1;
                    }
                    URL uRL = new URL(string2, string, n, "/");
                    filterRuleset.addServer(uRL.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    CSDebug.logln("MalformedURLException for host=" + string + " protocol=" + string2 + " port=" + string3);
                }
            }
        }
        return null;
    }

    private void removeNullList() throws ModelControlException {
        if (this.getSize() == 1) {
            if (this.getValue(FIELD_HOST) == null) {
                this.getCurrentContext().getValueList().clear();
            }
        }
    }

    public Object insert(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        this.appendRow();
        this.setValue(FIELD_PROTOCOL, FilterRuleset.ProtocolTypes[0]);
        this.setValue(FIELD_PORT, "80");
        return null;
    }

    public Object delete(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        CSDebug.logln(((Object)((Object)this)).getClass().getName() + ".delete()");
        if (this.delIndex != -1) {
            this.getCurrentContext().getValueList().remove(this.delIndex);
            return null;
        }
        ArrayList arrayList = new ArrayList();
        this.beforeFirst();
        while (this.next()) {
            String string = (String)this.getValue(FIELD_DELETE);
            if (string == null || string.compareTo("true") != 0) continue;
            int n = this.getRowIndex();
            arrayList.add(this.getCurrentContext().getValueList().get(n));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.getCurrentContext().getValueList().remove(arrayList.get(i));
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("ServerGroupModel.retrieve");
        FilterRuleset filterRuleset = null;
        if (this.rulesetID != null) {
            filterRuleset = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (filterRuleset != null) {
            this.clear();
            int n = filterRuleset.numOfServers();
            for (int i = 0; i < n; ++i) {
                String string = filterRuleset.getServerByIndex(i);
                if (string == null) continue;
                try {
                    URL uRL = new URL(string);
                    this.appendRow();
                    this.setValue(FIELD_HOST, uRL.getHost());
                    this.setValue(FIELD_VERIFIED_TEXT, uRL.getHost());
                    this.setValue(FIELD_PROTOCOL, uRL.getProtocol());
                    if (!uRL.getProtocol().equalsIgnoreCase("file")) {
                        this.setValue(FIELD_PORT, Integer.toString(uRL.getPort()));
                    }
                    this.setValue(FIELD_DELETE, "false");
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    CSDebug.logln("MalformedURLException thrown for url:" + string);
                }
            }
        }
        this.beforeFirst();
        return null;
    }
}

