/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.rdm.RDMSchema;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;

public class SchemaModel
extends DefaultModel {
    private String name = "";
    private String oldName = "";
    private String description = "";
    private String multiplier = null;
    private String aliases = "";
    private boolean editable = false;
    private boolean indexable = false;
    private String dataType = "";
    private static RDMSchema schema;
    private String edit = "";
    private String index = "";
    private String schfn = "";
    private String errMsg = null;
    public final String DEFAULT_TYPE = "string";
    public static final String[] DATA_TYPES;

    public SchemaModel() {
        this.loadSchema();
        this.name = "New";
    }

    public SchemaModel(String string) {
        super(string);
        this.loadSchema();
        this.name = string;
        this.oldName = string;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public void initializeValues() {
        String[] stringArray = schema.schema_nonInternal_attrs();
        if (stringArray.length > 0) {
            this.name = stringArray[0];
        }
    }

    public boolean doAdd() {
        int n = schema.getColumnNumber(this.name);
        if (n == -1) {
            int n2 = schema.getNumEntriesInt();
            n = schema.getMaxIndex() + 1;
            schema.setSOIFAttribute(n, this.name);
            schema.setColumnName(n, this.name);
            schema.setSysColumnName(n, this.name);
            schema.setTableName(n, "Documents");
            schema.setSysTableName(n, "doctbl");
            schema.setDescription(n, this.description);
            schema.setAliases(n, this.aliases);
            schema.setEditAttribute(n, this.edit);
            schema.setIndexAttribute(n, this.index);
            schema.setNumEntries(String.valueOf(n2 + 1));
            if (this.multiplier != null) {
                schema.setValue(this.name, "score-multiplier", this.multiplier);
            }
            CSDebug.logln("SchemaModel:doAdd(): " + n + ":" + this.name + ":" + this.description + ":" + this.aliases + ":" + this.edit + ":" + this.index);
            this.saveSchema();
            return true;
        }
        this.errMsg = "schema.error.duplicate";
        return false;
    }

    public boolean validateSchema() {
        if (this.name.trim().equals("")) {
            this.errMsg = "schema.error.emptyname";
            return false;
        }
        for (int i = 0; i < this.name.length(); ++i) {
            char c = this.name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '_' || c == '-') continue;
            this.errMsg = "schema.error.invalidcharinname";
            return false;
        }
        if (this.indexable && this.multiplier != null) {
            try {
                Float f = new Float(this.multiplier);
                if (f.doubleValue() < 0.0) {
                    this.errMsg = "schema.error.negativemultiplier";
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.errMsg = "schema.error.invalidmultiplier";
                return false;
            }
        }
        return true;
    }

    public boolean doUpdate() {
        CSDebug.logln("SchemaModel:doUpdate(): " + this.name + ":" + this.description + ":" + this.aliases + ":" + this.edit + ":" + this.index);
        if (!this.validateSchema()) {
            return false;
        }
        try {
            int n = schema.getColumnNumber(this.oldName);
            if (n == -1) {
                return this.doAdd();
            }
            int n2 = schema.getColumnNumber(this.name);
            if (this.oldName.equals(this.name) || n2 == -1) {
                schema.setSOIFAttribute(n, this.name);
                schema.setColumnName(n, this.name);
                schema.setSysColumnName(n, this.name);
                schema.setDescription(n, this.description);
                schema.setAliases(n, this.aliases);
                schema.setEditAttribute(n, this.edit);
                schema.setIndexAttribute(n, this.index);
                schema.setDataType(n, this.dataType);
                schema.setValue(this.name, "score-multiplier", this.multiplier);
                this.saveSchema();
                CSDebug.logln("Replace schema:" + this.oldName + " with :" + this.name);
                return true;
            }
            this.errMsg = "schema.error.duplicate";
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void doDelete() {
        CSDebug.logln("SchemaModel:doDelete(): " + this.name + ":" + this.description + ":" + this.aliases + ":" + this.edit + ":" + this.index);
        schema.deleteColumn(this.name);
        this.saveSchema();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        if (this.name.equals("")) {
            return "";
        }
        this.description = schema.getValue(this.name, "description");
        return this.description == null ? "" : this.description;
    }

    public String getMultiplier() {
        if (this.name.equals("")) {
            return "";
        }
        this.multiplier = schema.getValue(this.name, "score-multiplier");
        return this.multiplier == null ? "" : this.multiplier;
    }

    public String getAliases() {
        if (this.name.equals("")) {
            return "";
        }
        this.aliases = schema.getValue(this.name, "aliases");
        return this.aliases == null ? "" : this.aliases;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setMultiplier(String string) {
        if (string.trim().length() > 0) {
            this.multiplier = string;
        }
    }

    public void setAliases(String string) {
        this.aliases = string;
    }

    public boolean getEditable() {
        if (this.name.equals("")) {
            return false;
        }
        this.edit = schema.getValue(this.name, "edit-attribute");
        return this.edit != null && this.edit.equals("1");
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.edit = this.editable ? "1" : "0";
    }

    public boolean getIndexable() {
        if (this.name.equals("")) {
            return false;
        }
        this.index = schema.getValue(this.name, "index-attribute");
        return this.index != null && this.index.equals("1");
    }

    public void setIndexable(boolean bl) {
        this.indexable = bl;
        this.index = this.indexable ? "1" : "0";
    }

    public String getDataType() {
        String string = schema.getValue(this.name, "data-type");
        if (string != null) {
            return string;
        }
        return "string";
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public void saveSchema() {
        try {
            SOIFOutputStream sOIFOutputStream = new SOIFOutputStream(this.schfn);
            sOIFOutputStream.write(schema.getSOIF());
        }
        catch (Exception exception) {
            CSDebug.logln("Unable to write SOIF to " + this.schfn + ": " + exception);
        }
    }

    public void loadSchema() {
        String string = CSConfig.getServerRoot() + File.separator + "config" + File.separator + "search.conf";
        try {
            SearchConfig.init((String)string);
        }
        catch (Exception exception) {
            CSDebug.logln("Unable to initialize SearchConfig: " + string);
        }
        this.schfn = SearchConfig.getValue((String)"schema-description");
        if (this.schfn == null) {
            CSDebug.logln("Missing SearchConfig.SCHEMA parameter");
        }
        CSDebug.logln("loadSchema(): location: " + this.schfn);
        SOIFInputStream sOIFInputStream = null;
        try {
            sOIFInputStream = new SOIFInputStream(this.schfn);
        }
        catch (Exception exception) {
            CSDebug.logln("Schema Unavailable: " + this.schfn);
        }
        try {
            schema = new RDMSchema(sOIFInputStream.readSOIF());
        }
        catch (Exception exception) {
            CSDebug.logln("Schema invalid: " + this.schfn);
        }
    }

    public static void printSchema() {
        String[] stringArray = schema.schema_nonInternal_attrs();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = schema.getColumnNumber(string);
            String string2 = schema.getDescription(n);
            String string3 = schema.getAliases(n);
            String string4 = schema.getEditAttribute(n);
            String string5 = schema.getIndexAttribute(n);
            CSDebug.logln("Column-" + n + ":" + string + ":" + string2 + ":" + string3 + ":" + string4 + ":" + string5);
        }
    }

    static {
        DATA_TYPES = new String[]{"blob", "date", "int", "string"};
    }
}

