/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.view.html.OptionList;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.admin.CnConfig;
import com.sun.portal.search.admin.Rule;
import com.sun.portal.search.admin.model.SchemaListModel;
import com.sun.portal.search.admin.resources.SearchResource;
import java.util.ArrayList;
import java.util.Locale;

public class RobotClassRuleListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
DeletingModel {
    public static final String MODEL_NAME = "RobotClassRuleListModel";
    public static final String FIELD_SRC = "Src";
    public static final String FIELD_METHOD = "Method";
    public static final String FIELD_CRITERIA = "Criteria";
    public static final String FIELD_CLASSIFICATION = "Classification";
    public static final String FIELD_DELETE = "Delete";
    static final String[] FIELDS = new String[]{"Src", "Method", "Criteria", "Classification"};
    public Locale userLocale = Locale.getDefault();
    static final String[] methodValues = new String[]{"by-exact", "by-substr", "by-prefix", "by-suffix", "by-regex"};
    private CnConfig cnconfig = new CnConfig(CSConfig.getServerRoot());

    public RobotClassRuleListModel() {
        CSDebug.logln("RobotClassRuleListModel()");
    }

    private void ValidateList() throws ModelControlException {
        int n;
        ArrayList arrayList = new ArrayList();
        this.beforeFirst();
        block0: while (this.next()) {
            for (n = 0; n < FIELDS.length; ++n) {
                if (this.getValue(FIELDS[n]) != null) continue;
                arrayList.add(this.getCurrentContext().getValueList().get(this.getRowIndex()));
                continue block0;
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.getCurrentContext().getValueList().remove(arrayList.get(n));
        }
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("RobotClassRuleListModel.execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        } else if (string.equals("delete")) {
            object = this.delete(modelExecutionContext);
        }
        return object;
    }

    public Object delete(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln(((Object)((Object)this)).getClass().getName() + ".delete()");
        this.beforeFirst();
        int n = 0;
        while (this.next()) {
            String string = (String)this.getValue(FIELD_DELETE);
            if (string == null || string.compareTo("true") != 0) continue;
            int n2 = this.getRowIndex();
            this.cnconfig.delete(n2 - n);
            ++n;
        }
        if (n > 0) {
            this.cnconfig.save();
        }
        return null;
    }

    public int getNumOfRules() {
        return this.cnconfig.getNumberOfRules();
    }

    private void loadRules() {
        String string = CSConfig.getServerRoot();
        this.cnconfig = new CnConfig(string);
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln(((Object)((Object)this)).getClass().getName() + ".retrieve()");
        OptionList optionList = RobotClassRuleListModel.getSrcLst(this.userLocale);
        OptionList optionList2 = RobotClassRuleListModel.getMethodLst(this.userLocale);
        this.clear();
        ArrayList arrayList = this.cnconfig.getRulesList();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Rule rule = (Rule)arrayList.get(i);
            this.appendRow();
            String string = optionList.getValueLabel(rule.getSrc());
            this.setValue(FIELD_SRC, string == null ? rule.getSrc() : string);
            string = optionList2.getValueLabel(rule.getMethod());
            this.setValue(FIELD_METHOD, string == null ? rule.getMethod() : string);
            this.setValue(FIELD_CRITERIA, rule.getName());
            this.setValue(FIELD_CLASSIFICATION, rule.getAction());
        }
        this.beforeFirst();
        return null;
    }

    public static OptionList getSrcLst(Locale locale) {
        OptionList optionList = new OptionList(SearchResource.geti18nArray("classrules.src.options", ",", locale), SearchResource.geti18nArray("classrules.src.values", ",", locale));
        String[] stringArray = new SchemaListModel().getSchemaList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                optionList.add(i, stringArray[i], stringArray[i]);
            }
        }
        return optionList;
    }

    public static OptionList getMethodLst(Locale locale) {
        OptionList optionList = new OptionList(SearchResource.geti18nArray("classrules.method.options", ",", locale), methodValues);
        return optionList;
    }
}

