/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.admin.ImportConfig;
import com.sun.portal.search.admin.resources.SearchResource;
import java.util.Locale;

public class ImportListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
DeletingModel {
    public static final String FIELD_ENABLE = "FieldEnable";
    public static final String FIELD_ID = "FieldID";
    public static final String FIELD_IMAGE = "FieldImage";
    public static final String FIELD_TYPE = "FieldType";
    public static final String FIELD_NAME = "FieldName";
    public static final String FIELD_DELETE = "Delete";
    public static final String[] ENABLE_VALUES = new String[]{"true", "false"};
    public Locale userLocale = Locale.getDefault();

    public ImportListModel() {
        CSDebug.logln("ImportListModel()");
    }

    public ImportListModel(String string) {
        super(string);
        CSDebug.logln("ImportListModel(name)");
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("ImportListModel.execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        }
        return object;
    }

    public Object update(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.beforeFirst();
        while (this.next()) {
            String string = (String)this.getValue(FIELD_ENABLE);
            ImportConfig importConfig = ImportConfig.getImportConfigByIndex(this.getLocation());
            if (importConfig == null) continue;
            importConfig.setValue("enable", string);
        }
        ImportConfig.updateFile();
        return null;
    }

    public Object delete(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        int n;
        CSDebug.logln("ImportListModel.delete");
        this.beforeFirst();
        int n2 = ImportConfig.numOfImportConfig();
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        while (this.next()) {
            ImportConfig importConfig;
            n = this.getLocation();
            String string = (String)this.getValue(FIELD_DELETE);
            stringArray[n] = null;
            if (string.compareTo("true") != 0 || (importConfig = ImportConfig.getImportConfigByIndex(n)) == null) continue;
            stringArray[n] = importConfig.getID();
            CSDebug.logln("deleteID=" + stringArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            ImportConfig.DeleteImportConfigByID(stringArray[n]);
        }
        ImportConfig.updateFile();
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("ImportListModel.retrieve");
        this.clear();
        for (int i = 0; i < ImportConfig.numOfImportConfig(); ++i) {
            ImportConfig importConfig = ImportConfig.getImportConfigByIndex(i);
            this.appendRow();
            this.setValue(FIELD_ID, importConfig.getValue("id"));
            this.setValue(FIELD_ENABLE, importConfig.getValue("enable"));
            String string = importConfig.getValue("csid");
            String string2 = importConfig.getValue("nickname");
            if (string != null) {
                int n;
                if (string2 == null) {
                    string2 = string;
                }
                this.setValue(FIELD_NAME, string2);
                int n2 = string2.indexOf("://");
                if (n2 > 0 && (n = string2.indexOf(47, n2 + 3)) > 0) {
                    this.setValue(FIELD_NAME, SearchResource.geti18nString("search.server", this.userLocale) + ":" + string2.substring(n2 + 3, n) + " [" + string2.substring(n + 1) + "]");
                }
                if (importConfig.getValue("is-ssl") == "true") {
                    this.setValue(FIELD_IMAGE, "../ps/searchadmin/images/key_on.gif");
                } else {
                    this.setValue(FIELD_IMAGE, "../ps/searchadmin/images/key_off.gif");
                }
            } else {
                String string3 = importConfig.getValue("srcfile");
                if (string3 != null) {
                    this.setValue(FIELD_NAME, string2 == null ? string3 : string2);
                }
                this.setValue(FIELD_IMAGE, "../ps/searchadmin/images/file.gif");
            }
            this.setValue(FIELD_DELETE, "false");
        }
        this.beforeFirst();
        return null;
    }
}

