/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.admin.util.DBUtil;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;

public class DbStatModelImpl
extends DefaultModel
implements Serializable {
    private SToken st;
    public static final String ON_FILE_DB_ANALYSIS = "onFileDbAnalysis";
    public static final String filePath = SearchConfig.getValue((String)"tmpdir") + File.separator + "sites.html";
    private Hashtable _listServer = null;
    private Enumeration _serverHref = null;
    private Enumeration _serverRDCounter = null;
    private Hashtable _listProtocol = null;
    private Enumeration _protocolName = null;
    private Enumeration _protocolRDCounter = null;
    private Date _lastUpdated = new Date();
    private int _totalNbRd = 0;
    private String _dbName = null;

    public DbStatModelImpl() {
    }

    public DbStatModelImpl(String string) {
        super(string);
        this.setDbName(string);
        this.retrieve();
    }

    protected void init(HttpServletRequest httpServletRequest) {
        this.retrieve();
    }

    public void setSToken(SToken sToken) {
        this.st = sToken;
    }

    public boolean isCreated() {
        try {
            SOIF sOIF = DBUtil.getDBSoif(CSConfig.getServerRoot(), this.getDbName());
            if (sOIF != null) {
                String string = sOIF.getValue("DbStat-LastModified");
                if (string != null) {
                    DBUtil.df.setLenient(true);
                    Date date = DBUtil.df.parse(string);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            CSDebug.logln("DbStatModelImpl - caught exception e=" + exception.getMessage());
            return false;
        }
    }

    public boolean isOld() {
        if (this.isCreated()) {
            SOIF sOIF = DBUtil.getDBSoif(CSConfig.getServerRoot(), this.getDbName());
            if (sOIF != null) {
                try {
                    DBUtil.df.setLenient(true);
                    Date date = DBUtil.df.parse(sOIF.getValue("DbStat-LastModified"));
                    File file = new File(CSConfig.getServerRoot() + File.separator + "db" + File.separator + this.getDbName() + File.separator + "AL");
                    if (file.exists()) {
                        Date date2 = new Date(file.lastModified());
                        return this.getLastUpdated().before(date2);
                    }
                    CSDebug.logln("DbStatModelImpl - Database " + this.getDbName() + " has statistics but database file is missing");
                    return false;
                }
                catch (Exception exception) {
                    CSDebug.logln("DbStatModelImpl - Database " + this.getDbName() + " has statistics but fail to read them e=" + exception.getMessage());
                    return false;
                }
            }
            CSDebug.logln("DbStatModelImpl - Database " + this.getDbName() + " shows statistics on file, but cannot get the last modified date");
            return true;
        }
        return true;
    }

    public int getTotalNbServer() {
        if (this._listServer != null) {
            return this._listServer.size();
        }
        return 0;
    }

    public int getTotalNbRd() {
        return this._totalNbRd;
    }

    public void setTotalNbRd(int n) {
        this._totalNbRd = n;
    }

    public Hashtable getListServerRd() {
        return this._listServer;
    }

    public void setListServerRd(Hashtable hashtable) {
        this._listServer = hashtable;
    }

    public Enumeration getListServerName() {
        return this._serverHref;
    }

    public void setListServerName(Enumeration enumeration) {
        this._serverHref = enumeration;
    }

    public Enumeration getListServerCounter() {
        return this._serverRDCounter;
    }

    public void setListServerCounter(Enumeration enumeration) {
        this._serverRDCounter = enumeration;
    }

    public Hashtable getListProtocolRd() {
        return this._listProtocol;
    }

    public void setListProtocolRd(Hashtable hashtable) {
        this._listProtocol = hashtable;
    }

    public Enumeration getListProtocolName() {
        return this._protocolName;
    }

    public void setListProtocolName(Enumeration enumeration) {
        this._protocolName = enumeration;
    }

    public Enumeration getListProtocolCounter() {
        return this._protocolRDCounter;
    }

    public void setListProtocolCounter(Enumeration enumeration) {
        this._protocolRDCounter = enumeration;
    }

    public void setLastUpdated(Date date) {
        this._lastUpdated = date;
    }

    public Date getLastUpdated() {
        return this._lastUpdated;
    }

    public String getDbName() {
        return this._dbName;
    }

    public void setDbName(String string) {
        this._dbName = new String(string);
    }

    public void store() {
        try {
            if (!DBUtil.updateDB(CSConfig.getServerRoot(), this.getDbName(), this.getLastUpdated(), this._listServer, this._listProtocol)) {
                CSDebug.logln("DbStatModelImpl-store() failed to store ");
            }
        }
        catch (Exception exception) {
            CSDebug.logln("DbStatModelImpl-store() failed to store e=" + exception.getMessage());
        }
    }

    public Object retrieve() {
        return this.retrieve(true);
    }

    public Object retrieve(boolean bl) {
        if (bl) {
            this._totalNbRd = 0;
            this._listServer = new Hashtable();
            this._listProtocol = new Hashtable();
            try {
                int n;
                SOIF sOIF = DBUtil.getDBSoif(CSConfig.getServerRoot(), this.getDbName());
                String string = null;
                String string2 = null;
                int n2 = Integer.parseInt(sOIF.getValue("DbStat-NbServer"));
                if (n2 != 0) {
                    for (n = 0; n < n2; ++n) {
                        string = "DbStat-Href";
                        string2 = "DbStat-Href-count";
                        this._listServer.put(sOIF.getValue(string, n), sOIF.getValue(string2, n));
                    }
                    this._serverHref = this._listServer.keys();
                    this._serverRDCounter = this._listServer.elements();
                } else {
                    this._listServer = null;
                    this._serverHref = null;
                    this._serverRDCounter = null;
                }
                n = Integer.parseInt(sOIF.getValue("DbStat-NbProtocol"));
                if (n != 0) {
                    for (int i = 0; i < n; ++i) {
                        string = "DbStat-Protocol";
                        string2 = "DbStat-Protocol-count";
                        this._listProtocol.put(sOIF.getValue(string, i), sOIF.getValue(string2, i));
                        this._totalNbRd += Integer.parseInt(sOIF.getValue(string2, i));
                    }
                    this._protocolName = this._listProtocol.keys();
                    this._protocolRDCounter = this._listProtocol.elements();
                } else {
                    this._listProtocol = null;
                    this._protocolName = null;
                    this._protocolRDCounter = null;
                }
                this.setLastUpdated(DBUtil.df.parse(sOIF.getValue("DbStat-LastModified")));
                return this;
            }
            catch (Exception exception) {
                CSDebug.logln("DbStatModelImpl - exception reading OnFile Stat, forcing regeneration");
                return this;
            }
        }
        try {
            BufferedReader bufferedReader = DBUtil.urlStatDatabase(CSConfig.getServerRoot(), this.getDbName());
            this.setTotalNbRd(0);
            this.setListServerRd(new Hashtable());
            this.setListProtocolRd(new Hashtable());
            this.setLastUpdated(null);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                URL uRL;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                if (uRL != null) {
                    int n = uRL.getPort();
                    String string3 = uRL.getProtocol();
                    if (this.getListProtocolRd().containsKey(string3)) {
                        int n3 = Integer.parseInt((String)this._listProtocol.get(string3));
                        this._listProtocol.remove(string3);
                        this._listProtocol.put(string3, Integer.toString(n3 + 1));
                    } else {
                        this._listProtocol.put(string3, "1");
                    }
                    String string4 = string3 != null ? string3 + "://" : new String();
                    string4 = string4 + uRL.getHost();
                    if (n != -1) {
                        string4 = string4 + ":" + n;
                    }
                    if (this._listServer.containsKey(string4 = string4 + "/")) {
                        int n4 = Integer.parseInt((String)this._listServer.get(string4));
                        this._listServer.remove(string4);
                        this._listServer.put(string4, Integer.toString(n4 + 1));
                    } else {
                        this._listServer.put(string4, "1");
                    }
                    this.setTotalNbRd(this.getTotalNbRd() + 1);
                    continue;
                }
                if (string != null) {
                    if (string.startsWith("comment")) {
                        if (this._listProtocol.containsKey("discussions")) {
                            int n = Integer.parseInt((String)this._listProtocol.get("discussions"));
                            this._listProtocol.put("discussions", new Integer(n + 1).toString());
                        } else {
                            this._listProtocol.put("discussions", "1");
                        }
                    } else if (this._listProtocol.containsKey("other")) {
                        int n = Integer.parseInt((String)this._listProtocol.get("other"));
                        this._listProtocol.put("other", new Integer(n + 1).toString());
                    } else {
                        this._listProtocol.put("other", "1");
                    }
                    this.setTotalNbRd(this.getTotalNbRd() + 1);
                    continue;
                }
                CSDebug.logln("DbStatModelImpl - rdURL is null. Db " + SearchConfig.getValue((String)"database-root") + "might be corrupted");
            }
            this.setLastUpdated(new Date());
            this.store();
            return this;
        }
        catch (Exception exception) {
            CSDebug.logln("DbStatModelImpl - failed to retrieve DbStats - execption msg=" + exception.getMessage() + "|" + exception);
            return null;
        }
    }

    public boolean hasMoreServer() {
        if (this._serverHref != null) {
            boolean bl = this._serverHref.hasMoreElements();
            return bl;
        }
        return false;
    }

    public boolean hasMoreProtocol() {
        if (this._protocolName != null) {
            boolean bl = this._protocolName.hasMoreElements();
            return bl;
        }
        return false;
    }

    public String nextServerHref() {
        return this.nextElement(this._serverHref, "serverHref");
    }

    public String nextServerRDCounter() {
        return this.nextElement(this._serverRDCounter, "serverRDCounter");
    }

    public String nextProtocolName() {
        return this.nextElement(this._protocolName, "protocolName");
    }

    public String nextProtocolRDCounter() {
        return this.nextElement(this._protocolRDCounter, "protocolRDCounter");
    }

    private String nextElement(Enumeration enumeration, String string) {
        if (string == null) {
            string = "Enumeration";
        }
        if (enumeration != null) {
            String string2 = null;
            if (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
            } else {
                CSDebug.logln("DbStatModelImpl - can't get nextElement of " + string);
            }
            return string2;
        }
        CSDebug.logln("DbStatModelImpl - nextElement - Enumeration of alias doesn't exist");
        return null;
    }

    public int nbServers() {
        if (this._listServer != null) {
            return this._listServer.size();
        }
        return 0;
    }

    public int nbProtocols() {
        if (this._listProtocol != null) {
            return this._listProtocol.size();
        }
        return 0;
    }

    public void resetServers() {
        this.setListServerName(null);
        this.setListServerCounter(null);
        if (this.getListServerRd() != null) {
            this.setListServerName(this.getListServerRd().keys());
            this.setListServerCounter(this.getListServerRd().elements());
        } else {
            CSDebug.logln("DbStatModelImpl - reset - can't reset non existing Server enumeration");
        }
    }

    public void resetProtocols() {
        this.setListProtocolName(null);
        this.setListProtocolCounter(null);
        if (this.getListProtocolRd() != null) {
            this.setListProtocolName(this.getListProtocolRd().keys());
            this.setListProtocolCounter(this.getListProtocolRd().elements());
        } else {
            CSDebug.logln("DbStatModelImpl - reset - can't reset non existing protocol enumeration");
        }
    }
}

