/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.cli;

import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class RobotController {
    static final String ROBOT_CMD = "robot";
    static final String CATPING_CMD = "catping";
    static final String RDREGISTER_CMD = "rdregister";
    private String[] r_env = null;
    private boolean isValid = false;
    private boolean isRunning = false;
    private boolean isQuery = false;
    static final String rCmd = "cmd";
    static final String rQuery = "query";
    private String binDir = "";
    private String libDir = "";
    private String libPath = "";
    private String serverRoot = "";
    private String configDir = "";
    private String logDir = "";
    private String statusDir = "robot";

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage:RobotController server_root action");
            return;
        }
        CSConfig.init(stringArray[0]);
        CSDebug.setEnable(false);
        RobotController robotController = new RobotController(CSConfig.getServerRoot(), CSConfig.getBinPath(), CSConfig.getLibDir(), CSConfig.getLibPath(), null, null, null);
        if (stringArray[1].startsWith("q:")) {
            robotController.query(stringArray[1].substring(2));
        } else {
            System.out.print("Executing Robot command:" + stringArray[1] + "....");
            if (robotController.command(stringArray[1])) {
                System.out.println("Success.");
            } else {
                System.out.println("Failed.");
            }
        }
    }

    public RobotController(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (string != null) {
            this.serverRoot = string;
        }
        if (string2 != null) {
            this.binDir = string2;
        }
        if (string4 != null) {
            this.libPath = string4;
        }
        if (string3 != null) {
            this.libDir = string3;
        }
        this.configDir = string5 != null ? string5 : this.serverRoot + File.separator + "config";
        this.logDir = string6 != null ? string6 : this.serverRoot + File.separator + "logs";
        if (string7 != null) {
            this.statusDir = string7;
        } else {
            this.statusDir = CSConfig.getRobotConfig().processConf.get("robot-state-dir");
            if (this.statusDir == null) {
                this.statusDir = this.serverRoot + File.separator + ROBOT_CMD;
            }
        }
        CSDebug.logln("OS specific settings os.name:" + System.getProperty("os.name"));
        if (System.getProperty("os.name").startsWith("Windows")) {
            String string8 = "C:\\WINNT";
            if (System.getProperty("os.name").equals("Windows XP")) {
                string8 = "C:\\WINDOWS";
            }
            this.r_env = new String[6];
            this.r_env[0] = "LD_LIBRARY_PATH=" + this.libPath;
            this.r_env[1] = "CS_CONFIG_PATH=" + this.configDir;
            this.r_env[2] = "CS_LOGDIR=" + this.logDir;
            this.r_env[3] = "PATH=" + this.libPath + ";" + this.binDir;
            String string9 = "SYSTEMROOT";
            String string10 = System.getProperty(string9);
            CSDebug.logln("Getting env prop:" + string9 + "=" + string10);
            if (string10 == null) {
                string10 = string8;
            }
            String string11 = "COMSPEC";
            String string12 = System.getProperty(string11);
            CSDebug.logln("Getting env prop:" + string11 + "=" + string12);
            if (string12 == null) {
                string12 = string8 + "\\system32\\cmd.exe";
            }
            this.r_env[4] = string9 + "=" + string10;
            this.r_env[5] = string11 + "=" + string12;
        } else {
            this.r_env = new String[4];
            this.r_env[0] = "LD_LIBRARY_PATH=/usr/lib:/usr/lib/mps:" + this.libPath;
            this.r_env[1] = "CS_CONFIG_PATH=" + this.configDir;
            this.r_env[2] = "CS_LOGDIR=" + this.logDir;
            this.r_env[3] = "PATH=" + this.libPath + ":" + this.binDir;
        }
    }

    public boolean command(String string) {
        if (string.compareToIgnoreCase("Start") == 0) {
            return this.start();
        }
        if (string.compareToIgnoreCase("Stop") == 0) {
            return this.stop();
        }
        if (string.compareToIgnoreCase("pause") == 0) {
            this.pause();
        } else if (string.compareToIgnoreCase("resume") == 0) {
            this.resume();
        } else if (string.compareToIgnoreCase("freshstart") == 0) {
            this.remove_status_files();
        } else {
            byte[] byArray = this.robotURLGet(rCmd, string);
            if (byArray != null) {
                String string2 = new String(byArray);
                System.out.println(string2);
            }
        }
        return true;
    }

    public void query(String string) {
        byte[] byArray = this.robotURLGet(rQuery, string);
        if (byArray != null) {
            String string2 = new String(byArray);
            System.out.println(string2);
        }
    }

    public boolean start_rdregister() {
        String string = RDREGISTER_CMD;
        if (System.getProperty("os.name").startsWith("Windows")) {
            string = "rdregister.exe";
        }
        if (this.isRunning("rdregister.pid", string)) {
            return true;
        }
        try {
            File file;
            String string2 = CSConfig.getRobotConfig().processConf.get("robot-state-dir");
            if (string2 == null) {
                string2 = this.serverRoot + File.separator + ROBOT_CMD;
            }
            if (!(file = new File(string2)).exists()) {
                CSDebug.logln("robot-state-dir:" + string2 + " not exist");
                return false;
            }
            Runtime runtime = Runtime.getRuntime();
            String string3 = this.libDir + File.separator + RDREGISTER_CMD + " -f " + this.configDir + File.separator + "search.conf" + " -p " + string2;
            String[] stringArray = new String[]{this.libDir + File.separator + RDREGISTER_CMD, "-f", this.configDir + File.separator + "search.conf", "-p", string2};
            try {
                CSDebug.logln("start_rdregister:" + string3);
                Process process = runtime.exec(stringArray, this.r_env, new File(this.serverRoot));
            }
            catch (IOException iOException) {
                CSDebug.logln("rt.exec Exception:" + iOException.getMessage());
                return false;
            }
        }
        catch (Exception exception) {
            CSDebug.logln("rt.exec Exception:" + exception.getMessage());
            return false;
        }
        return true;
    }

    public boolean generate_filter_conf_run(String string, String string2) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                return false;
            }
            Runtime runtime = Runtime.getRuntime();
            String string3 = this.libDir + File.separator + "rcpp " + string + " " + string2;
            String[] stringArray = new String[]{this.libDir + File.separator + "rcpp", string, string2};
            try {
                Process process = runtime.exec(stringArray, this.r_env, new File(this.serverRoot));
                process.waitFor();
                if (process.exitValue() != 0) {
                    return false;
                }
            }
            catch (IOException iOException) {
                CSDebug.logln("rt.exec Exception:" + iOException.getMessage());
                return false;
            }
        }
        catch (Exception exception) {
            CSDebug.logln("rt.exec Exception:" + exception.getMessage());
            return false;
        }
        return true;
    }

    public synchronized boolean remove_status_files() {
        CSDebug.logln("Refresh Robot status");
        boolean bl = true;
        if (this.isRunning()) {
            return false;
        }
        File file = new File(this.statusDir);
        if (file.isDirectory()) {
            RobotStatusFileFilter robotStatusFileFilter = new RobotStatusFileFilter();
            File[] fileArray = file.listFiles(robotStatusFileFilter);
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].delete()) continue;
                bl = false;
            }
        }
        return bl;
    }

    public synchronized boolean start() {
        CSDebug.logln("Starting Robot");
        if (this.isRunning()) {
            return true;
        }
        if (!this.generate_filter_conf_run(this.configDir + File.separator + "filter.conf", this.configDir + File.separator + "filter.conf.run")) {
            CSDebug.logln("failed to create filter.conf.run");
            return false;
        }
        if (!this.start_rdregister()) {
            CSDebug.logln("failed to start rdregister ");
            return false;
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            String[] stringArray = new String[]{this.libDir + File.separator + ROBOT_CMD};
            runtime.exec(stringArray, this.r_env, new File(this.serverRoot));
            for (int i = 0; i < 10; ++i) {
                byte[] byArray;
                try {
                    this.wait(1000L);
                }
                catch (Exception exception) {
                    CSDebug.logln("Exception:" + exception.getMessage());
                }
                if (!this.isRunning() || (byArray = this.robotURLGet(rQuery, "run-status")) == null) continue;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            CSDebug.logln("rt.exec Exception:" + iOException.getMessage());
            return false;
        }
    }

    private String Read1stLine(String string) {
        try {
            FileReader fileReader = new FileReader(CSConfig.getServerRoot() + File.separator + "logs" + File.separator + string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            return string2;
        }
        catch (Exception exception) {
            CSDebug.logln("Exception:" + exception.getMessage());
            return null;
        }
    }

    public boolean isPaused() {
        byte[] byArray = this.robotURLGet(rQuery, "run-status");
        if (byArray == null) {
            return false;
        }
        String string = new String(byArray);
        int n = string.indexOf("Robot Status:");
        if (n > 0) {
            String string2 = string.substring(n + 14);
            return string2.startsWith("Paused");
        }
        return false;
    }

    public boolean isRunning() {
        String string = "robot.exe";
        if (System.getProperty("os.name").startsWith("Windows")) {
            string = "robot.exe";
        }
        return this.isRunning("robot.pid", string);
    }

    public boolean isRunning(String string, String string2) {
        String string3 = this.Read1stLine(string);
        String string4 = null;
        if (string3 == null) {
            CSDebug.logln("PID=null");
            return false;
        }
        CSDebug.logln("PID=" + string3);
        Runtime runtime = Runtime.getRuntime();
        try {
            string4 = this.libDir + File.separator + CATPING_CMD + " " + string3 + " " + string2;
            String[] stringArray = new String[]{this.libDir + File.separator + CATPING_CMD, string3, string2};
            Process process = runtime.exec(stringArray, this.r_env);
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int n = process.exitValue();
            CSDebug.logln("catping exit(" + n + ")");
            if (n == 1) {
                return false;
            }
        }
        catch (IOException iOException) {
            CSDebug.logln("rt.exec( " + string4 + ") Exception:" + iOException.getClass().getName() + " msg:" + iOException.getMessage());
            return false;
        }
        return true;
    }

    public synchronized boolean stop() {
        byte[] byArray = this.robotURLGet(rCmd, "stop");
        if (byArray != null) {
            String string = new String(byArray);
        }
        for (int i = 0; i < 10; ++i) {
            try {
                this.wait(1000L);
            }
            catch (Exception exception) {
                CSDebug.logln("Exception:" + exception.getMessage());
            }
            if (this.isRunning()) continue;
            return true;
        }
        return false;
    }

    public void pause() {
        byte[] byArray = this.robotURLGet(rCmd, "pause");
        if (byArray != null) {
            String string = new String(byArray);
            System.out.println(string);
        }
    }

    public void resume() {
        byte[] byArray = this.robotURLGet(rCmd, "resume");
        if (byArray != null) {
            String string = new String(byArray);
            System.out.println(string);
        }
    }

    public String[] getRobotStates() {
        Object object;
        String[] stringArray = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        long l = 0L;
        long l2 = 0L;
        byte[] byArray = this.robotURLGet(rQuery, "robot-states");
        if (byArray != null) {
            object = new String(byArray);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.startsWith("Robot Status:")) {
                    stringArray[11] = string.substring(13).trim();
                    continue;
                }
                if (string.startsWith("url-waiting=")) {
                    n = Integer.parseInt(string.substring(12));
                    continue;
                }
                if (string.startsWith("processed=")) {
                    n2 = Integer.parseInt(string.substring(10));
                    continue;
                }
                if (string.startsWith("retrieved=")) {
                    n3 = Integer.parseInt(string.substring(10));
                    continue;
                }
                if (string.startsWith("reject-by-filter=")) {
                    n4 = Integer.parseInt(string.substring(17));
                    continue;
                }
                if (string.startsWith("reject-by-error=")) {
                    n5 = Integer.parseInt(string.substring(16));
                    continue;
                }
                if (string.startsWith("generated=")) {
                    n6 = Integer.parseInt(string.substring(10));
                    continue;
                }
                if (string.startsWith("generated-bytes=")) {
                    l = Long.parseLong(string.substring(16));
                    continue;
                }
                if (!string.startsWith("run-time=")) continue;
                l2 = Long.parseLong(string.substring(9));
            }
        }
        object = NumberFormat.getInstance();
        ((NumberFormat)object).setMaximumFractionDigits(2);
        stringArray[0] = ((NumberFormat)object).format(n);
        if (l2 > 0L) {
            stringArray[1] = ((NumberFormat)object).format((float)n3 / (float)l2);
            stringArray[3] = ((NumberFormat)object).format((float)n6 / (float)l2);
        }
        stringArray[2] = ((NumberFormat)object).format(n4 + n5);
        stringArray[4] = ((NumberFormat)object).format(n4);
        stringArray[5] = ((NumberFormat)object).format(n5);
        stringArray[6] = ((NumberFormat)object).format(n6);
        stringArray[7] = Long.toString(l);
        stringArray[8] = ((NumberFormat)object).format(n3);
        if (n6 > 0) {
            stringArray[9] = ((NumberFormat)object).format((float)l / (float)n6);
        }
        stringArray[10] = Long.toString(l2);
        return stringArray;
    }

    public byte[] robotURLGet(String string, String string2) {
        return this.robotURLGet(string + "?fn=" + string2);
    }

    public byte[] robotURLGet(String string) {
        try {
            BufferedInputStream bufferedInputStream;
            CSDebug.logln("robotURLGet:robot/" + string);
            String string2 = this.Read1stLine("robotbase.cmd");
            if (string2 == null) {
                return null;
            }
            URL uRL = new URL("http://" + string2 + "/robot/" + string);
            URLConnection uRLConnection = uRL.openConnection();
            int n = 1024;
            boolean bl = false;
            byte[] byArray = new byte[n];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            }
            catch (Exception exception) {
                CSDebug.logln("(getInputStream)Exception:" + exception.getMessage());
                return null;
            }
            try {
                int n2;
                while ((n2 = ((InputStream)bufferedInputStream).read(byArray, 0, n)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
            }
            catch (Exception exception) {
                CSDebug.logln("(1st in.read)Exception:" + exception.getMessage());
                return null;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (Exception exception) {
                CSDebug.logln("(in.close)Exception:" + exception.getMessage());
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            CSDebug.logln("Exception:" + exception.getMessage());
            return null;
        }
    }

    class RobotStatusFileFilter
    implements FileFilter {
        RobotStatusFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().startsWith("__db.") || file.getName().endsWith(".db");
        }
    }
}

