/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.admin.ImportConfig;
import com.sun.portal.search.admin.TaxListDumper;
import com.sun.portal.search.admin.resources.SearchResource;
import com.sun.portal.search.rdm.RDMCallback;
import com.sun.portal.search.rdm.RDMTaxonomy;
import com.sun.portal.search.robot.RobotConfig;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class CSConfig {
    protected static String P_FILE = null;
    protected static Properties csconfig = null;
    protected static boolean inited = false;
    protected static boolean searchInited = false;
    static RobotConfig robotConf = null;
    private static RDMTaxonomy taxonomy = null;
    private static String taxonomyFileName = null;
    protected static long taxFileLastModified = -1L;
    protected static String[] taxonomyList = null;
    protected static String[] taxonomyLabelList = null;
    protected static String server_root = null;
    protected static String base = "/var/opt/SUNWps";
    protected static String dynamicURI = "/ps";
    protected static String staticURI = "/ps-static";
    protected static String uri = "/ps";
    protected static String binDir = null;
    protected static String libDir = null;
    protected static String libPath = null;
    protected static ResourceBundle rb = null;
    protected static Locale locale = Locale.US;

    static void checkConfigRefresh() {
        if (taxFileLastModified == -1L) {
            CSConfig.loadTaxonomy();
        } else {
            try {
                File file = new File(taxonomyFileName);
                long l = file.lastModified();
                if (l <= taxFileLastModified) {
                    return;
                }
                CSConfig.loadTaxonomy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void loadTaxonomy() {
        String[] stringArray;
        Serializable serializable;
        try {
            taxonomyFileName = SearchConfig.getValue((String)"taxonomy-description");
            serializable = new File(taxonomyFileName);
            taxFileLastModified = ((File)serializable).lastModified();
            stringArray = new SOIFInputStream(taxonomyFileName);
            taxonomy = new RDMTaxonomy((SOIFInputStream)stringArray);
        }
        catch (Exception exception) {
            taxonomy = new RDMTaxonomy("Search");
        }
        serializable = new ArrayList();
        try {
            taxonomy.apply(1, (RDMCallback)new TaxListDumper((ArrayList)serializable));
            stringArray = new String[]{"a"};
            if (((ArrayList)serializable).size() == 0) {
                taxonomyList = null;
                taxonomyLabelList = null;
                return;
            }
            taxonomyList = ((ArrayList)serializable).toArray(stringArray);
            taxonomyLabelList = ((ArrayList)serializable).toArray(stringArray);
            String string = null;
            try {
                ResourceBundle resourceBundle = SearchResource.getResourceBundle(locale);
                string = resourceBundle.getString("taxonomy.ident.text");
            }
            catch (MissingResourceException missingResourceException) {
                CSDebug.logln("Unable to load ResourceBundle: searchadminmsgs");
            }
            if (string == null) {
                string = "&nbsp;&nbsp;&nbsp;&nbsp;";
            }
            for (int i = 0; taxonomyLabelList != null && i < taxonomyLabelList.length; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(taxonomyLabelList[i], ":");
                String string2 = "";
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    ++n;
                }
                for (int j = 0; j < n - 1; ++j) {
                    string2 = string + string2;
                }
                CSConfig.taxonomyLabelList[i] = string2;
            }
        }
        catch (Exception exception) {
            CSDebug.logln("Exception:" + exception.getMessage());
        }
    }

    public static RDMTaxonomy getTaxonomy() {
        CSConfig.checkConfigRefresh();
        return taxonomy;
    }

    public static String[] getTaxonomyNameList() {
        CSConfig.checkConfigRefresh();
        return taxonomyList;
    }

    public static String[] getTaxonomyLabelList() {
        CSConfig.checkConfigRefresh();
        return taxonomyLabelList;
    }

    public static String getBinPath() {
        if (binDir != null) {
            return binDir;
        }
        return "/opt/SUNWps/bin";
    }

    public static String getLibDir() {
        if (libDir != null) {
            return libDir;
        }
        return "/opt/SUNWps/lib";
    }

    public static String getLibPath() {
        if (libPath != null) {
            return libPath;
        }
        return "/opt/SUNWps/lib";
    }

    public static void setDynamicURI(String string) {
        dynamicURI = string;
    }

    public static void setStaticURI(String string) {
        staticURI = string;
    }

    public static String getDynamicURI() {
        return dynamicURI;
    }

    public static String getStaticURI() {
        return staticURI;
    }

    public static String getServerRoot() {
        if (server_root != null) {
            return server_root;
        }
        String string = System.getProperty("user.dir");
        int n = string.lastIndexOf("config");
        if (n > 0) {
            int n2 = string.lastIndexOf(File.separatorChar, n - 2);
            if (n2 > 0) {
                server_root = base + File.separator + string.substring(n2 + 1, n - 1) + uri;
            }
        } else {
            server_root = base + File.separator + dynamicURI;
        }
        return server_root;
    }

    public static void setServerRoot(String string) {
        server_root = string;
    }

    public static void init(String string) {
        server_root = string;
        CSConfig.initConfig();
    }

    public static void init(String string, String string2) {
        base = string;
        dynamicURI = string2;
        CSConfig.getServerRoot();
        CSConfig.initConfig();
    }

    public static void initSearch(String string) {
        InputStream inputStream;
        Object object;
        CSDebug.logln("initSearch(" + string + ")");
        if (searchInited) {
            return;
        }
        try {
            object = new URL(string);
            URLConnection uRLConnection = ((URL)object).openConnection();
            inputStream = uRLConnection.getInputStream();
        }
        catch (Exception exception) {
            CSDebug.logln("(getInputStream)Exception:" + exception.getMessage());
            return;
        }
        try {
            object = new byte[1024];
            int n = inputStream.read((byte[])object, 0, 1024);
            while (n > 0) {
                n = inputStream.read((byte[])object, 0, 1024);
            }
        }
        catch (Exception exception) {
            CSDebug.logln("(1st in.read)Exception:" + exception.getMessage());
            return;
        }
        searchInited = true;
    }

    public static void initConfig() {
        inited = true;
        SearchConfig searchConfig = SearchConfig.getSearchConfig();
        if (searchConfig == null) {
            try {
                SearchConfig.init((String)(server_root + File.separator + "config" + File.separator + "search.conf"));
                searchConfig = SearchConfig.getSearchConfig();
            }
            catch (Exception exception) {
                CSDebug.logln("Error on SearchConfig.init()");
            }
        }
        if (searchConfig != null) {
            binDir = SearchConfig.getValue((String)"bindir");
            libDir = SearchConfig.getValue((String)"libdir");
            libPath = SearchConfig.getValue((String)"libpath");
            String string = SearchConfig.getValue((String)"admin-debug");
            if (string != null) {
                if (string.equalsIgnoreCase("true")) {
                    CSDebug.setEnable(true);
                } else {
                    CSDebug.setEnable(false);
                }
            }
        }
        robotConf = new RobotConfig(server_root + File.separator + "config");
        try {
            ImportConfig.init(server_root + File.separator + "config" + File.separator + "import.conf");
        }
        catch (Exception exception) {
            CSDebug.logln("Error on ImportConfig.init() " + exception.getMessage());
        }
    }

    public static void setAdminLocale(Locale locale) {
        CSConfig.locale = locale;
    }

    public static Locale getAdminLocale() {
        return locale;
    }

    public static RobotConfig getRobotConfig() {
        return robotConf;
    }

    public static void main(String[] stringArray) {
        CSConfig.init(stringArray[0]);
        for (int i = 0; i < taxonomyList.length; ++i) {
            System.out.println(taxonomyLabelList[i] + "[" + taxonomyList[i] + "]");
        }
    }
}

