/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.admin.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rewriter.admin.model.RewriterModel;
import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.rom.RuleSetManager;
import com.sun.portal.rewriter.services.DataService;
import com.sun.portal.rewriter.services.DataServiceException;
import com.sun.portal.rewriter.services.idsame.IDSAMEDataService;
import com.sun.portal.rewriter.util.Resource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RewriterModelImpl
extends AMModelBase
implements RewriterModel {
    private static final String TOKEN_DELIMITER = "\u0c20";
    private final RuleSetManager rulesetManager;

    public RewriterModelImpl(HttpServletRequest req) {
        super(req, "psrwadminmsg");
        this.resBundle = ResourceBundle.getBundle("psrwadminmsg", this.getUserLocale());
        IDSAMEDataService lDataService = null;
        try {
            lDataService = new IDSAMEDataService(SSOTokenManager.getInstance().createSSOToken(req));
        }
        catch (Exception e) {
            throw new DataServiceException(e.getMessage(), (Throwable)e);
        }
        this.rulesetManager = new RuleSetManager((DataService)lDataService);
    }

    protected String getDelimitedValue(List values) {
        StringBuffer sb = new StringBuffer();
        if (values != null && values.size() > 0) {
            for (int i = 0; i < values.size(); ++i) {
                sb.append((String)values.get(i));
                if (i >= values.size() - 1) continue;
                sb.append(TOKEN_DELIMITER);
            }
        }
        return sb.toString();
    }

    protected List getUnDelimitedValue(String value) {
        StringTokenizer st = new StringTokenizer(value, TOKEN_DELIMITER);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            result.add(token);
        }
        return result;
    }

    public void storeToSession(String name, List values) {
        String delimitedValue = null;
        if (name != null && !name.equals("") && values != null) {
            delimitedValue = this.getDelimitedValue(values);
        }
        try {
            this.ssoToken.setProperty(name, delimitedValue);
        }
        catch (SSOException ssoe) {
            debug.error("RewriterModelImpl.storeToSession() ", (Throwable)ssoe);
        }
    }

    public List getFromSession(String name) {
        String delimitedValue = null;
        try {
            delimitedValue = this.ssoToken.getProperty(name);
        }
        catch (SSOException ssoe) {
            debug.error("RewriterModelImpl.getFromSession() ", (Throwable)ssoe);
        }
        return this.getUnDelimitedValue(delimitedValue);
    }

    public String getRulesetXMLTemplate() {
        String template = Resource.read((String)"/resources/RuleSetTemplate.xml");
        if (template == null) {
            template = "";
            debug.error("RewriterModelImpl.getRulesetXMLTemplate()::Template ruleset XML is null or not found");
        }
        return template;
    }

    public String getRulesetXML(String ruleSetName) {
        String ruleSetXML = "";
        try {
            ruleSetXML = this.rulesetManager.retrieve(ruleSetName);
        }
        catch (Exception e) {
            debug.error("RewriterModelImpl.getRulesetXML()::Failed to retrive XML for ruleset: " + ruleSetName, (Throwable)e);
        }
        return ruleSetXML;
    }

    public boolean isCreateOverwrite(String xml) throws Exception {
        boolean isOverwrite = false;
        try {
            isOverwrite = this.rulesetManager.matchesWithID(xml) != null;
        }
        catch (DataServiceException dse) {
            debug.error("RewriterModelImpl.isCreateOverwrite()", (Throwable)dse);
        }
        catch (InvalidXMLException ixe) {
            if (debug.warningEnabled()) {
                debug.warning("Failed to create a new ruleset:", (Throwable)ixe);
            }
            throw new Exception(this.processException(ixe));
        }
        return isOverwrite;
    }

    public void saveRulesetXML(String xml, boolean isEdit) throws Exception {
        try {
            this.rulesetManager.store(xml);
            if (isEdit) {
                this.logger.doLog(this.getLocalizedString("ruleset.modified"));
                if (debug.messageEnabled()) {
                    debug.message("Ruleset modified");
                }
            } else {
                this.logger.doLog(this.getLocalizedString("ruleset.created"));
                if (debug.messageEnabled()) {
                    debug.message("Ruleset new created");
                }
            }
        }
        catch (InvalidXMLException ixe) {
            if (debug.warningEnabled()) {
                debug.warning("Failed to save ruleset:", (Throwable)ixe);
            }
            throw new Exception(this.processException(ixe));
        }
    }

    public Map deleteRules(List rules) {
        HashMap<String, Exception> failedRules = Collections.EMPTY_MAP;
        if (rules != null && rules.size() > 0) {
            for (int i = 0; i < rules.size(); ++i) {
                String rule = (String)rules.get(i);
                try {
                    this.rulesetManager.delete(rule);
                    this.logger.doLog(this.getLocalizedString("ruleset.deleted") + rule);
                    continue;
                }
                catch (Exception e) {
                    if (((Object)failedRules).equals(Collections.EMPTY_MAP)) {
                        failedRules = new HashMap<String, Exception>();
                    }
                    failedRules.put(rule, e);
                    debug.error("RewriterModelImpl.deleteRules()", (Throwable)e);
                }
            }
        }
        return failedRules;
    }

    public boolean isEditOverwrite(String ruleOrigName, String editedXML) throws Exception {
        boolean isOverwrite = false;
        try {
            String newRuleSetName = this.rulesetManager.matchesWithID(editedXML);
            if (newRuleSetName != null) {
                if (!newRuleSetName.equals(ruleOrigName)) {
                    isOverwrite = true;
                }
            } else {
                this.rulesetManager.delete(ruleOrigName);
            }
        }
        catch (DataServiceException dse) {
            debug.error("RewriterModelImpl.isOverwrite():", (Throwable)dse);
        }
        catch (InvalidXMLException ixe) {
            if (debug.warningEnabled()) {
                debug.warning("Edit ruleset failed:", (Throwable)ixe);
            }
            throw new Exception(this.processException(ixe));
        }
        return isOverwrite;
    }

    public List getRuleSetNames() {
        List<Object> rulesetList = Collections.EMPTY_LIST;
        try {
            Set ruleset = this.rulesetManager.getRuleSetNames();
            Object[] rulesArray = ruleset.toArray();
            Arrays.sort(rulesArray);
            rulesetList = Arrays.asList(rulesArray);
        }
        catch (Exception e) {
            debug.error("RewriterModelImpl.getRuleSetNames(): ", (Throwable)e);
        }
        return rulesetList;
    }

    protected String processException(InvalidXMLException ixe) {
        int code = ixe.getLocaleID();
        Throwable t = ixe.getCause();
        String pattern = null;
        String msg = "";
        switch (code) {
            case 1001: {
                if (t != null && t instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)t;
                    pattern = this.getLocalizedString("saverulemsgbox.saxparseerr.msg");
                    if (pattern == null || pattern == "") break;
                    MessageFormat mf = new MessageFormat(pattern);
                    mf.setLocale(this.getUserLocale());
                    Object[] args = new Object[]{new Integer(spe.getLineNumber()), new Integer(spe.getColumnNumber()), spe.getMessage()};
                    msg = mf.format(args);
                    break;
                }
                if (t != null && t instanceof SAXException) {
                    SAXException se = (SAXException)t;
                    pattern = this.getLocalizedString("saverulemsgbox.saxerr.msg");
                    if (pattern == null || pattern == "") break;
                    MessageFormat mf = new MessageFormat(pattern);
                    mf.setLocale(this.getUserLocale());
                    Object[] arg = new Object[]{se.getMessage()};
                    msg = mf.format(arg);
                    break;
                }
                msg = this.getLocalizedString("saverulemsgbox.generr.msg");
                break;
            }
            case 1002: {
                msg = this.getLocalizedString("saverulemsgbox.keyerr.msg");
                break;
            }
            case 1003: {
                msg = this.getLocalizedString("saverulemsgbox.reptagerr.msg");
                break;
            }
            case 1004: {
                msg = ixe.getErrorInfo() + " " + this.getLocalizedString("saverulemsgbox.invalididerr.msg");
                break;
            }
            default: {
                msg = this.getLocalizedString("saverulemsgbox.generr.msg");
            }
        }
        return msg;
    }

    public String getHelpUrl(String docName) {
        return this.getHelpURL(docName);
    }
}

