/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.admin;

import com.iplanet.am.console.base.model.AMAdminTypes;
import com.iplanet.am.console.base.model.AMI18NUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.jato.util.Encoder;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rewriter.admin.model.RewriterModel;
import com.sun.portal.rewriter.admin.model.RewriterModelImpl;
import com.sun.portal.rewriter.util.xml.Document;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RuleSetServlet
extends HttpServlet {
    private static final String RWSERVLET_SESSION_ATTR = "ps-rwadmin-current-upload-ruleset";
    protected static String loginURL = SystemProperties.get((String)"com.iplanet.am.server.protocol") + "://" + SystemProperties.get((String)"com.iplanet.am.server.host") + ":" + SystemProperties.get((String)"com.iplanet.am.server.port") + SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor") + "/UI/Login";
    private static Debug debug = Debug.getInstance((String)"amConsole");
    private static int TYPE_ERROR = 0;
    private static int TYPE_WARNING = 1;
    private static int TYPE_INFORMATION = 2;
    private SSOToken ssoToken;
    private String psDeployURI;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String reqURI = req.getRequestURI();
        this.psDeployURI = reqURI.substring(0, reqURI.indexOf(47, 1));
        try {
            this.ssoToken = this.checkAuthentication(req);
            int userType = new AMAdminTypes(this.ssoToken).getUserType();
            if (userType != 1) {
                RewriterModelImpl rwm = new RewriterModelImpl(req);
                String msgStr = this.showMessage(TYPE_ERROR, rwm.getLocalizedString("notsuperadminmsgbox.title"), rwm.getLocalizedString("notsuperadminmsgbox.msg"), null);
                Locale locale = rwm.getUserLocale();
                String agentType = rwm.getClientType();
                String contentType = AMI18NUtils.getContentType((String)agentType);
                String charset = AMI18NUtils.getCharset((String)agentType, (Locale)locale);
                resp.setContentType(contentType + ";charset=" + charset);
                PrintWriter out = resp.getWriter();
                out = resp.getWriter();
                out.write(msgStr);
                out.close();
            } else {
                super.service(req, resp);
            }
        }
        catch (SSOException soe) {
            try {
                resp.sendRedirect(loginURL);
                return;
            }
            catch (IOException ioe) {
                throw new ServletException("Cannot redirect to " + loginURL);
            }
        }
    }

    private SSOToken checkAuthentication(HttpServletRequest request) throws SSOException {
        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken ssoToken = manager.createSSOToken(request);
        manager.getInstance().validateToken(ssoToken);
        return ssoToken;
    }

    public String getFromSession(String name) {
        String value = "";
        try {
            value = this.ssoToken.getProperty(name);
        }
        catch (SSOException ssoe) {
            debug.error("RuleSetServlet.getFromSession() ", (Throwable)ssoe);
        }
        return value;
    }

    public void storeToSession(String name, String values) {
        if (name != null && !name.equals("") && values != null) {
            try {
                this.ssoToken.setProperty(name, values);
            }
            catch (SSOException ssoe) {
                debug.error("RuleSetServlet.storeToSession() ", (Throwable)ssoe);
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RewriterModelImpl model = new RewriterModelImpl(request);
        Locale locale = model.getUserLocale();
        String agentType = model.getClientType();
        String contentType = AMI18NUtils.getContentType((String)agentType);
        String encoding = AMI18NUtils.getCharset((String)agentType, (Locale)locale);
        String encodedRuleSetName = request.getParameter("RuleSetName");
        String action = request.getParameter("action");
        if ("NEW".equals(action)) {
            this.showUploadJsp(response, contentType, encoding, request, model);
            return;
        }
        try {
            if (encoding == null || encodedRuleSetName == null) {
                debug.error("RuleSetServlet.doGet :: Illegal Parameters");
                return;
            }
            byte[] decodedBytes = Encoder.decode((String)encodedRuleSetName);
            String ruleSetName = new String(decodedBytes, encoding);
            if (action != null && action.equalsIgnoreCase("getRuleSet")) {
                response.setContentType("application/x-xxxxx; charset=" + encoding);
                response.setHeader("Content-Disposition", "filename=\"RuleSetXML\"");
                PrintWriter out = response.getWriter();
                out = response.getWriter();
                out.write(model.getRulesetXML(ruleSetName));
                out.close();
            } else {
                this.storeToSession(RWSERVLET_SESSION_ATTR, ruleSetName);
                this.showUploadJsp(response, contentType, encoding, request, model);
            }
        }
        catch (Exception e) {
            debug.error("RuleSetServlet.doPost :: Illegal form encoding type");
        }
    }

    private void showUploadJsp(HttpServletResponse response, String aContentType, String aEncoding, HttpServletRequest request, RewriterModel aModel) throws ServletException, IOException {
        response.setContentType(aContentType + ";charset=" + aEncoding);
        request.setAttribute("pageTitle", (Object)aModel.getLocalizedString("HTMLPage.title"));
        request.setAttribute("rewriterLabel", (Object)aModel.getLocalizedString("popup.label.rewriter"));
        request.setAttribute("ruleSetLabel", (Object)aModel.getLocalizedString("popup.label.rulesetxml"));
        request.setAttribute("selectFileLabel", (Object)aModel.getLocalizedString("popup.label.selectFile"));
        request.setAttribute("uploadLabel", (Object)aModel.getLocalizedString("popup.button.upload"));
        request.setAttribute("closeLabel", (Object)aModel.getLocalizedString("popup.button.close"));
        request.setAttribute("psDeployURI", (Object)this.psDeployURI);
        RequestDispatcher rd = request.getRequestDispatcher("/ps/rwadmin/UploadRuleSet.jsp");
        rd.include((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        Hashtable postArgs = null;
        String msgMarkup = "";
        RewriterModelImpl model = new RewriterModelImpl(req);
        Locale locale = model.getUserLocale();
        String agentType = model.getClientType();
        String contentType = AMI18NUtils.getContentType((String)agentType);
        String encoding = AMI18NUtils.getCharset((String)agentType, (Locale)locale);
        String ruleSetName = this.getFromSession(RWSERVLET_SESSION_ATTR);
        if (ruleSetName == null) {
            ruleSetName = "NEW";
        }
        try {
            if (req.getContentType().toLowerCase().startsWith("multipart/form-data")) {
                postArgs = this.parseMultiPartFormData(req.getContentType(), req.getContentLength(), req.getInputStream());
                UploadedFile uf = (UploadedFile)postArgs.get("files");
                if (ruleSetName != null && uf != null && uf.filename != null && uf.filename.length() > 0 && uf.content.length > 0) {
                    String xmlEncoding = Document.parseEncoding((byte[])uf.content);
                    String editedRuleSetXML = new String(uf.content, xmlEncoding);
                    if (!model.isEditOverwrite(ruleSetName, editedRuleSetXML)) {
                        model.saveRulesetXML(editedRuleSetXML, true);
                        msgMarkup = this.showMessage(TYPE_INFORMATION, model.getLocalizedString("popup.uploadsuccess.title"), model.getLocalizedString("popup.uploadsuccess.msg"), model);
                    } else {
                        msgMarkup = this.showMessage(TYPE_ERROR, model.getLocalizedString("popup.uploadfailed.title"), model.getLocalizedString("renameruleerr.msg"), model);
                    }
                } else {
                    msgMarkup = this.showMessage(TYPE_ERROR, model.getLocalizedString("popup.uploadfailed.title"), model.getLocalizedString("popup.nocontent.msg"), model);
                }
            } else {
                debug.error("RuleSetServlet.doPost :: Illegal form encoding type");
                msgMarkup = this.showMessage(TYPE_ERROR, model.getLocalizedString("popup.uploadfailed.title"), model.getLocalizedString("popup.nocontent.msg"), model);
            }
        }
        catch (Exception e) {
            debug.error("RuleSetServlet.doPost ::", (Throwable)e);
            msgMarkup = this.showMessage(TYPE_ERROR, model.getLocalizedString("popup.uploadfailed.title"), model.getLocalizedString(e.getMessage()), model);
        }
        response.setContentType(contentType + ";charset=" + encoding);
        PrintWriter out = response.getWriter();
        out.write(msgMarkup);
        out.close();
    }

    public Hashtable parseMultiPartFormData(String reqContentType, int len, ServletInputStream in) throws IOException, ServletException {
        int ind = reqContentType.indexOf("boundary=");
        String boundary = null;
        if (ind == -1 || (boundary = reqContentType.substring(ind + 9)) == null) {
            throw new ServletException("Missing or invalid boundary parameter in content type");
        }
        int buffSize = 8192;
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        String boundaryStr = "--" + boundary;
        byte[] boundaryBuf = ("\r\n" + boundaryStr).getBytes();
        byte[] b = new byte[buffSize];
        int result = in.readLine(b, 0, b.length);
        if (result == -1) {
            throw new IllegalArgumentException("InputStream truncated");
        }
        len -= result;
        String line = new String(b, 0, result, "ISO-8859-1");
        if (!line.startsWith(boundaryStr)) {
            throw new IllegalArgumentException("MIME boundary missing: " + line);
        }
        while (len > 0) {
            String filename = null;
            String contentType = null;
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            String name = null;
            result = in.readLine(b, 0, b.length);
            if (result == -1) {
                return hash;
            }
            len -= result;
            line = new String(b, 0, result - 2, "ISO-8859-1");
            String lowerline = line.toLowerCase();
            if (!lowerline.startsWith("content-disposition")) continue;
            ind = lowerline.indexOf("content-disposition: ");
            int ind2 = lowerline.indexOf(";");
            if (ind == -1 || ind2 == -1) {
                throw new IllegalArgumentException("Content Disposition line misformatted: " + line);
            }
            String disposition = lowerline.substring(ind + 21, ind2);
            if (!disposition.equals("form-data")) {
                throw new IllegalArgumentException("Content Disposition of " + disposition + " is not supported");
            }
            int ind3 = lowerline.indexOf("name=\"", ind2);
            int ind4 = lowerline.indexOf("\"", ind3 + 7);
            if (ind3 == -1 || ind4 == -1) {
                throw new IllegalArgumentException("Content Disposition line misformatted: " + line);
            }
            name = line.substring(ind3 + 6, ind4);
            int ind5 = lowerline.indexOf("filename=\"", ind4 + 2);
            int ind6 = lowerline.indexOf("\"", ind5 + 10);
            if (ind5 != -1 && ind6 != -1) {
                filename = line.substring(ind5 + 10, ind6);
            }
            if ((result = in.readLine(b, 0, b.length)) == -1) {
                return hash;
            }
            len -= result;
            line = new String(b, 0, result - 2, "ISO-8859-1");
            lowerline = line.toLowerCase();
            if (lowerline.startsWith("content-type")) {
                int ind7 = lowerline.indexOf(" ");
                if (ind7 == -1) {
                    throw new IllegalArgumentException("Content-Type line misformatted: " + line);
                }
                contentType = lowerline.substring(ind7 + 1);
                result = in.readLine(b, 0, b.length);
                if (result == -1) {
                    return hash;
                }
                len -= result;
                line = new String(b, 0, result - 2, "ISO-8859-1");
                if (line.length() != 0) {
                    throw new IllegalArgumentException("Unexpected line in MIMEpart header: " + line);
                }
            } else if (line.length() != 0) {
                throw new IllegalArgumentException("Misformatted line following disposition: " + line);
            }
            boolean readingContent = true;
            byte[] buf = new byte[boundaryBuf.length];
            byte[] c = new byte[1];
            result = in.read(c);
            while (readingContent) {
                if (result == -1) {
                    return hash;
                }
                len -= result;
                if (c[0] == 13) {
                    int i;
                    buf[0] = c[0];
                    for (i = 1; i < boundaryBuf.length && (result = in.read(c)) != -1 && c[0] == boundaryBuf[i]; ++i) {
                        buf[i] = c[0];
                        len -= result;
                    }
                    if (i == boundaryBuf.length) {
                        readingContent = false;
                        in.read(c);
                        if (c[0] == 45) {
                            in.read(c);
                            in.read(c);
                            len -= 2;
                        }
                        in.read(c);
                        len -= 2;
                        continue;
                    }
                    if (result == -1) {
                        return hash;
                    }
                    content.write(buf, 0, i);
                    continue;
                }
                content.write(c);
                result = in.read(c);
            }
            if (filename == null) {
                if (hash.get(name) == null) {
                    String[] values = new String[]{content.toString("UTF-8")};
                    hash.put(name, values);
                    continue;
                }
                Object prevobj = hash.get(name);
                if (prevobj instanceof String[]) {
                    String[] prev = (String[])prevobj;
                    String[] newStr = new String[prev.length + 1];
                    System.arraycopy(prev, 0, newStr, 0, prev.length);
                    newStr[prev.length] = content.toString("UTF-8");
                    hash.put(name, newStr);
                    continue;
                }
                throw new IllegalArgumentException("failure in parseMulti hashtable building code");
            }
            UploadedFile uf = new UploadedFile();
            uf.name = name;
            uf.filename = filename;
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            uf.contentType = contentType;
            uf.content = content.toByteArray();
            hash.put(name, uf);
        }
        return hash;
    }

    private String showMessage(int type, String title, String message, RewriterModel model) {
        StringBuffer buffer = new StringBuffer();
        String cssURI = this.psDeployURI + "/console/css";
        String imageURI = this.psDeployURI + "/console/images";
        buffer.append("\n<html>").append("\n<head>").append("\n<link rel=\"stylesheet\" href=\"" + cssURI + "/adminstyle.css\">").append("\n</head>").append("\n<body>").append("\n<table align=center border=\"0\" cellspacing=\"0\" ").append("cellpadding=\"10\">").append("\n<tr>\n<td>").append("\n<table border=\"0\" cellspacing=\"0\" ").append("cellpadding=\"2\" ").append("class=\"").append(this.getBorderStyle(type)).append("\"").append(">").append("\n<tr>").append("\n<td>").append("\n<table cellspacing=\"0\" cellpadding=\"5\" ").append("border=\"0\" class=\"").append(this.getContentStyle(type)).append("\">").append("\n<tr>").append("\n<td valign=\"top\"><img src=\"").append(this.getTypeIcon(type, imageURI)).append("\" width=\"32\" height=\"32\" border=\"0\">").append("\n</td>").append("\n<td>").append("\n<div class=\"alert-header-text\"><b>").append(title).append("</b></div>").append("\n<div class=\"alert-normal-text\">").append(message).append("</div>").append("\n</td>").append("\n</tr>").append("\n</table>").append("\n</td>").append("\n</tr>").append("\n</table>").append("\n</td>").append("\n</tr>").append("\n</table>");
        if (model != null) {
            String backLabel = model.getLocalizedString("popup.button.back");
            String closeLabel = model.getLocalizedString("popup.button.close");
            buffer.append("\n<table align=center border=0 cellpadding=5 cellspacing=2>").append("\n<tr>").append("\n<td align=right>").append("\n<table border=0 cellpadding=1 cellspacing=0 class=\"button-frame-enabled\">").append("\n<tr><td>").append("\n<table border=0 cellpadding=0 cellspacing=0 width=\"100%\" class=\"button-content-enabled\">").append("\n<tr>").append("\n<td align=\"center\" nowrap>").append("\n<a href=\"javascript:window.history.back()\" class=\"button-link\">").append("\n<span class=\"button-link-enabled-text\">").append(backLabel).append("\n</span>").append("\n</a></td></tr>").append("\n</table>").append("\n</td></tr>").append("\n</table>").append("\n</td>").append("\n<td align=left>").append("\n<table border=0 cellpadding=1 cellspacing=0 class=\"button-frame-enabled\">").append("\n<tr><td>").append("\n<table border=0 cellpadding=0 cellspacing=0 width=\"100%\" class=\"button-content-enabled\">").append("\n<tr>").append("\n<td align=\"center\" nowrap>").append("\n<a href=\"javascript:window.close()\" class=\"button-link\">").append("\n<span class=\"button-link-enabled-text\">").append(closeLabel).append("\n</span>").append("\n</a></td></tr>").append("\n</table>").append("\n</td></tr>").append("\n</table>").append("\n</td>").append("\n</tr>").append("\n</table>");
        }
        buffer.append("\n</body>").append("\n</html>");
        return buffer.toString();
    }

    protected String getTypeIcon(int type, String URI) {
        String image = null;
        image = type == TYPE_WARNING ? URI + "/warning_32_sunplex.gif" : (type == TYPE_INFORMATION ? URI + "/info_32_sunplex.gif" : URI + "/error_32_sunplex.gif");
        return image;
    }

    protected String getContentStyle(int type) {
        String style = null;
        style = type == TYPE_WARNING ? "alert-warning-content" : (type == TYPE_INFORMATION ? "alert-info-content" : "alert-error-content");
        return style;
    }

    protected String getBorderStyle(int type) {
        String style = null;
        style = type == TYPE_WARNING ? "alert-warning-frame" : (type == TYPE_INFORMATION ? "alert-info-frame" : "alert-error-frame");
        return style;
    }

    class UploadedFile {
        public String name;
        public String filename;
        public String contentType;
        public byte[] content;

        UploadedFile() {
        }
    }
}

